/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.XmlvmProcess;
import org.xmlvm.proc.out.OptimizationOutputProcess;
import org.xmlvm.proc.out.XmlvmToXmlvmProcess;

public abstract class XmlvmProcessImpl
implements XmlvmProcess {
    private static final String TAG = XmlvmProcessImpl.class.getSimpleName();
    private List<XmlvmProcess> preprocesses = new ArrayList<XmlvmProcess>();
    private Set<XmlvmProcess> postProcesses = new HashSet<XmlvmProcess>();
    protected List<Class<XmlvmProcess>> supportedInputs = new ArrayList<Class<XmlvmProcess>>();
    protected Arguments arguments;
    protected boolean isProcessed = false;
    protected boolean isTargetProcess = false;

    public XmlvmProcessImpl(Arguments arguments) {
        this.arguments = arguments;
    }

    @Override
    public boolean postProcess() {
        return true;
    }

    @Override
    public List<Class<XmlvmProcess>> getSupportedInputs() {
        return this.supportedInputs;
    }

    protected void addSupportedInput(Class<?> inputProcessClass) {
        try {
            this.supportedInputs.add(inputProcessClass);
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            Log.error("You tried to add a supported input that is not of the same type as the generic type you've specified in the process.");
        }
    }

    protected void addAllXmlvmEmittingProcessesAsInput() {
        if (!this.arguments.option_use_jvm()) {
            this.addSupportedInput(OptimizationOutputProcess.class);
        }
        this.addSupportedInput(XmlvmToXmlvmProcess.class);
    }

    @Override
    public List<XmlvmProcess> createInputInstances() {
        ArrayList<XmlvmProcess> result = new ArrayList<XmlvmProcess>();
        for (Class<XmlvmProcess> supportedClass : this.getSupportedInputs()) {
            try {
                XmlvmProcess process = supportedClass.getConstructor(Arguments.class).newInstance(this.arguments);
                result.add(process);
                this.addPreprocess(process);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                Log.debug(TAG, "Not creating input instance of: " + supportedClass.getName());
            }
        }
        return result;
    }

    @Override
    public boolean supportsAsInput(XmlvmProcess process) {
        for (Class<XmlvmProcess> supportedClass : this.getSupportedInputs()) {
            if (!XmlvmProcessImpl.isOfType(process.getClass(), supportedClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isOfSuperType(Class<?> type) {
        return XmlvmProcessImpl.isOfType(this.getClass(), type);
    }

    private static boolean isOfType(Class<?> a, Class<?> b) {
        if (a == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        return XmlvmProcessImpl.isOfType(a.getSuperclass(), b);
    }

    @Override
    public void addPreprocess(XmlvmProcess xmlvmProcess) {
        Log.debug("Adding preprocess " + xmlvmProcess.getClass().getName() + " to process " + this.getClass().getName());
        this.preprocesses.add(xmlvmProcess);
        xmlvmProcess.addPostProcess(this);
    }

    @Override
    public void addPostProcess(XmlvmProcess xmlvmProcess) {
        this.postProcesses.add(xmlvmProcess);
    }

    @Override
    public boolean forwardOrProcessPhase1(BundlePhase1 resources) {
        for (XmlvmProcess process : this.preprocesses) {
            if (!this.isProcessPreOfCorrectType(process)) {
                return false;
            }
            if (!process.isActive()) continue;
            process.forwardOrProcessPhase1(resources);
        }
        return this.processPhase1(resources);
    }

    @Override
    public boolean forwardOrProcessPhase2(BundlePhase2 resources) {
        for (XmlvmProcess process : this.preprocesses) {
            if (!this.isProcessPreOfCorrectType(process)) {
                return false;
            }
            if (!process.isActive()) continue;
            process.forwardOrProcessPhase2(resources);
        }
        return this.processPhase2(resources);
    }

    @Override
    public boolean postProcessPreProcesses() {
        for (XmlvmProcess process : this.preprocesses) {
            if (!process.isActive() || process.postProcessPreProcesses()) continue;
            return false;
        }
        return this.postProcess();
    }

    @Override
    public boolean isActive() {
        for (XmlvmProcess preprocess : this.preprocesses) {
            if (!preprocess.isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCachedOutput(String inputResourceName, long lastModified) {
        return false;
    }

    @Override
    public boolean isProcessingRequired(String inputResourceName, long lastModified) {
        if (this.hasCachedOutput(inputResourceName, lastModified)) {
            return false;
        }
        if (this.postProcesses.size() == 0) {
            return true;
        }
        for (XmlvmProcess postProcess : this.postProcesses) {
            if (!postProcess.isProcessingRequired(inputResourceName, lastModified)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setIsTargetProcess(boolean isTargetProcess) {
        this.isTargetProcess = isTargetProcess;
    }

    private boolean isProcessPreOfCorrectType(XmlvmProcess process) {
        try {
            process.toString();
            return true;
        }
        catch (ClassCastException ex) {
            Log.error("A preprocess is not of the given generic type: " + process.getClass().getName());
            return false;
        }
    }
}

