/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xmlvm.proc.out.OutputFile;
import org.xmlvm.util.comparators.XmlvmMethodComparator;

public class XmlvmResource {
    private static final String ATTRIBUTE_INTERFACE_TABLE_SIZE = "interfaceTableSize";
    private static final String TAG_CLASS = "class";
    public static Namespace nsXMLVM = Namespace.getNamespace((String)"vm", (String)"http://xmlvm.org");
    public static Namespace nsDEX = Namespace.getNamespace((String)"dex", (String)"http://xmlvm.org/dex");
    public static Namespace nsJVM = Namespace.getNamespace((String)"jvm", (String)"http://xmlvm.org/jvm");
    private final Type type;
    private final Document xmlvmDocument;
    private final Set<String> referencedTypes;
    private final String name;
    private final String superTypeName;
    private final Map<Tag, String> tags = new HashMap<Tag, String>();

    public XmlvmMethod addMethod(XmlvmMethod method) {
        Element clazz = this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM);
        Element clone = (Element)method.methodElement.clone();
        clazz.addContent((Content)clone);
        return new XmlvmMethod(clone);
    }

    public void removeMethod(XmlvmMethod search) {
        List classes = this.xmlvmDocument.getRootElement().getChildren(TAG_CLASS, nsXMLVM);
        for (Element clazz : classes) {
            if (!clazz.removeContent((Content)search.methodElement)) continue;
            return;
        }
    }

    public XmlvmResource(Type type, Document xmlvmDocument) {
        this.type = type;
        this.xmlvmDocument = xmlvmDocument;
        if (type != Type.CONST_POOL) {
            this.referencedTypes = XmlvmResource.extractReferencedTypes(xmlvmDocument);
            Element classElement = xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM);
            this.name = classElement.getAttributeValue("name");
            this.superTypeName = classElement.getAttributeValue("extends");
        } else {
            this.referencedTypes = null;
            this.name = "ConstantPool";
            this.superTypeName = null;
        }
    }

    private static Set<String> extractReferencedTypes(Document xmlvmDocument) {
        HashSet<String> result = new HashSet<String>();
        Element referencesElement = xmlvmDocument.getRootElement().getChild("references", nsXMLVM);
        if (referencesElement == null) {
            return result;
        }
        List references = referencesElement.getChildren("reference", nsXMLVM);
        for (Element reference : references) {
            result.add(reference.getAttributeValue("name"));
        }
        return result;
    }

    public String toString() {
        return this.getFullName();
    }

    public Document getXmlvmDocument() {
        return this.xmlvmDocument;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        String fullResourceName = this.getPackageName();
        if (!fullResourceName.isEmpty()) {
            fullResourceName = fullResourceName + ".";
        }
        fullResourceName = fullResourceName + this.getName();
        return fullResourceName;
    }

    public boolean isAbstract() {
        Element clazz = this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM);
        String flag = clazz.getAttributeValue("isAbstract");
        return flag != null && flag.equals("true");
    }

    public Set<String> getReferencedTypes() {
        return this.referencedTypes;
    }

    public String getSuperTypeName() {
        return this.superTypeName;
    }

    public String getPackageName() {
        if (this.type == Type.CONST_POOL) {
            return "org.xmlvm";
        }
        Element clazz = this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM);
        return clazz.getAttributeValue("package");
    }

    public String getInterfaces() {
        Element clazz = this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM);
        return clazz.getAttributeValue("interfaces");
    }

    public List<XmlvmMethod> getMethods() {
        ArrayList<XmlvmMethod> result = new ArrayList<XmlvmMethod>();
        List<Element> methods = this.getMethodElements();
        for (Element method : methods) {
            result.add(new XmlvmMethod(method));
        }
        return result;
    }

    public List<XmlvmMethod> getMethodsSorted() {
        List<XmlvmMethod> result = this.getMethods();
        Collections.sort(result, new XmlvmMethodComparator());
        return result;
    }

    public List<XmlvmField> getFields() {
        ArrayList<XmlvmField> result = new ArrayList<XmlvmField>();
        List classes = this.xmlvmDocument.getRootElement().getChildren(TAG_CLASS, nsXMLVM);
        for (Element clazz : classes) {
            List fields = clazz.getChildren("field", nsXMLVM);
            for (Element field : fields) {
                result.add(new XmlvmField(field));
            }
        }
        return result;
    }

    public boolean isInterface() {
        return Boolean.parseBoolean(this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM).getAttributeValue("isInterface"));
    }

    private List<Element> getMethodElements() {
        ArrayList<Element> result = new ArrayList<Element>();
        List classes = this.xmlvmDocument.getRootElement().getChildren(TAG_CLASS, nsXMLVM);
        for (Element clazz : classes) {
            result.addAll(clazz.getChildren("method", nsXMLVM));
        }
        return result;
    }

    public void setVtableSize(int vtableSize) {
        List classes = this.xmlvmDocument.getRootElement().getChildren(TAG_CLASS, nsXMLVM);
        if (classes.size() != 1) {
            System.err.println("XmlvmResource.setVtableSize(): cannot deal with multiple classes");
            System.exit(-1);
        }
        ((Element)classes.get(0)).setAttribute("vtableSize", "" + vtableSize);
    }

    public XmlvmItable createItable() {
        Element itableElement = new Element("itable", nsXMLVM);
        this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM).addContent((Content)itableElement);
        return new XmlvmItable(itableElement);
    }

    public void collectInstructions(List<XmlvmInvokeInstruction> invokeInstructions, List<XmlvmMemberReadWrite> readWriteInstructions) {
        Element root = this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM);
        Iterator iter = root.getDescendants();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Element)) continue;
            Element elem = (Element)o;
            String name = elem.getName();
            if (name.startsWith("invoke-static") || name.startsWith("invoke-super")) {
                invokeInstructions.add(new XmlvmInvokeInstruction(elem));
            }
            if (!name.startsWith("iput") && !name.startsWith("iget") && !name.startsWith("sput") && !name.startsWith("sget")) continue;
            readWriteInstructions.add(new XmlvmMemberReadWrite(elem));
        }
    }

    public void collectInstructions(List<XmlvmConstantStringElement> constStringInstructions) {
        Element root = this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM);
        Iterator iter = root.getDescendants();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Element)) continue;
            Element elem = (Element)o;
            if (elem.getName().equals("const-string")) {
                constStringInstructions.add(new XmlvmConstantStringElement(elem));
            }
            if (!elem.getName().equals("field") || !elem.getAttributeValue("type").equals("java.lang.String") || elem.getAttributeValue("value") == null) continue;
            constStringInstructions.add(new XmlvmConstantStringElement(elem));
        }
    }

    public static XmlvmResource fromFile(OutputFile file) {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build((InputStream)new ByteArrayInputStream(file.getDataAsBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new XmlvmResource(Type.DEX, doc);
    }

    public void createImplementsInterface(String fullName) {
        Element implementsInterfaceElement = new Element("implementsInterface", nsXMLVM);
        implementsInterfaceElement.setAttribute("name", fullName);
        this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM).addContent((Content)implementsInterfaceElement);
    }

    public void addInterfaceField(String definingInterface, XmlvmField field) {
        Element classElement = this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM);
        if (classElement == null) {
            return;
        }
        Element interfaceFieldElement = new Element("field", nsXMLVM);
        interfaceFieldElement.setAttribute("name", field.getName());
        interfaceFieldElement.setAttribute("type", field.getType());
        interfaceFieldElement.setAttribute("isPublic", "true");
        interfaceFieldElement.setAttribute("isStatic", "true");
        interfaceFieldElement.setAttribute("definingInterface", definingInterface);
        classElement.addContent((Content)interfaceFieldElement);
    }

    public void setTag(Tag tag, String tagValue) {
        this.tags.put(tag, tagValue);
    }

    public boolean hasTag(Tag tag) {
        return this.tags.containsKey((Object)tag);
    }

    public String getTagValue(Tag tag) {
        return this.tags.get((Object)tag);
    }

    public Integer getInterfaceTableSize() {
        Element clazz = this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM);
        String interfaceTableSize = clazz.getAttributeValue(ATTRIBUTE_INTERFACE_TABLE_SIZE);
        return interfaceTableSize == null ? null : Integer.valueOf(Integer.parseInt(interfaceTableSize));
    }

    public void setInterfaceTableSize(Integer interfaceTableSize) {
        Element clazz = this.xmlvmDocument.getRootElement().getChild(TAG_CLASS, nsXMLVM);
        clazz.setAttribute(ATTRIBUTE_INTERFACE_TABLE_SIZE, interfaceTableSize == null ? null : String.valueOf(interfaceTableSize));
    }

    public class XmlvmItable {
        private Element itableElement;

        public XmlvmItable(Element itableElement) {
            this.itableElement = itableElement;
        }

        public void addVtableMapping(String ifaceName, XmlvmMethod ifaceMethod, int vtableIndex) {
            Element map = new Element("vtable-map", nsXMLVM);
            map.setAttribute("ifaceName", ifaceName);
            map.setAttribute("ifaceMethodName", ifaceMethod.getName());
            Element signature = (Element)ifaceMethod.methodElement.getChild("signature", nsXMLVM).clone();
            map.addContent((Content)signature);
            map.setAttribute("vtableIndex", "" + vtableIndex);
            this.itableElement.addContent((Content)map);
        }

        public void addDirectMapping(String ifaceName, XmlvmMethod ifaceMethod, String classType) {
            Element map = new Element("direct-map", nsXMLVM);
            map.setAttribute("ifaceName", ifaceName);
            map.setAttribute("ifaceMethodName", ifaceMethod.getName());
            Element signature = (Element)ifaceMethod.methodElement.getChild("signature", nsXMLVM).clone();
            map.addContent((Content)signature);
            map.setAttribute("className", classType);
            this.itableElement.addContent((Content)map);
        }
    }

    public class XmlvmField {
        public Element fieldElement;

        public XmlvmField(Element fieldElement) {
            this.fieldElement = fieldElement;
        }

        public String getName() {
            return this.fieldElement.getAttributeValue("name");
        }

        public String getType() {
            return this.fieldElement.getAttributeValue("type");
        }

        public boolean isPrivate() {
            String flag = this.fieldElement.getAttributeValue("isPrivate");
            return flag != null && flag.equals("true");
        }

        public boolean isProtected() {
            String flag = this.fieldElement.getAttributeValue("isProtected");
            return flag != null && flag.equals("true");
        }

        public boolean isPublic() {
            String flag = this.fieldElement.getAttributeValue("isPublic");
            return flag != null && flag.equals("true");
        }

        public boolean matchesName(XmlvmMemberReadWrite instruction) {
            return this.getName().equals(instruction.getMemberName());
        }

        public boolean matchesDeclaration(XmlvmField field) {
            return this.getName().equals(field.getName()) && this.getType().equals(field.getType());
        }
    }

    public class XmlvmMethod {
        public Element methodElement;

        public XmlvmMethod(Element methodElement) {
            this.methodElement = methodElement;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return new XMLOutputter().outputString(this.methodElement);
        }

        public String getName() {
            return this.methodElement.getAttributeValue("name");
        }

        public List<XmlvmInvokeInstruction> getVtableInvokeInstructions() {
            ArrayList<XmlvmInvokeInstruction> invokeInstructions = new ArrayList<XmlvmInvokeInstruction>();
            this.searchForVtableInvokeInstructions(invokeInstructions, this.methodElement);
            return invokeInstructions;
        }

        private void searchForVtableInvokeInstructions(List<XmlvmInvokeInstruction> invokeInstructions, Element element) {
            XmlvmInvokeInstruction invoke;
            List children = element.getChildren("invoke-virtual", nsDEX);
            for (Element instruction : children) {
                invoke = new XmlvmInvokeInstruction(instruction);
                invokeInstructions.add(invoke);
            }
            children = element.getChildren("invoke-virtual-range", nsDEX);
            for (Element instruction : children) {
                invoke = new XmlvmInvokeInstruction(instruction);
                invokeInstructions.add(invoke);
            }
            children = element.getChildren();
            for (Element node : children) {
                this.searchForVtableInvokeInstructions(invokeInstructions, node);
            }
        }

        public boolean doesOverrideMethod(XmlvmMethod method) {
            return this.doesOverrideMethod(method.getName(), method.methodElement.getChild("signature", nsXMLVM).getChildren("parameter", nsXMLVM));
        }

        public boolean doesOverrideMethod(XmlvmInvokeInstruction instruction) {
            return this.doesOverrideMethod(instruction.getMethodName(), instruction.invokeElement.getChild("parameters", nsDEX).getChildren("parameter", nsDEX));
        }

        private boolean doesOverrideMethod(String methodName, List<Element> parameters) {
            if (!this.getName().equals(methodName)) {
                return false;
            }
            Element mySignature = this.methodElement.getChild("signature", nsXMLVM);
            List myParameters = mySignature.getChildren("parameter", nsXMLVM);
            if (myParameters.size() != parameters.size()) {
                return false;
            }
            for (int i = 0; i < myParameters.size(); ++i) {
                String otherParameterType;
                String myParameterType = ((Element)myParameters.get(i)).getAttributeValue("type");
                if (myParameterType.equals(otherParameterType = parameters.get(i).getAttributeValue("type"))) continue;
                return false;
            }
            return true;
        }

        public boolean isStatic() {
            String flag = this.methodElement.getAttributeValue("isStatic");
            return flag != null && flag.equals("true");
        }

        public boolean isPrivate() {
            String flag = this.methodElement.getAttributeValue("isPrivate");
            return flag != null && flag.equals("true");
        }

        public boolean isProtected() {
            String flag = this.methodElement.getAttributeValue("isProtected");
            return flag != null && flag.equals("true");
        }

        public boolean isPublic() {
            String flag = this.methodElement.getAttributeValue("isPublic");
            return flag != null && flag.equals("true");
        }

        public boolean isAbstract() {
            String flag = this.methodElement.getAttributeValue("isAbstract");
            return flag != null && flag.equals("true");
        }

        public boolean isNative() {
            String flag = this.methodElement.getAttributeValue("isNative");
            return flag != null && flag.equals("true");
        }

        public boolean isConstructor() {
            return this.methodElement.getAttributeValue("name").equals("<init>");
        }

        public boolean isSynthetic() {
            String flag = this.methodElement.getAttributeValue("isSynthetic");
            return flag != null && flag.equals("true");
        }

        public void setSynthetic(boolean flag) {
            if (flag) {
                this.methodElement.setAttribute("isSynthetic", "true");
            } else {
                this.methodElement.removeAttribute("isSynthetic");
            }
        }

        public boolean isOverriding() {
            String flag = this.methodElement.getAttributeValue("isOverriding");
            return flag != null && flag.equals("true");
        }

        public void setOverriding(boolean overriding) {
            this.methodElement.setAttribute("isOverriding", Boolean.toString(overriding));
        }

        public void setVtableIndex(int idx) {
            this.methodElement.setAttribute("vtableIndex", "" + idx);
        }

        public List<String> getParameterTypes() {
            Element signature = this.methodElement.getChild("signature", nsXMLVM);
            List parameterList = signature.getChildren("parameter", nsXMLVM);
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (Element parameter : parameterList) {
                parameterTypes.add(parameter.getAttributeValue("type"));
            }
            return parameterTypes;
        }

        public Integer getInterfaceTableIndex() {
            Integer interfaceTableIndex = null;
            String strVal = this.methodElement.getAttributeValue("itableIndex");
            if (strVal != null) {
                try {
                    interfaceTableIndex = Integer.parseInt(strVal);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return interfaceTableIndex;
        }

        public void setInterfaceTableIndex(Integer interfaceTableIndex) {
            this.methodElement.setAttribute("itableIndex", interfaceTableIndex == null ? "" : interfaceTableIndex.toString());
        }
    }

    public class XmlvmMemberReadWrite {
        public Element memberReadWriteElement;

        public XmlvmMemberReadWrite(Element memberReadWriteElement) {
            this.memberReadWriteElement = memberReadWriteElement;
        }

        public String toString() {
            return new XMLOutputter().outputString(this.memberReadWriteElement);
        }

        public String getMemberName() {
            return this.memberReadWriteElement.getAttributeValue("member-name");
        }

        public void setClassType(String type) {
            this.memberReadWriteElement.setAttribute("class-type", type);
        }

        public String getClassType() {
            return this.memberReadWriteElement.getAttributeValue("class-type");
        }
    }

    public class XmlvmConstantStringElement {
        private Element element;

        public XmlvmConstantStringElement(Element element) {
            this.element = element;
        }

        public String getEscapedStringConstant() {
            return this.element.getAttributeValue("value");
        }

        public String getEncodedStringConstant() {
            return this.element.getAttributeValue("encoded-value");
        }

        public int getLength() {
            return Integer.parseInt(this.element.getAttributeValue("length"));
        }

        public void setContantPoolID(int id) {
            this.element.setAttribute("id", "" + id);
        }
    }

    public class XmlvmInvokeInstruction {
        public Element invokeElement;

        public XmlvmInvokeInstruction(Element invokeElement) {
            this.invokeElement = invokeElement;
        }

        public String toString() {
            return new XMLOutputter().outputString(this.invokeElement);
        }

        public String getClassType() {
            return this.invokeElement.getAttributeValue("class-type");
        }

        public String getMethodName() {
            return this.invokeElement.getAttributeValue("method");
        }

        public void setVtableIndex(int vtableIndex) {
            this.invokeElement.setAttribute("vtable-index", "" + vtableIndex);
        }

        public void setClassType(String type) {
            this.invokeElement.setAttribute("class-type", type);
        }

        public List<String> getParameterTypes() {
            Element signature = this.invokeElement.getChild("parameters", nsDEX);
            List parameterList = signature.getChildren("parameter", nsDEX);
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (Element parameter : parameterList) {
                parameterTypes.add(parameter.getAttributeValue("type"));
            }
            return parameterTypes;
        }
    }

    public static enum Tag {
        SKELETON_ONLY;

    }

    public static enum Type {
        JVM,
        CLI,
        CLI_DFA,
        DEX,
        CONST_POOL;

    }
}

