/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.in;

import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.XmlvmProcessImpl;
import org.xmlvm.proc.in.file.ClassFile;
import org.xmlvm.proc.in.file.ExeFile;
import org.xmlvm.proc.in.file.XFile;
import org.xmlvm.proc.in.file.XmlvmFile;
import org.xmlvm.proc.out.OutputFile;

public abstract class InputProcess<T extends XFile>
extends XmlvmProcessImpl {
    protected T input;

    public InputProcess(Arguments arguments, T input) {
        super(arguments);
        this.input = input;
    }

    public T getInputFile() {
        return this.input;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean processPhase1(BundlePhase1 bundle) {
        if (this.input == null || ((XFile)this.input).getFile() == null) {
            Log.warn("InputProcess.getOutputFiles(): Input File is null.");
            return false;
        }
        if (!((XFile)this.input).getFile().exists() || !((XFile)this.input).getFile().isFile()) {
            Log.warn("InputProcess.getOutputFiles(): Input File " + ((XFile)this.input).getFile() + "does not exist or is not a file.");
            return false;
        }
        OutputFile outputFile = new OutputFile(((XFile)this.input).getFile());
        outputFile.setOrigin(((XFile)this.input).getFile().getAbsolutePath());
        outputFile.setLocation(this.arguments.option_out());
        outputFile.setFileName(((XFile)this.input).getFile().getName());
        bundle.addOutputFile(outputFile);
        return true;
    }

    @Override
    public boolean processPhase2(BundlePhase2 bundle) {
        return true;
    }

    public static class XmlvmInputProcess
    extends InputProcess<XmlvmFile> {
        public XmlvmInputProcess(Arguments arguments, XmlvmFile input) {
            super(arguments, input);
        }
    }

    public static class ExeInputProcess
    extends InputProcess<ExeFile> {
        public ExeInputProcess(Arguments arguments, ExeFile input) {
            super(arguments, input);
        }
    }

    public static class ClassInputProcess
    extends InputProcess<ClassFile> {
        public ClassInputProcess(Arguments arguments, ClassFile input) {
            super(arguments, input);
        }
    }

    public static class EmptyInputProcess
    extends InputProcess<ClassFile> {
        public static final String EMPTY_INPUT_IN_ARGUMENT = "<<EMPTY_INPUT>>";

        public EmptyInputProcess() {
            super(null, null);
        }
    }
}

