/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.in;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.in.InputProcess;
import org.xmlvm.proc.in.ZipArchiveExtractor;
import org.xmlvm.proc.in.file.ClassFile;
import org.xmlvm.proc.in.file.Directory;
import org.xmlvm.proc.in.file.ExeFile;
import org.xmlvm.proc.in.file.ResourceList;
import org.xmlvm.proc.in.file.XmlvmFile;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class InputProcessFactory {
    private static final String TAG = InputProcessFactory.class.getSimpleName();
    private Arguments arguments;

    public InputProcessFactory(Arguments arguments) {
        this.arguments = arguments;
    }

    public List<InputProcess<?>> createInputProcesses(List<String> inputElements) {
        ArrayList processes = new ArrayList();
        if (inputElements.isEmpty()) {
            processes.add(new InputProcess.EmptyInputProcess());
            return processes;
        }
        for (String inputElement : inputElements) {
            if (Directory.isDirectoryInput(inputElement)) {
                processes.addAll(this.createInputProcessesForDirectory(new Directory(inputElement)));
                continue;
            }
            if (ZipArchiveExtractor.isZipArchive(inputElement)) {
                for (UniversalFile file : ZipArchiveExtractor.createFilesForArchive(inputElement)) {
                    processes.add(this.createInputProcess(file));
                }
                continue;
            }
            UniversalFile file = UniversalFileCreator.createFile(new File(inputElement));
            if (file != null) {
                processes.add(this.createInputProcess(file));
                continue;
            }
            Log.error(TAG, "Could not find input resource: " + inputElement);
        }
        return processes;
    }

    public List<InputProcess<?>> createInputProcessesFromFiles(List<UniversalFile> inputFiles) {
        ArrayList processes = new ArrayList();
        for (UniversalFile inputFile : inputFiles) {
            InputProcess<?> inputProcess = this.createInputProcess(inputFile);
            if (inputProcess == null) continue;
            processes.add(inputProcess);
        }
        return processes;
    }

    protected InputProcess<?> createInputProcess(UniversalFile input) {
        if (ClassFile.isClassInput(input)) {
            return new InputProcess.ClassInputProcess(this.arguments, new ClassFile(input));
        }
        if (ExeFile.isExeInput(input)) {
            return new InputProcess.ExeInputProcess(this.arguments, new ExeFile(input));
        }
        if (XmlvmFile.isXmlvmInput(input)) {
            return new InputProcess.XmlvmInputProcess(this.arguments, new XmlvmFile(input));
        }
        if (!ResourceList.isResourceList(input)) {
            Log.warn("Unable to create InputProcesses for input: " + input);
        }
        return null;
    }

    protected List<InputProcess<?>> createInputProcessesForDirectory(Directory input) {
        ArrayList result = new ArrayList();
        List<File> files = input.getAllMatchingFiles();
        for (File file : files) {
            if (input.equals(file)) continue;
            result.add(this.createInputProcess(UniversalFileCreator.createFile(file)));
        }
        return result;
    }
}

