/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.in;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xmlvm.Log;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class ZipArchiveExtractor {
    private static final String TAG = "ZipInputProcessFactory";
    private static final String[] SUPPORTED_TYPES = new String[]{"zip", "jar"};

    public static boolean isZipArchive(String filename) {
        for (String supportedType : SUPPORTED_TYPES) {
            if (!filename.toLowerCase().endsWith("." + supportedType)) continue;
            return true;
        }
        return false;
    }

    public static List<UniversalFile> createFilesForArchive(String location) {
        Log.debug(TAG, "Creating input processes for archive: " + location);
        ArrayList<UniversalFile> result = new ArrayList<UniversalFile>();
        File archiveFile = new File(location);
        if (!archiveFile.exists() || !archiveFile.isFile()) {
            Log.error(TAG, "Could not find archive file: " + location);
            return result;
        }
        try {
            ZipEntry entry;
            ZipInputStream zipStream = new ZipInputStream(new FileInputStream(archiveFile));
            byte[] data = new byte[4096];
            while ((entry = zipStream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                int len = 0;
                while ((len = zipStream.read(data)) != -1) {
                    outputStream.write(data, 0, len);
                }
                String name = archiveFile.getAbsolutePath() + File.separator + entry.getName();
                result.add(UniversalFileCreator.createFile(name, new ByteArrayInputStream(outputStream.toByteArray()), entry.getTime()));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Log.error(TAG, "Could not find archive: " + location);
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error(TAG, "Error reading archive: " + location);
        }
        return result;
    }
}

