/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.CompilationBundle;
import org.xmlvm.proc.XmlvmResource;
import org.xmlvm.proc.in.InputProcess;
import org.xmlvm.proc.in.file.ClassFile;
import org.xmlvm.proc.lib.Libraries;
import org.xmlvm.proc.out.DEXmlvmOutputProcess;
import org.xmlvm.util.universalfile.FileSuffixFilter;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class LibraryLoader {
    private static final String TAG = LibraryLoader.class.getSimpleName();
    private static final String BIN_PROXIES_PATH = "bin-proxies";
    private static final String BIN_PROXIES_ONEJAR_PATH = "/lib/proxies-java.jar";
    private static final Map<String, UniversalFile> proxies = null;
    private final Libraries libs;
    private final Arguments arguments;
    private static final Map<String, XmlvmResource> cache = new HashMap<String, XmlvmResource>();
    private List<UniversalFile> libraries = null;

    public LibraryLoader(Arguments arguments) {
        this.arguments = arguments;
        this.libs = new Libraries(arguments);
    }

    public static boolean hasProxy(String typeName) {
        return proxies != null && proxies.containsKey(typeName);
    }

    public static UniversalFile getProxy(String typename) {
        return proxies.get(typename);
    }

    public long getLastModified() {
        long lastModified = this.libs.getLastModified();
        for (UniversalFile proxyFile : proxies.values()) {
            lastModified = Math.max(lastModified, proxyFile.getLastModified());
        }
        return lastModified;
    }

    public XmlvmResource load(String typeName) {
        if (proxies.containsKey(typeName)) {
            return this.processClassFile(proxies.get(typeName), false);
        }
        if (this.libraries == null) {
            this.libraries = new ArrayList<UniversalFile>();
            this.libraries.addAll(this.libs.getMonolithicLibraryFiles());
            this.libraries.addAll(this.libs.getLibraryFiles());
        }
        for (UniversalFile library : this.libraries) {
            XmlvmResource resource = this.load(typeName, library);
            if (resource == null) continue;
            return resource;
        }
        Log.debug(TAG, "Could not find resource: " + typeName);
        return null;
    }

    private XmlvmResource load(String typeName, UniversalFile directory) {
        if (directory != null) {
            if (typeName.contains(".")) {
                String packageName = typeName.substring(0, typeName.indexOf("."));
                UniversalFile subDir = directory.getEntry(packageName);
                if (subDir != null && subDir.isDirectory()) {
                    return this.load(typeName.substring(typeName.indexOf(".") + 1), subDir);
                }
                return null;
            }
            UniversalFile classFile = directory.getEntry(typeName + ".class");
            if (classFile != null && classFile.isFile()) {
                return this.processClassFile(classFile, true);
            }
            return null;
        }
        return null;
    }

    private XmlvmResource processClassFile(UniversalFile file, boolean enableRedList) {
        if (cache.containsKey(file.getAbsolutePath())) {
            return cache.get(file.getAbsolutePath());
        }
        ClassFile classFile = new ClassFile(file);
        InputProcess.ClassInputProcess inputProcess = new InputProcess.ClassInputProcess(this.arguments, classFile);
        DEXmlvmOutputProcess outputProcess = new DEXmlvmOutputProcess(this.arguments, enableRedList, false);
        outputProcess.addPreprocess(inputProcess);
        CompilationBundle bundle = new CompilationBundle();
        inputProcess.processPhase1(bundle);
        outputProcess.processPhase1(bundle);
        if (bundle.getResources().size() != 1) {
            return null;
        }
        XmlvmResource resource = bundle.getResources().iterator().next();
        cache.put(file.getAbsolutePath(), resource);
        return resource;
    }

    public void loadAllReferencedTypes(Map<String, XmlvmResource> resources) {
        long startTime = System.currentTimeMillis();
        while (!this.loadReferencedTypes(resources)) {
        }
        long endTime = System.currentTimeMillis();
        Log.debug(TAG, "Processing took: " + (endTime - startTime) + " ms.");
    }

    public List<XmlvmResource> loadMonolithicLibraries() {
        ArrayList<XmlvmResource> result = new ArrayList<XmlvmResource>();
        for (UniversalFile library : this.libs.getMonolithicLibraryFiles()) {
            for (UniversalFile file : library.listFilesRecursively(new FileSuffixFilter(".class"))) {
                XmlvmResource resource = this.processClassFile(file, true);
                if (resource == null) continue;
                result.add(resource);
            }
        }
        return result;
    }

    private boolean loadReferencedTypes(Map<String, XmlvmResource> resources) {
        String[] classesToLoad;
        HashSet<String> toLoad = new HashSet<String>();
        for (String typeName : resources.keySet()) {
            XmlvmResource resource = resources.get(typeName);
            if (resource == null) continue;
            Log.debug("***********************************");
            Log.debug("XMLVM Resource: " + resource.getFullName());
            Log.debug("Super-type    : " + resource.getSuperTypeName());
            Log.debug("Referenced types:");
            Set<String> referencedTypes = resource.getReferencedTypes();
            LibraryLoader.eliminateArrayTypes(referencedTypes);
            for (String referencedType : referencedTypes) {
                if (LibraryLoader.isBasicType(referencedType)) continue;
                if (resources.keySet().contains(referencedType)) {
                    Log.debug(" OK   -> " + referencedType);
                    continue;
                }
                toLoad.add(referencedType);
                Log.debug(" LOAD -> " + referencedType);
            }
        }
        if (toLoad.isEmpty()) {
            return true;
        }
        for (String classToLoad : classesToLoad = toLoad.toArray(new String[0])) {
            resources.put(classToLoad, this.load(classToLoad));
        }
        return classesToLoad.length == 0;
    }

    private static boolean isBasicType(String typeName) {
        HashSet<String> basicTypes = new HashSet<String>();
        basicTypes.add("");
        basicTypes.add("byte");
        basicTypes.add("char");
        basicTypes.add("short");
        basicTypes.add("int");
        basicTypes.add("float");
        basicTypes.add("long");
        basicTypes.add("double");
        basicTypes.add("boolean");
        basicTypes.add("void");
        basicTypes.add("null");
        return basicTypes.contains(typeName);
    }

    private static void eliminateArrayTypes(Set<String> types) {
        HashSet<String> add = new HashSet<String>();
        HashSet<String> remove = new HashSet<String>();
        for (String typeName : types) {
            if (!typeName.endsWith("[]")) continue;
            remove.add(typeName);
            int p = typeName.indexOf(91);
            add.add(typeName.substring(0, p));
        }
        for (String typeName : remove) {
            types.remove(typeName);
        }
        for (String typeName : add) {
            types.add(typeName);
        }
    }

    private static Map<String, UniversalFile> initializeProxies() {
        HashMap<String, UniversalFile> result = new HashMap<String, UniversalFile>();
        UniversalFile basePath = UniversalFileCreator.createDirectory(BIN_PROXIES_ONEJAR_PATH, BIN_PROXIES_PATH);
        if (basePath == null) {
            Log.debug(TAG, "Proxies not loaded, therefore there will be no proxy replacement");
            return result;
        }
        String classEnding = ".class";
        FileSuffixFilter classFilter = new FileSuffixFilter(".class");
        for (UniversalFile proxyFile : basePath.listFilesRecursively(classFilter)) {
            String proxyFileName = proxyFile.getRelativePath(basePath.getAbsolutePath());
            String proxyTypeName = proxyFileName.substring(0, proxyFileName.length() - ".class".length()).replace(File.separatorChar, '.');
            result.put(proxyTypeName, proxyFile);
        }
        return result;
    }

    private static long getLastModifiedProxy() {
        long result = 0L;
        for (UniversalFile proxyFile : proxies.values()) {
            long lastModified = proxyFile.getLastModified();
            if (lastModified <= result) continue;
            result = lastModified;
        }
        return result;
    }
}

