/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out;

import com.android.dx.cf.attrib.AttEnclosingMethod;
import com.android.dx.cf.attrib.AttSignature;
import com.android.dx.cf.attrib.BaseAnnotations;
import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.code.Ropper;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.cf.iface.AttributeList;
import com.android.dx.cf.iface.Field;
import com.android.dx.cf.iface.FieldList;
import com.android.dx.cf.iface.Method;
import com.android.dx.cf.iface.MethodList;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.dex.code.ArrayData;
import com.android.dx.dex.code.CatchHandlerList;
import com.android.dx.dex.code.CatchTable;
import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.DalvInsnList;
import com.android.dx.dex.code.Dop;
import com.android.dx.dex.code.Dops;
import com.android.dx.dex.code.HighRegisterPrefix;
import com.android.dx.dex.code.LocalSnapshot;
import com.android.dx.dex.code.LocalStart;
import com.android.dx.dex.code.OddSpacer;
import com.android.dx.dex.code.RopTranslator;
import com.android.dx.dex.code.SimpleInsn;
import com.android.dx.dex.code.SwitchData;
import com.android.dx.dex.code.TargetInsn;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.annotation.NameValuePair;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.code.DexTranslationAdvice;
import com.android.dx.rop.code.LocalVariableExtractor;
import com.android.dx.rop.code.LocalVariableInfo;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstAnnotation;
import com.android.dx.rop.cst.CstArray;
import com.android.dx.rop.cst.CstBaseMethodRef;
import com.android.dx.rop.cst.CstBoolean;
import com.android.dx.rop.cst.CstMemberRef;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.CstUtf8;
import com.android.dx.rop.cst.TypedConstant;
import com.android.dx.rop.type.Prototype;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.ssa.Optimizer;
import com.android.dx.util.ExceptionWithContext;
import com.android.dx.util.IntList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.RuntimeErrorException;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.xmlvm.Log;
import org.xmlvm.XMLVMDelegate;
import org.xmlvm.XMLVMDelegateMethod;
import org.xmlvm.XMLVMIgnore;
import org.xmlvm.XMLVMSkeletonOnly;
import org.xmlvm.main.Arguments;
import org.xmlvm.main.Targets;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.DelayedXmlvmSerializationProvider;
import org.xmlvm.proc.ResourceCache;
import org.xmlvm.proc.XmlvmProcessImpl;
import org.xmlvm.proc.XmlvmResource;
import org.xmlvm.proc.in.InputProcess;
import org.xmlvm.proc.lib.LibraryLoader;
import org.xmlvm.proc.out.JavaByteCodeOutputProcess;
import org.xmlvm.proc.out.OutputFile;
import org.xmlvm.refcount.InstructionProcessor;
import org.xmlvm.refcount.ReferenceCounting;
import org.xmlvm.refcount.ReferenceCountingException;
import org.xmlvm.util.ClassListLoader;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class DEXmlvmOutputProcess
extends XmlvmProcessImpl {
    private static final String TAG = DEXmlvmOutputProcess.class.getSimpleName();
    private static final boolean LOTS_OF_DEBUG = false;
    private static final boolean REF_LOGGING = false;
    private static final String JLO = "java.lang.Object";
    private static final String DEXMLVM_ENDING = ".dexmlvm";
    private static final Namespace NS_XMLVM = XmlvmResource.nsXMLVM;
    private static final Namespace NS_DEX = Namespace.getNamespace((String)"dex", (String)"http://xmlvm.org/dex");
    private static final UniversalFile RED_LIST_FILE = null;
    private boolean useRedList = true;
    private boolean noGenRedClass = false;
    private boolean enableProxyReplacement = true;
    private static Set<String> redTypes = null;
    private static Set<String> greenTypes = null;
    private Element lastDexInstruction = null;
    private ResourceCache cache = ResourceCache.getCache(DEXmlvmOutputProcess.class.getName());
    private List<OutputFile> filesFromCache = new ArrayList<OutputFile>();
    private static final Set<String> INVALID_REFERENCES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("void", "char", "float", "double", "int", "boolean", "short", "byte", "float", "long", "null")));

    public DEXmlvmOutputProcess(Arguments arguments) {
        this(arguments, true, true);
    }

    public DEXmlvmOutputProcess(Arguments arguments, boolean noGenRedClass, boolean enableProxyReplacement) {
        super(arguments);
        this.addSupportedInput(InputProcess.ClassInputProcess.class);
        this.addSupportedInput(JavaByteCodeOutputProcess.class);
        if (redTypes == null) {
            UniversalFile redlist = RED_LIST_FILE;
            if (arguments.option_redlist() != null) {
                redlist = UniversalFileCreator.createFile(new File(arguments.option_redlist()));
            }
            redTypes = ClassListLoader.loadRedlist(redlist);
        }
        if (greenTypes == null && arguments.option_greenlist() != null) {
            greenTypes = ClassListLoader.loadGreenlist(UniversalFileCreator.createFile(new File(arguments.option_greenlist())));
            UniversalFile defaultGreenList = UniversalFileCreator.createFile("/lib/greenlist.txt", "lib/greenlist.txt");
            if (defaultGreenList != null) {
                greenTypes.addAll(ClassListLoader.loadGreenlist(defaultGreenList));
            }
        }
        this.enableProxyReplacement = enableProxyReplacement;
        this.noGenRedClass = noGenRedClass;
        this.useRedList = arguments.option_load_dependencies() && !arguments.option_disable_load_dependencies() || arguments.option_target() == Targets.GENCWRAPPERS || arguments.option_target() == Targets.GENCSHARPWRAPPERS || arguments.option_target() == Targets.SDLANDROID;
    }

    @Override
    public boolean processPhase1(BundlePhase1 bundle) {
        for (OutputFile preOutputFile : bundle.getOutputFiles()) {
            String resourceName = preOutputFile.getOrigin();
            long lastModified = preOutputFile.getLastModified();
            OutputFile outputFile = null;
            if (!this.arguments.option_no_cache() && this.cache.contains(resourceName, lastModified)) {
                Log.debug(TAG, "Getting resource from cache: " + resourceName);
                outputFile = new OutputFile(this.cache.get(resourceName, lastModified), lastModified);
                outputFile.setLocation(preOutputFile.getLocation());
                outputFile.setFileName(preOutputFile.getFileName());
                this.filesFromCache.add(outputFile);
            } else {
                outputFile = this.generateDEXmlvmFile(preOutputFile, bundle);
                if (outputFile != null && !this.arguments.option_no_cache()) {
                    this.cache.put(resourceName, lastModified, outputFile.getDataAsBytes());
                }
            }
            if (this.isTargetProcess && outputFile != null) {
                outputFile.setOrigin(preOutputFile.getOrigin());
                bundle.addOutputFile(outputFile);
            }
            bundle.removeOutputFile(preOutputFile);
        }
        this.addResourcesFromCachedFiles(bundle);
        return true;
    }

    @Override
    public boolean processPhase2(BundlePhase2 bundle) {
        return true;
    }

    private void addResourcesFromCachedFiles(BundlePhase1 resources) {
        for (OutputFile cachedFile : this.filesFromCache) {
            resources.addResource(XmlvmResource.fromFile(cachedFile));
        }
    }

    public OutputFile generateDEXmlvmFile(OutputFile classFile, BundlePhase1 resources) {
        return this.generateDEXmlvmFile(classFile, false, resources);
    }

    private OutputFile generateDEXmlvmFile(OutputFile classFile, boolean proxy, BundlePhase1 resources) {
        Annotation delegateAnnotation;
        DirectClassFile directClassFile = new DirectClassFile(classFile.getDataAsBytes(), classFile.getFileName(), false);
        directClassFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
        try {
            directClassFile.getMagic();
        }
        catch (ParseException ex) {
            Log.debug(TAG, "Could not parse class.");
            return null;
        }
        String packagePlusClassName = directClassFile.getThisClass().getClassType().toHuman();
        if (this.noGenRedClass && this.isRedType(packagePlusClassName)) {
            Log.debug("Discarding red class: " + packagePlusClassName);
            return null;
        }
        if (this.enableProxyReplacement && !proxy && LibraryLoader.hasProxy(packagePlusClassName)) {
            return this.generateDEXmlvmFile(new OutputFile(LibraryLoader.getProxy(packagePlusClassName)), true, resources);
        }
        if (DEXmlvmOutputProcess.hasAnnotation(directClassFile.getAttributes(), XMLVMIgnore.class)) {
            return null;
        }
        if (AccessFlags.isSynthetic(directClassFile.getAccessFlags()) && (this.arguments.option_target() == Targets.GENCWRAPPERS || this.arguments.option_target() == Targets.GENCSHARPWRAPPERS)) {
            return null;
        }
        TreeMap<String, ReferenceKind> referencedTypes = new TreeMap<String, ReferenceKind>();
        Document document = DEXmlvmOutputProcess.createDocument();
        TypePlusSuperType type = this.process(directClassFile, document.getRootElement(), referencedTypes);
        String className = type.typeName.replace('.', '_');
        String jClassName = document.getRootElement().getChild("class", InstructionProcessor.vm).getAttributeValue("name");
        List methods = document.getRootElement().getChild("class", InstructionProcessor.vm).getChildren("method", InstructionProcessor.vm);
        if (this.arguments.option_enable_ref_counting()) {
            ReferenceCounting refCounting = new ReferenceCounting();
            for (Element e : methods) {
                try {
                    refCounting.process(e);
                }
                catch (ReferenceCountingException ex) {
                    Log.error(TAG + "-ref", "Processing method: " + e.getAttributeValue("name"));
                    Log.error(TAG + "-ref", "Failed while processing: " + ex.getMessage() + " in " + jClassName);
                    return null;
                }
                catch (DataConversionException ex) {
                    Log.error(TAG + "-ref", "Processing method: " + e.getAttributeValue("name"));
                    Log.error(TAG + "-ref", "Failed while processing: " + ex.getMessage() + " in " + jClassName);
                    return null;
                }
            }
        }
        Element classElement = document.getRootElement().getChild("class", InstructionProcessor.vm);
        boolean skeletonOnly = DEXmlvmOutputProcess.hasAnnotation(directClassFile.getAttributes(), XMLVMSkeletonOnly.class);
        if (skeletonOnly) {
            classElement.setAttribute("skeletonOnly", "true");
            Annotation skeletonAnnotation = DEXmlvmOutputProcess.getAnnotation(directClassFile.getAttributes(), XMLVMSkeletonOnly.class);
            for (NameValuePair pair : skeletonAnnotation.getNameValuePairs()) {
                if (!pair.getName().getString().equals("references")) continue;
                CstArray.List clazzArrayList = ((CstArray)pair.getValue()).getList();
                for (int i = 0; i < clazzArrayList.size(); ++i) {
                    this.addReference(referencedTypes, ((CstType)clazzArrayList.get(i)).toHuman(), ReferenceKind.USAGE);
                }
            }
        }
        if ((delegateAnnotation = DEXmlvmOutputProcess.getAnnotation(directClassFile.getAttributes(), XMLVMDelegate.class)) != null) {
            for (NameValuePair pair : delegateAnnotation.getNameValuePairs()) {
                if (!pair.getName().getString().equals("protocolType")) continue;
                String protocolType = ((CstString)pair.getValue()).getString().getString();
                classElement.setAttribute("delegateProtocolType", protocolType);
            }
        }
        DEXmlvmOutputProcess.addReferences(document, referencedTypes);
        XmlvmResource resource = new XmlvmResource(XmlvmResource.Type.DEX, document);
        if (skeletonOnly) {
            resource.setTag(XmlvmResource.Tag.SKELETON_ONLY, "true");
        }
        resources.addResource(resource);
        String fileName = className + DEXMLVM_ENDING;
        OutputFile result = new OutputFile(new DelayedXmlvmSerializationProvider(document));
        result.setLocation(this.arguments.option_out());
        result.setFileName(fileName);
        return result;
    }

    private void addReference(Map<String, ReferenceKind> referenceMap, String reference, ReferenceKind type) {
        ReferenceKind oldType;
        String baseReferencedType = reference;
        int j = baseReferencedType.indexOf(91);
        if (j != -1) {
            baseReferencedType = baseReferencedType.substring(0, j);
        }
        if (!(INVALID_REFERENCES.contains(baseReferencedType) || (oldType = referenceMap.get(baseReferencedType)) != null && oldType.compareTo(type) <= 0)) {
            if (this.isRedType(baseReferencedType)) {
                if (type == ReferenceKind.USAGE) {
                    referenceMap.remove(baseReferencedType);
                }
            } else {
                referenceMap.put(baseReferencedType, type);
            }
        }
    }

    private static void addReferences(Document xmlvmDocument, Map<String, ReferenceKind> referencedTypes) {
        Element references = new Element("references", NS_XMLVM);
        for (Map.Entry<String, ReferenceKind> referencedType : referencedTypes.entrySet()) {
            Element reference = new Element("reference", NS_XMLVM);
            reference.setAttribute("name", referencedType.getKey());
            reference.setAttribute("kind", referencedType.getValue().toHuman());
            references.addContent((Content)reference);
        }
        xmlvmDocument.getRootElement().addContent((Content)references);
    }

    private boolean isRedType(String packagePlusClassName) {
        return packagePlusClassName.contains("org.apache.bcel");
    }

    private static PackagePlusClassName parseClassName(String packagePlusClassName) {
        int lastSlash = packagePlusClassName.lastIndexOf(47);
        if (lastSlash == -1) {
            return new PackagePlusClassName(packagePlusClassName);
        }
        String className = packagePlusClassName.substring(lastSlash + 1);
        String packageName = packagePlusClassName.substring(0, lastSlash).replace('/', '.');
        return new PackagePlusClassName(packageName, className);
    }

    private static Document createDocument() {
        Element root = new Element("xmlvm", NS_XMLVM);
        root.addNamespaceDeclaration(NS_DEX);
        Document document = new Document();
        document.addContent((Content)root);
        return document;
    }

    private TypePlusSuperType process(DirectClassFile cf, Element root, Map<String, ReferenceKind> referencedTypes) {
        boolean skeletonOnly = DEXmlvmOutputProcess.hasAnnotation(cf.getAttributes(), XMLVMSkeletonOnly.class);
        Element classElement = this.processClass(cf, root, referencedTypes);
        this.processFields(cf.getFields(), classElement, referencedTypes, skeletonOnly);
        MethodList methods = cf.getMethods();
        int sz = methods.size();
        for (int i = 0; i < sz; ++i) {
            Method one = methods.get(i);
            if (DEXmlvmOutputProcess.hasAnnotation(one.getAttributes(), XMLVMIgnore.class) || skeletonOnly && (one.getAccessFlags() & 0x1002) != 0) continue;
            try {
                this.processMethod(one, cf, classElement, referencedTypes, skeletonOnly);
                continue;
            }
            catch (RuntimeException ex) {
                String msg = "...while processing " + one.getName().toHuman() + " " + one.getDescriptor().toHuman();
                throw ExceptionWithContext.withContext(ex, msg);
            }
        }
        String className = classElement.getAttributeValue("name");
        String superClassName = classElement.getAttributeValue("extends");
        return new TypePlusSuperType(className, superClassName);
    }

    private Element processClass(DirectClassFile cf, Element root, Map<String, ReferenceKind> referencedTypes) {
        AttSignature signatureAnnotation;
        Element classElement = new Element("class", NS_XMLVM);
        CstType type = cf.getThisClass();
        PackagePlusClassName parsedClassName = DEXmlvmOutputProcess.parseClassName(type.getClassType().getClassName());
        this.addReference(referencedTypes, parsedClassName.toString(), ReferenceKind.SELF);
        classElement.setAttribute("name", parsedClassName.className);
        classElement.setAttribute("package", parsedClassName.packageName);
        String superClassName = "";
        AttEnclosingMethod enclosingMethodAnnotation = (AttEnclosingMethod)cf.getAttributes().findFirst("EnclosingMethod");
        if (enclosingMethodAnnotation != null) {
            CstType enclosingClass = enclosingMethodAnnotation.getEnclosingClass();
            CstNat enclosingMethod = enclosingMethodAnnotation.getMethod();
            if (enclosingClass != null) {
                this.addReference(referencedTypes, enclosingClass.toHuman(), ReferenceKind.USAGE);
                classElement.setAttribute("enclosingClass", enclosingClass.toHuman());
            }
            if (enclosingMethod != null) {
                classElement.setAttribute("enclosingMethod", enclosingMethod.toHuman());
            }
        }
        if ((signatureAnnotation = (AttSignature)cf.getAttributes().findFirst("Signature")) != null) {
            classElement.setAttribute("signature", signatureAnnotation.getSignature().toHuman());
        }
        if (cf.getSuperclass() != null) {
            superClassName = DEXmlvmOutputProcess.parseClassName(cf.getSuperclass().getClassType().getClassName()).toString();
            this.addReference(referencedTypes, superClassName, ReferenceKind.SUPER_CLASS);
        }
        classElement.setAttribute("extends", superClassName);
        DEXmlvmOutputProcess.processAccessFlags(cf.getAccessFlags(), classElement);
        TypeList interfaces = cf.getInterfaces();
        if (interfaces.size() > 0) {
            String interfaceList = "";
            for (int i = 0; i < interfaces.size(); ++i) {
                if (i > 0) {
                    interfaceList = interfaceList + ",";
                }
                String interfaceName = DEXmlvmOutputProcess.parseClassName(interfaces.getType(i).getClassName()).toString();
                interfaceList = interfaceList + interfaceName;
                this.addReference(referencedTypes, interfaceName, ReferenceKind.INTERFACE);
            }
            classElement.setAttribute("interfaces", interfaceList);
        }
        root.addContent((Content)classElement);
        return classElement;
    }

    private void processFields(FieldList fieldList, Element classElement, Map<String, ReferenceKind> referencedTypes, boolean skeletonOnly) {
        for (int i = 0; i < fieldList.size(); ++i) {
            Field field = fieldList.get(i);
            if (DEXmlvmOutputProcess.hasAnnotation(field.getAttributes(), XMLVMIgnore.class) || skeletonOnly && (field.getAccessFlags() & 0x1002) != 0) continue;
            Element fieldElement = new Element("field", NS_XMLVM);
            fieldElement.setAttribute("name", field.getName().toHuman());
            String fieldType = field.getNat().getFieldType().toHuman();
            if (this.isRedType(fieldType)) {
                fieldType = JLO;
            } else {
                this.addReference(referencedTypes, fieldType, ReferenceKind.USAGE);
            }
            fieldElement.setAttribute("type", fieldType);
            TypedConstant value = field.getConstantValue();
            if (value != null) {
                String constValue = null;
                if (fieldType.equals("java.lang.String")) {
                    constValue = ((CstString)value).getString().getString();
                    DEXmlvmOutputProcess.encodeString(fieldElement, constValue);
                } else {
                    constValue = value.toHuman();
                    fieldElement.setAttribute("value", constValue);
                }
            }
            DEXmlvmOutputProcess.processAccessFlags(field.getAccessFlags(), fieldElement);
            classElement.addContent((Content)fieldElement);
        }
    }

    private void processCatchTable(CatchTable catchTable, Element codeElement) {
        if (catchTable.size() == 0) {
            return;
        }
        Element catchTableElement = new Element("catches", NS_DEX);
        for (int i = 0; i < catchTable.size(); ++i) {
            CatchTable.Entry entry = catchTable.get(i);
            Element entryElement = new Element("entry", NS_DEX);
            entryElement.setAttribute("start", String.valueOf(entry.getStart()));
            entryElement.setAttribute("end", String.valueOf(entry.getEnd()));
            CatchHandlerList catchHandlers = entry.getHandlers();
            for (int j = 0; j < catchHandlers.size(); ++j) {
                CatchHandlerList.Entry handlerEntry = catchHandlers.get(j);
                String exceptionType = handlerEntry.getExceptionType().toHuman();
                if (this.isRedType(exceptionType)) continue;
                Element handlerElement = new Element("handler", NS_DEX);
                handlerElement.setAttribute("type", exceptionType);
                handlerElement.setAttribute("target", String.valueOf(handlerEntry.getHandler()));
                entryElement.addContent((Content)handlerElement);
            }
            catchTableElement.addContent((Content)entryElement);
        }
        codeElement.addContent((Content)catchTableElement);
    }

    private void addDelegateElement(Method method, Element methodElement) {
        Annotation delegateAnnotation = DEXmlvmOutputProcess.getAnnotation(method.getAttributes(), XMLVMDelegateMethod.class);
        if (delegateAnnotation != null) {
            Element delegateMethodElement = new Element("delegateMethod", NS_XMLVM);
            methodElement.addContent((Content)delegateMethodElement);
            for (NameValuePair pair : delegateAnnotation.getNameValuePairs()) {
                String attrName = pair.getName().getString();
                if (attrName.equals("selector")) {
                    String selector = ((CstString)pair.getValue()).getString().getString();
                    delegateMethodElement.setAttribute("selector", selector);
                    continue;
                }
                if (!attrName.equals("params")) continue;
                CstArray.List paramList = ((CstArray)pair.getValue()).getList();
                for (int i = 0; i < paramList.size(); ++i) {
                    Element paramElement = new Element("param", NS_XMLVM);
                    delegateMethodElement.addContent((Content)paramElement);
                    Annotation paramsAnnotation = ((CstAnnotation)paramList.get(i)).getAnnotation();
                    for (NameValuePair paramsPair : paramsAnnotation.getNameValuePairs()) {
                        String paramsAttrName = paramsPair.getName().getString();
                        if (paramsAttrName.equals("type")) {
                            String type = ((CstString)paramsPair.getValue()).getString().getString();
                            paramElement.setAttribute("type", type);
                            continue;
                        }
                        if (paramsAttrName.equals("name")) {
                            String name = ((CstString)paramsPair.getValue()).getString().getString();
                            paramElement.setAttribute("name", name);
                            continue;
                        }
                        if (paramsAttrName.equals("isSource")) {
                            boolean isSource = ((CstBoolean)paramsPair.getValue()).getValue();
                            paramElement.setAttribute("isSource", Boolean.toString(isSource));
                            continue;
                        }
                        if (paramsAttrName.equals("isStruct")) {
                            boolean isStruct = ((CstBoolean)paramsPair.getValue()).getValue();
                            paramElement.setAttribute("isStruct", Boolean.toString(isStruct));
                            continue;
                        }
                        if (!paramsAttrName.equals("convert")) continue;
                        boolean convert = ((CstBoolean)paramsPair.getValue()).getValue();
                        paramElement.setAttribute("convert", Boolean.toString(convert));
                    }
                }
            }
        }
    }

    private void processMethod(Method method, DirectClassFile cf, Element classElement, Map<String, ReferenceKind> referencedTypes, boolean skeletonOnly) {
        boolean localInfo = true;
        int positionInfo = 2;
        CstMethodRef meth = new CstMethodRef(method.getDefiningClass(), method.getNat());
        int accessFlags = method.getAccessFlags();
        boolean isNative = AccessFlags.isNative(accessFlags);
        boolean isStatic = AccessFlags.isStatic(accessFlags);
        boolean isAbstract = AccessFlags.isAbstract(accessFlags);
        Element methodElement = new Element("method", NS_XMLVM);
        methodElement.setAttribute("name", method.getName().getString());
        methodElement.setAttribute("signature", method.getNat().getDescriptor().toHuman());
        classElement.addContent((Content)methodElement);
        DEXmlvmOutputProcess.processAccessFlags(accessFlags, methodElement);
        methodElement.addContent((Content)this.processSignature(meth, referencedTypes));
        Element codeElement = new Element("code", NS_DEX);
        methodElement.addContent((Content)codeElement);
        this.addDelegateElement(method, methodElement);
        if (skeletonOnly) {
            methodElement.setAttribute("noImplementation", "true");
            return;
        }
        if (isNative || isAbstract) {
            return;
        }
        ConcreteMethod concrete = new ConcreteMethod(method, cf, true, true);
        DexTranslationAdvice advice = DexTranslationAdvice.THE_ONE;
        RopMethod rmeth = Ropper.convert(concrete, advice);
        int paramSize = meth.getParameterWordCount(isStatic);
        String canonicalName = method.getDefiningClass().getClassType().getDescriptor() + "." + method.getName().getString();
        rmeth = Optimizer.optimize(rmeth, paramSize, isStatic, true, advice);
        LocalVariableInfo locals = null;
        locals = LocalVariableExtractor.extract(rmeth);
        DalvCode code = RopTranslator.translate(rmeth, 2, locals, paramSize);
        DalvCode.AssignIndicesCallback callback = new DalvCode.AssignIndicesCallback(){

            @Override
            public int getIndex(Constant cst) {
                return 0;
            }
        };
        code.assignIndices(callback);
        DalvInsnList instructions = code.getInsns();
        codeElement.setAttribute("register-size", String.valueOf(instructions.getRegistersSize()));
        this.processLocals(instructions.getRegistersSize(), isStatic, DEXmlvmOutputProcess.parseClassName(cf.getThisClass().getClassType().getClassName()).toString(), meth.getPrototype().getParameterTypes(), codeElement);
        Map<Integer, SwitchData> switchDataBlocks = DEXmlvmOutputProcess.extractSwitchData(instructions);
        Map<Integer, ArrayData> arrayData = DEXmlvmOutputProcess.extractArrayData(instructions);
        CatchTable catches = code.getCatches();
        this.processCatchTable(catches, codeElement);
        Map<Integer, Target> targets = DEXmlvmOutputProcess.extractTargets(instructions, catches);
        ArrayList<Element> tryElements = new ArrayList<Element>();
        HashMap<Integer, Element> tryCatchElements = new HashMap<Integer, Element>();
        for (int i = 0; i < catches.size(); ++i) {
            Element tryCatchElement = new Element("try-catch", NS_DEX);
            Element tryElement = new Element("try", NS_DEX);
            tryCatchElement.addContent((Content)tryElement);
            tryElements.add(tryElement);
            CatchHandlerList handlers = catches.get(i).getHandlers();
            for (int j = 0; j < handlers.size(); ++j) {
                String exceptionType = handlers.get(j).getExceptionType().toHuman();
                if (this.isRedType(exceptionType)) continue;
                Element catchElement = new Element("catch", NS_DEX);
                catchElement.setAttribute("exception-type", exceptionType);
                catchElement.setAttribute("target", String.valueOf(handlers.get(j).getHandler()));
                tryCatchElement.addContent((Content)catchElement);
            }
            tryCatchElements.put(catches.get(i).getStart(), tryCatchElement);
        }
        Element lastTryCatchElement = null;
        ArrayList<Integer> sourceLinesAlreadyPut = new ArrayList<Integer>();
        for (int i = 0; i < instructions.size(); ++i) {
            Element instructionParent = codeElement;
            DalvInsn instruction = instructions.get(i);
            int address = instruction.getAddress();
            CatchTable.Entry currentCatch = null;
            int tryElementIndex = 0;
            for (tryElementIndex = 0; tryElementIndex < catches.size(); ++tryElementIndex) {
                if (!DEXmlvmOutputProcess.isInstructionInCatchRange(instruction, catches.get(tryElementIndex))) continue;
                instructionParent = (Element)tryElements.get(tryElementIndex);
                currentCatch = catches.get(tryElementIndex);
                break;
            }
            if (targets.containsKey(address)) {
                Element labelElement = new Element("label", NS_DEX);
                labelElement.setAttribute("id", String.valueOf(address));
                if (currentCatch != null) {
                    if (currentCatch.getStart() == address) {
                        codeElement.addContent((Content)labelElement);
                    } else if (targets.get((Object)Integer.valueOf((int)address)).requiresSplit) {
                        codeElement.addContent((Content)labelElement);
                        Element secondTryCatchElement = (Element)lastTryCatchElement.clone();
                        Element secondTry = secondTryCatchElement.getChild("try", NS_DEX);
                        secondTry.removeContent();
                        codeElement.addContent((Content)secondTryCatchElement);
                        tryElements.set(tryElementIndex, secondTry);
                    } else {
                        instructionParent.addContent((Content)labelElement);
                    }
                } else {
                    instructionParent.addContent((Content)labelElement);
                }
                targets.remove(address);
            }
            if (tryCatchElements.containsKey(address)) {
                Element tryCatchElement = (Element)tryCatchElements.get(address);
                codeElement.addContent((Content)tryCatchElement);
                tryCatchElements.remove(address);
                lastTryCatchElement = tryCatchElement;
            }
            this.processInstruction(instruction, instructionParent, switchDataBlocks, arrayData, sourceLinesAlreadyPut, referencedTypes);
        }
    }

    private static boolean isInstructionInCatchRange(DalvInsn instruction, CatchTable.Entry catchEntry) {
        return instruction.getAddress() >= catchEntry.getStart() && instruction.getAddress() < catchEntry.getEnd();
    }

    private static void processAccessFlags(int accessFlags, Element element) {
        boolean isStatic = AccessFlags.isStatic(accessFlags);
        boolean isPrivate = AccessFlags.isPrivate(accessFlags);
        boolean isPublic = AccessFlags.isPublic(accessFlags);
        boolean isNative = AccessFlags.isNative(accessFlags);
        boolean isAbstract = AccessFlags.isAbstract(accessFlags);
        boolean isSynthetic = AccessFlags.isSynthetic(accessFlags);
        boolean isInterface = AccessFlags.isInterface(accessFlags);
        DEXmlvmOutputProcess.setAttributeIfTrue(element, "isStatic", isStatic);
        DEXmlvmOutputProcess.setAttributeIfTrue(element, "isPrivate", isPrivate);
        DEXmlvmOutputProcess.setAttributeIfTrue(element, "isPublic", isPublic);
        DEXmlvmOutputProcess.setAttributeIfTrue(element, "isNative", isNative);
        DEXmlvmOutputProcess.setAttributeIfTrue(element, "isAbstract", isAbstract);
        DEXmlvmOutputProcess.setAttributeIfTrue(element, "isSynthetic", isSynthetic);
        DEXmlvmOutputProcess.setAttributeIfTrue(element, "isInterface", isInterface);
    }

    private void processLocals(int registerSize, boolean isStatic, String classType, StdTypeList parameterTypes, Element codeElement) {
        ArrayList<Element> varElements = new ArrayList<Element>();
        int j = 0;
        int i = parameterTypes.size() - 1;
        while (i >= 0) {
            Type paramType = parameterTypes.get(i);
            Element varElement = new Element("var", NS_DEX);
            if (paramType.isCategory2()) {
                ++j;
            }
            varElement.setAttribute("name", "var-register-" + (registerSize - 1 - j));
            varElement.setAttribute("register", String.valueOf(registerSize - 1 - j));
            varElement.setAttribute("param-index", String.valueOf(i));
            String localsType = paramType.getType().toHuman();
            if (this.isRedType(localsType)) {
                localsType = JLO;
            }
            varElement.setAttribute("type", localsType);
            varElements.add(varElement);
            --i;
            ++j;
        }
        if (!isStatic) {
            Element thisVarElement = new Element("var", NS_DEX);
            thisVarElement.setAttribute("name", "this");
            thisVarElement.setAttribute("register", String.valueOf(registerSize - j - 1));
            thisVarElement.setAttribute("type", classType);
            varElements.add(thisVarElement);
        }
        Collections.reverse(varElements);
        for (Element varElement : varElements) {
            codeElement.addContent((Content)varElement);
        }
    }

    private static Map<Integer, Target> extractTargets(DalvInsnList instructions, CatchTable catches) {
        int i;
        HashMap<Integer, Target> targets = new HashMap<Integer, Target>();
        for (i = 0; i < instructions.size(); ++i) {
            CodeAddress[] caseTargets;
            if (instructions.get(i) instanceof TargetInsn) {
                TargetInsn targetInsn = (TargetInsn)instructions.get(i);
                targets.put(targetInsn.getTargetAddress(), new Target(targetInsn.getTargetAddress(), true));
                continue;
            }
            if (!(instructions.get(i) instanceof SwitchData)) continue;
            SwitchData switchData = (SwitchData)instructions.get(i);
            for (CodeAddress caseTarget : caseTargets = switchData.getTargets()) {
                targets.put(caseTarget.getAddress(), new Target(caseTarget.getAddress(), true));
            }
        }
        for (i = 0; i < catches.size(); ++i) {
            CatchHandlerList handlers = catches.get(i).getHandlers();
            for (int j = 0; j < handlers.size(); ++j) {
                int handlerAddress = handlers.get(j).getHandler();
                targets.put(handlerAddress, new Target(handlerAddress, true));
            }
        }
        return targets;
    }

    private static Map<Integer, SwitchData> extractSwitchData(DalvInsnList instructions) {
        HashMap<Integer, SwitchData> result = new HashMap<Integer, SwitchData>();
        for (int i = 0; i < instructions.size(); ++i) {
            if (!(instructions.get(i) instanceof SwitchData)) continue;
            SwitchData switchData = (SwitchData)instructions.get(i);
            result.put(switchData.getAddress(), switchData);
        }
        return result;
    }

    private static Map<Integer, ArrayData> extractArrayData(DalvInsnList instructions) {
        HashMap<Integer, ArrayData> result = new HashMap<Integer, ArrayData>();
        for (int i = 0; i < instructions.size(); ++i) {
            if (!(instructions.get(i) instanceof ArrayData)) continue;
            ArrayData arrayData = (ArrayData)instructions.get(i);
            result.put(arrayData.getAddress(), arrayData);
        }
        return result;
    }

    private void processInstruction(DalvInsn instruction, Element parentElement, Map<Integer, SwitchData> switchDataBlocks, Map<Integer, ArrayData> arrayData, List<Integer> sourceLinesAlreadyPut, Map<String, ReferenceKind> referencedTypes) {
        Element dexInstruction = null;
        String opname = instruction.getOpcode().getName();
        if (opname.equals("instance-of") || opname.equals("const-class")) {
            CstInsn isaInsn = (CstInsn)instruction;
            this.addReference(referencedTypes, isaInsn.getConstant().toHuman(), ReferenceKind.USAGE);
        }
        RegisterSpecList registers = instruction.getRegisters();
        for (int i = 0; i < registers.size(); ++i) {
            RegisterSpec register = registers.get(i);
            String descriptor = register.getType().getDescriptor();
            String registerType = register.getType().toHuman();
            if (descriptor.startsWith("N")) {
                this.addReference(referencedTypes, registerType.substring(registerType.indexOf(76) + 1), ReferenceKind.USAGE);
                continue;
            }
            this.addReference(referencedTypes, registerType, ReferenceKind.USAGE);
        }
        if (instruction instanceof CodeAddress) {
            SourcePosition sourcePosition = instruction.getPosition();
            CstUtf8 sourceFile = sourcePosition.getSourceFile();
            int sourceLine = sourcePosition.getLine();
            if (sourceFile != null && !sourceLinesAlreadyPut.contains(sourceLine)) {
                dexInstruction = new Element("source-position", NS_XMLVM);
                dexInstruction.setAttribute("file", sourceFile.toHuman());
                dexInstruction.setAttribute("line", String.valueOf(sourceLine));
                sourceLinesAlreadyPut.add(sourceLine);
            }
        } else if (!(instruction instanceof LocalSnapshot || instruction instanceof OddSpacer || instruction instanceof SwitchData || instruction instanceof LocalStart || instruction instanceof ArrayData)) {
            String instructionName;
            if (instruction instanceof SimpleInsn) {
                SimpleInsn simpleInsn = (SimpleInsn)instruction;
                instructionName = simpleInsn.getOpcode().getName();
                if (instructionName.startsWith("move-result")) {
                    if (simpleInsn.getRegisters().size() != 1) {
                        Log.error(TAG, "DEXmlvmOutputProcess: Register Size doesn't fit 'move-result'.");
                        System.exit(-1);
                    }
                    Element moveInstruction = new Element("move-result", NS_DEX);
                    DEXmlvmOutputProcess.addRegistersAsAttributes(registers, moveInstruction);
                    this.lastDexInstruction.addContent((Content)moveInstruction);
                } else {
                    dexInstruction = new Element(DEXmlvmOutputProcess.sanitizeInstructionName(instructionName), NS_DEX);
                    DEXmlvmOutputProcess.addRegistersAsAttributes(registers, dexInstruction);
                    if (registers.size() == 1) {
                        String classType = registers.get(0).getType().toHuman();
                        dexInstruction.setAttribute("class-type", classType);
                        if (instructionName.startsWith("throw") && this.isRedType(classType)) {
                            dexInstruction.setAttribute("isRedType", "true");
                        }
                    }
                }
            } else if (instruction instanceof CstInsn) {
                CstInsn cstInsn = (CstInsn)instruction;
                if (DEXmlvmOutputProcess.isInvokeInstruction(cstInsn)) {
                    dexInstruction = this.processInvokeInstruction(cstInsn, referencedTypes);
                } else {
                    dexInstruction = new Element(DEXmlvmOutputProcess.sanitizeInstructionName(cstInsn.getOpcode().getName()), NS_DEX);
                    Constant constant = cstInsn.getConstant();
                    String type = constant.typeName();
                    String name = "kind";
                    if (!(type.equals("field") || type.equals("known-null") || type.equals("type") || type.equals("string"))) {
                        name = "type";
                    }
                    dexInstruction.setAttribute(name, constant.typeName());
                    if (constant instanceof CstMemberRef) {
                        CstMemberRef memberRef = (CstMemberRef)constant;
                        String definingClassType = memberRef.getDefiningClass().getClassType().toHuman();
                        dexInstruction.setAttribute("class-type", definingClassType);
                        this.addReference(referencedTypes, definingClassType, ReferenceKind.USAGE);
                        CstNat nameAndType = memberRef.getNat();
                        String memberType = nameAndType.getFieldType().getType().toHuman();
                        dexInstruction.setAttribute("member-type", memberType);
                        this.addReference(referencedTypes, memberType, ReferenceKind.USAGE);
                        String memberName = nameAndType.getName().toHuman();
                        dexInstruction.setAttribute("member-name", memberName);
                        if (this.isRedType(definingClassType)) {
                            dexInstruction = DEXmlvmOutputProcess.createAssertElement(definingClassType + "," + memberType, memberName);
                        } else if (this.isRedType(memberType)) {
                            dexInstruction.setAttribute("member-type", "org.xmlvm.runtime.RedTypeMarker");
                        }
                    } else if (constant instanceof CstString) {
                        CstString cstString = (CstString)constant;
                        String value = cstString.getString().getString();
                        DEXmlvmOutputProcess.encodeString(dexInstruction, value);
                    } else {
                        List<String> instructionsToCheck = Arrays.asList("new-instance", "instance-of", "check-cast", "const-class", "new-array");
                        if (instructionsToCheck.contains(opname) && this.isRedType(constant.toHuman())) {
                            dexInstruction = DEXmlvmOutputProcess.createAssertElement(constant.toHuman(), opname);
                        } else {
                            dexInstruction.setAttribute("value", constant.toHuman());
                        }
                    }
                    if (cstInsn.getOpcode().getName().startsWith("filled-new-array")) {
                        DEXmlvmOutputProcess.addRegistersAsChildren(cstInsn.getRegisters(), dexInstruction);
                    } else {
                        DEXmlvmOutputProcess.addRegistersAsAttributes(cstInsn.getRegisters(), dexInstruction);
                    }
                }
            } else if (instruction instanceof TargetInsn) {
                TargetInsn targetInsn = (TargetInsn)instruction;
                instructionName = targetInsn.getOpcode().getName();
                dexInstruction = new Element(DEXmlvmOutputProcess.sanitizeInstructionName(instructionName), NS_DEX);
                DEXmlvmOutputProcess.addRegistersAsAttributes(targetInsn.getRegisters(), dexInstruction);
                if (instructionName.equals("packed-switch") || instructionName.equals("sparse-switch")) {
                    SwitchData switchData = switchDataBlocks.get(targetInsn.getTargetAddress());
                    if (switchData == null) {
                        Log.error(TAG, "DEXmlvmOutputProcess: Couldn't find SwitchData block.");
                        System.exit(-1);
                    }
                    IntList cases = switchData.getCases();
                    CodeAddress[] caseTargets = switchData.getTargets();
                    if (cases.size() != caseTargets.length) {
                        Log.error(TAG, "DEXmlvmOutputProcess: SwitchData size mismatch: cases vs targets.");
                        System.exit(-1);
                    }
                    for (int i = 0; i < cases.size(); ++i) {
                        Element caseElement = new Element("case", NS_DEX);
                        caseElement.setAttribute("key", String.valueOf(cases.get(i)));
                        caseElement.setAttribute("label", String.valueOf(caseTargets[i].getAddress()));
                        dexInstruction.addContent((Content)caseElement);
                    }
                } else if (instructionName.equals("fill-array-data")) {
                    ArrayList<Constant> data = arrayData.get(targetInsn.getTargetAddress()).getValues();
                    for (Constant c : data) {
                        Element constant = new Element("constant", NS_DEX);
                        constant.setAttribute("value", c.toHuman());
                        dexInstruction.addContent((Content)constant);
                    }
                } else {
                    dexInstruction.setAttribute("target", String.valueOf(targetInsn.getTargetAddress()));
                }
            } else if (instruction instanceof HighRegisterPrefix) {
                SimpleInsn[] moveInstructions;
                HighRegisterPrefix highRegisterPrefix = (HighRegisterPrefix)instruction;
                for (SimpleInsn moveInstruction : moveInstructions = highRegisterPrefix.getMoveInstructions()) {
                    this.processInstruction(moveInstruction, parentElement, switchDataBlocks, arrayData, sourceLinesAlreadyPut, referencedTypes);
                }
            } else {
                System.err.print(">>> Unknown instruction: ");
                System.err.print("(" + instruction.getClass().getName() + ") ");
                System.err.print(instruction.listingString("", 0, true));
                System.exit(-1);
            }
        }
        if (dexInstruction != null) {
            parentElement.addContent(dexInstruction);
            this.lastDexInstruction = dexInstruction;
        }
    }

    private static void encodeString(Element elem, String str) {
        int length = str.length();
        char[] content = new char[length];
        str.getChars(0, length, content, 0);
        elem.setAttribute("length", "" + length);
        StringBuilder encodedString = new StringBuilder(length * 5);
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                encodedString.append(", ");
            }
            encodedString.append((short)content[i]);
        }
        elem.setAttribute("encoded-value", encodedString.toString());
        StringBuilder escapedString = new StringBuilder(str.length() * 6);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < ' ' || ch > 'z' || "\\\"".indexOf(ch) != -1) {
                escapedString.append(String.format("\\%03o", ch));
                continue;
            }
            escapedString.append(ch);
        }
        elem.setAttribute("value", escapedString.toString());
    }

    private static void addRegistersAsAttributes(RegisterSpecList registers, Element element) {
        String[] REGISTER_NAMES = new String[]{"vx", "vy", "vz"};
        if (registers.size() > 3) {
            Log.error(TAG, "DEXmlvmOutputProcess.processRegisters: Too many registers.");
            System.exit(-1);
        }
        for (int i = 0; i < registers.size(); ++i) {
            element.setAttribute(REGISTER_NAMES[i], String.valueOf(DEXmlvmOutputProcess.registerNumber(registers.get(i).regString())));
            element.setAttribute(REGISTER_NAMES[i] + "-type", registers.get(i).getType().toHuman());
        }
    }

    private static void addRegistersAsChildren(RegisterSpecList registers, Element element) {
        for (int i = 0; i < registers.size(); ++i) {
            Element reg = new Element("value", NS_DEX);
            reg.setAttribute("register", "" + DEXmlvmOutputProcess.registerNumber(registers.get(i).regString()));
            reg.setAttribute("type", registers.get(i).getType().toHuman());
            element.addContent((Content)reg);
        }
    }

    private static boolean isInvokeInstruction(CstInsn cstInsn) {
        Dop[] invokeInstructions;
        for (Dop dop : invokeInstructions = new Dop[]{Dops.INVOKE_VIRTUAL, Dops.INVOKE_VIRTUAL_RANGE, Dops.INVOKE_STATIC, Dops.INVOKE_STATIC_RANGE, Dops.INVOKE_DIRECT, Dops.INVOKE_DIRECT_RANGE, Dops.INVOKE_INTERFACE, Dops.INVOKE_INTERFACE_RANGE, Dops.INVOKE_SUPER, Dops.INVOKE_SUPER_RANGE}) {
            if (!dop.equals(cstInsn.getOpcode())) continue;
            return true;
        }
        return false;
    }

    private static boolean isInvokeStaticInstruction(CstInsn cstInsn) {
        Dop[] staticInvokeInstructions;
        for (Dop dop : staticInvokeInstructions = new Dop[]{Dops.INVOKE_STATIC, Dops.INVOKE_STATIC_RANGE}) {
            if (!dop.equals(cstInsn.getOpcode())) continue;
            return true;
        }
        return false;
    }

    private Element processInvokeInstruction(CstInsn cstInsn, Map<String, ReferenceKind> referencedTypes) {
        Element result = new Element(DEXmlvmOutputProcess.sanitizeInstructionName(cstInsn.getOpcode().getName()), NS_DEX);
        CstBaseMethodRef methodRef = (CstBaseMethodRef)cstInsn.getConstant();
        String classType = methodRef.getDefiningClass().toHuman();
        String methodName = methodRef.getNat().getName().toHuman();
        if (this.isRedType(classType)) {
            return DEXmlvmOutputProcess.createAssertElement(classType, methodName);
        }
        this.addReference(referencedTypes, classType, ReferenceKind.USAGE);
        result.setAttribute("class-type", classType);
        result.setAttribute("method", methodName);
        RegisterSpecList registerList = cstInsn.getRegisters();
        ArrayList<RegisterSpec> registers = new ArrayList<RegisterSpec>();
        if (DEXmlvmOutputProcess.isInvokeStaticInstruction(cstInsn)) {
            if (registerList.size() > 0) {
                registers.add(registerList.get(0));
            }
        } else {
            result.setAttribute("register", String.valueOf(DEXmlvmOutputProcess.registerNumber(registerList.get(0).regString())));
        }
        for (int i = 1; i < registerList.size(); ++i) {
            registers.add(registerList.get(i));
        }
        result.addContent((Content)this.processParameterList(methodRef, registers));
        return result;
    }

    private Element processParameterList(CstBaseMethodRef methodRef, List<RegisterSpec> registers) {
        Element result = new Element("parameters", NS_DEX);
        Prototype prototype = methodRef.getPrototype();
        StdTypeList parameters = prototype.getParameterTypes();
        if (parameters.size() != registers.size()) {
            Log.error(TAG, "DEXmlvmOutputProcess.processParameterList: Size mismatch: registers vs parameters");
            System.exit(-1);
        }
        for (int i = 0; i < parameters.size(); ++i) {
            Element parameterElement = new Element("parameter", NS_DEX);
            String parameterType = parameters.get(i).toHuman();
            parameterElement.setAttribute("type", parameterType);
            if (this.isRedType(parameterType)) {
                parameterElement.setAttribute("isRedType", "true");
            }
            parameterElement.setAttribute("register", String.valueOf(DEXmlvmOutputProcess.registerNumber(registers.get(i).regString())));
            result.addContent((Content)parameterElement);
        }
        Element returnElement = new Element("return", NS_DEX);
        String returnType = prototype.getReturnType().getType().toHuman();
        if (this.isRedType(returnType)) {
            returnType = JLO;
        }
        returnElement.setAttribute("type", returnType);
        result.addContent((Content)returnElement);
        return result;
    }

    private Element processSignature(CstMethodRef methodRef, Map<String, ReferenceKind> referencedTypes) {
        Prototype prototype = methodRef.getPrototype();
        StdTypeList parameters = prototype.getParameterTypes();
        Element result = new Element("signature", NS_XMLVM);
        for (int i = 0; i < parameters.size(); ++i) {
            Element parameterElement = new Element("parameter", NS_XMLVM);
            String parameterType = parameters.get(i).toHuman();
            parameterElement.setAttribute("type", parameterType);
            if (this.isRedType(parameterType)) {
                parameterElement.setAttribute("isRedType", "true");
            } else {
                this.addReference(referencedTypes, parameterType, ReferenceKind.USAGE);
            }
            result.addContent((Content)parameterElement);
        }
        Element returnElement = new Element("return", NS_XMLVM);
        String returnType = prototype.getReturnType().getType().toHuman();
        if (this.isRedType(returnType)) {
            returnType = JLO;
        } else {
            this.addReference(referencedTypes, returnType, ReferenceKind.USAGE);
        }
        returnElement.setAttribute("type", returnType);
        result.addContent((Content)returnElement);
        return result;
    }

    private static String sanitizeInstructionName(String rawName) {
        return rawName.replaceAll("/", "-");
    }

    private static void setAttributeIfTrue(Element element, String attributeName, boolean value) {
        if (value) {
            element.setAttribute(attributeName, Boolean.toString(value));
        }
    }

    private static int registerNumber(String vFormat) throws RuntimeException {
        if (!vFormat.startsWith("v")) {
            throw new RuntimeErrorException(new Error("Register name doesn't start with 'v' prefix: " + vFormat));
        }
        try {
            int registerNumber = Integer.parseInt(vFormat.substring(1));
            return registerNumber;
        }
        catch (NumberFormatException ex) {
            throw new RuntimeErrorException(new Error("Couldn't extract register number from register name: " + vFormat, ex));
        }
    }

    private static boolean hasAnnotation(AttributeList attrs, Class<?> annotationClazz) {
        return DEXmlvmOutputProcess.getAnnotation(attrs, annotationClazz) != null;
    }

    private static String getClassWithSlashes(Class<?> clazz) {
        return clazz.getName().replaceAll("\\.", "/");
    }

    private static Annotation getAnnotation(AttributeList attrs, Class<?> annotationClazz) {
        BaseAnnotations a = (BaseAnnotations)attrs.findFirst("RuntimeInvisibleAnnotations");
        if (a != null) {
            String annotationName = DEXmlvmOutputProcess.getClassWithSlashes(annotationClazz);
            for (Annotation an : a.getAnnotations().getAnnotations()) {
                if (!an.getType().getClassType().getClassName().equals(annotationName)) continue;
                return an;
            }
        }
        return null;
    }

    private static Element createAssertElement(String typeName, String memberName) {
        Element assertElement = new Element("assert-red-class", NS_XMLVM);
        assertElement.setAttribute("type", typeName);
        assertElement.setAttribute("member", memberName);
        return assertElement;
    }

    private static class Target {
        int address;
        boolean requiresSplit;

        public Target(int address, boolean requiresSplit) {
            this.address = address;
            this.requiresSplit = requiresSplit;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Target) {
                Target otherTarget = (Target)obj;
                return this.address == otherTarget.address;
            }
            return false;
        }

        public int hashCode() {
            return this.address;
        }
    }

    private static class PackagePlusClassName {
        public String packageName = "";
        public String className = "";

        public PackagePlusClassName(String className) {
            this.className = className;
        }

        public PackagePlusClassName(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
        }

        public String toString() {
            if (this.packageName.isEmpty()) {
                return this.className;
            }
            return this.packageName + "." + this.className;
        }
    }

    private static class TypePlusSuperType {
        public final String typeName;
        public final String superTypeName;

        public TypePlusSuperType(String typeName, String superTypeName) {
            this.typeName = typeName;
            this.superTypeName = superTypeName;
        }
    }

    private static enum ReferenceKind {
        SUPER_CLASS("super"),
        INTERFACE("interface"),
        SELF("self"),
        USAGE("usage");

        private final String human;

        private ReferenceKind(String human) {
            this.human = human;
        }

        public String toHuman() {
            return this.human;
        }
    }
}

