/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out;

import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import java.io.IOException;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.XmlvmProcessImpl;
import org.xmlvm.proc.in.InputProcess;
import org.xmlvm.proc.out.JavaByteCodeOutputProcess;
import org.xmlvm.proc.out.OutputFile;

public class DexOutputProcess
extends XmlvmProcessImpl {
    private static final String DEX_ENDING = ".dex";

    public DexOutputProcess(Arguments arguments) {
        super(arguments);
        this.addSupportedInput(InputProcess.ClassInputProcess.class);
        this.addSupportedInput(JavaByteCodeOutputProcess.class);
    }

    @Override
    public boolean processPhase1(BundlePhase1 bundle) {
        return true;
    }

    @Override
    public boolean processPhase2(BundlePhase2 bundle) {
        for (OutputFile preOutputFile : bundle.getOutputFiles()) {
            OutputFile outputFile = this.generateDexFile(preOutputFile);
            if (outputFile == null) {
                return false;
            }
            bundle.removeOutputFile(preOutputFile);
            bundle.addOutputFile(outputFile);
        }
        return true;
    }

    private OutputFile generateDexFile(OutputFile classFile) {
        if (!classFile.getFullPath().startsWith(this.arguments.option_out())) {
            Log.error("DexOutputProcess: Something is wrong with the class output path.");
            return null;
        }
        String relativePath = classFile.getFullPath().substring(this.arguments.option_out().length() + 1);
        if (relativePath.startsWith("/") || relativePath.startsWith("\\")) {
            relativePath = relativePath.substring(1);
        }
        Log.debug("DExing:" + relativePath);
        CfOptions options = new CfOptions();
        options.strictNameCheck = false;
        ClassDefItem item = CfTranslator.translate(relativePath, classFile.getDataAsBytes(), options);
        DexFile dexFile = new DexFile();
        dexFile.add(item);
        try {
            byte[] rawDex = dexFile.toDex(null, false);
            OutputFile result = new OutputFile(rawDex);
            result.setLocation(classFile.getLocation());
            result.setFileName(classFile.getFileName().replace(".class", DEX_ENDING));
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Could not generate DEX file.");
            return null;
        }
    }
}

