/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out;

import java.util.ArrayList;
import java.util.HashMap;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.XmlvmProcessImpl;
import org.xmlvm.proc.XmlvmResource;
import org.xmlvm.proc.out.DEXmlvmOutputProcess;

public class OptimizationOutputProcess
extends XmlvmProcessImpl {
    public OptimizationOutputProcess(Arguments arguments) {
        super(arguments);
        this.addSupportedInput(DEXmlvmOutputProcess.class);
    }

    @Override
    public boolean processPhase1(BundlePhase1 bundle) {
        return true;
    }

    @Override
    public boolean processPhase2(BundlePhase2 bundle) {
        this.generateStringConstantPool(bundle);
        return true;
    }

    private void generateStringConstantPool(BundlePhase2 bundle) {
        ArrayList<ConstantPoolEntry> constantPool = new ArrayList<ConstantPoolEntry>();
        HashMap<String, Integer> constantPoolIDs = new HashMap<String, Integer>();
        for (XmlvmResource xmlvmResource : bundle.getResources()) {
            ArrayList<XmlvmResource.XmlvmConstantStringElement> instructions = new ArrayList<XmlvmResource.XmlvmConstantStringElement>();
            xmlvmResource.collectInstructions(instructions);
            for (XmlvmResource.XmlvmConstantStringElement inst : instructions) {
                String escapedConstant = inst.getEscapedStringConstant();
                String encodedConstant = inst.getEncodedStringConstant();
                int len = inst.getLength();
                int id = -1;
                if (constantPoolIDs.containsKey(encodedConstant)) {
                    id = (Integer)constantPoolIDs.get(encodedConstant);
                } else {
                    id = constantPool.size();
                    ConstantPoolEntry entry = new ConstantPoolEntry(id, len, escapedConstant, encodedConstant);
                    constantPool.add(entry);
                    constantPoolIDs.put(encodedConstant, id);
                }
                inst.setContantPoolID(id);
            }
        }
        Element xmlRoot = new Element("constant-pool", XmlvmResource.nsXMLVM);
        for (ConstantPoolEntry entry : constantPool) {
            Element xmlEntry = new Element("entry", XmlvmResource.nsXMLVM);
            xmlEntry.setAttribute("id", "" + entry.id);
            xmlEntry.setAttribute("length", "" + entry.length);
            xmlEntry.setAttribute("escaped-constant", entry.escapedString);
            xmlEntry.setAttribute("encoded-constant", entry.encodedString);
            xmlRoot.addContent((Content)xmlEntry);
        }
        XmlvmResource xmlvmResource = new XmlvmResource(XmlvmResource.Type.CONST_POOL, new Document(xmlRoot));
        bundle.addAdditionalResource(xmlvmResource);
    }

    class ConstantPoolEntry {
        public int id;
        public int length;
        public String encodedString;
        public String escapedString;

        public ConstantPoolEntry(int id, int len, String escapedConstant, String encodedConstant) {
            this.id = id;
            this.length = len;
            this.escapedString = escapedConstant;
            this.encodedString = encodedConstant;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ConstantPoolEntry)) {
                return false;
            }
            ConstantPoolEntry o = (ConstantPoolEntry)other;
            return other instanceof ConstantPoolEntry && this.id == o.id && this.encodedString.equals(o.encodedString);
        }
    }
}

