/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xmlvm.Log;
import org.xmlvm.util.FileUtil;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class OutputFile {
    public static final String TAG_LIB_NAME = "lib-name";
    private UniversalFile data;
    private DelayedDataProvider provider;
    private String location = "";
    private String fileName = "";
    private String origin = null;
    private Map<String, String> tags = new HashMap<String, String>();

    public OutputFile() {
    }

    public OutputFile(DelayedDataProvider provider) {
        this.provider = provider;
    }

    public OutputFile(String data) {
        this.setData(data);
    }

    public OutputFile(byte[] data) {
        this.setData(data, System.currentTimeMillis());
    }

    public OutputFile(byte[] data, long lastModified) {
        this.setData(data, lastModified);
    }

    public OutputFile(UniversalFile file) {
        this.data = file;
    }

    public UniversalFile getData() {
        this.maybeLoadDelayedData();
        if (this.data == null) {
            return null;
        }
        return this.data;
    }

    public byte[] getDataAsBytes() {
        this.maybeLoadDelayedData();
        return this.data.getFileAsBytes();
    }

    public String getDataAsString() {
        this.maybeLoadDelayedData();
        return this.data.getFileAsString();
    }

    public final void setData(String data) {
        this.setData(data, System.currentTimeMillis());
    }

    public final void setData(String data, long lastModified) {
        if (data == null) {
            this.data = null;
        } else {
            try {
                this.setData(data.getBytes("UTF-8"), lastModified);
            }
            catch (UnsupportedEncodingException ex) {
                Log.error(ex.getMessage());
            }
        }
    }

    public final void setData(byte[] data, long lastModified) {
        this.data = UniversalFileCreator.createFile("", data, lastModified);
    }

    public boolean setDataFromStream(InputStream stream, long lastModified) {
        if (stream == null) {
            return false;
        }
        this.data = UniversalFileCreator.createFile("", stream, lastModified);
        return true;
    }

    public boolean setDataFromReader(BufferedReader in) {
        if (in == null) {
            return false;
        }
        StringWriter out = new StringWriter();
        if (FileUtil.copyReaders(in, out)) {
            this.setData(out.toString());
        }
        return false;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = new File(location).getAbsolutePath();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public ArrayList<OutputFile> getAffectedSourceFiles() {
        this.maybeLoadDelayedData();
        ArrayList<OutputFile> result = new ArrayList<OutputFile>();
        if (this.data == null || this.data.isFile()) {
            result.add(this);
        } else {
            UniversalFile[] files = this.data.listFilesRecursively();
            int dataPathLength = this.data.getAbsolutePath().length();
            for (UniversalFile file : files) {
                String relativePath = file.getAbsolutePath().substring(dataPathLength + 1);
                OutputFile outputFile = new OutputFile(file);
                String path = this.getFullPath();
                if (!relativePath.isEmpty()) {
                    path = path + relativePath;
                }
                String filelocation = path.substring(0, path.length() - file.getName().length());
                outputFile.setLocation(filelocation);
                outputFile.setFileName(file.getName());
                result.add(outputFile);
            }
        }
        return result;
    }

    public String getFullPath() {
        return this.location + (this.location.endsWith(File.separator) ? "" : File.separator) + this.fileName;
    }

    public String getRelativePath(String basePath) {
        String fullPath = this.getFullPath();
        if (!fullPath.startsWith(basePath)) {
            Log.error("'" + basePath + "' is not a base path of '" + fullPath);
            return null;
        }
        String result = fullPath.substring(basePath.length());
        if (result.startsWith(File.separator)) {
            result = result.substring(1);
        }
        return result;
    }

    public boolean write() {
        if (this.location.isEmpty()) {
            Log.warn("Cannot write OutputFile with no location: " + this.getFullPath());
            return false;
        }
        this.maybeLoadDelayedData();
        if (this.isEmpty()) {
            Log.warn("Ignoring empty or non-existent file: " + this.getFullPath());
            return false;
        }
        String pathAndName = this.getFullPath();
        return this.data.saveAs(pathAndName);
    }

    public boolean isDifferentFromExisting() {
        UniversalFile destination = UniversalFileCreator.createFile(new File(this.getFullPath()));
        if (!destination.exists() || !destination.isFile()) {
            return true;
        }
        this.maybeLoadDelayedData();
        return this.data.isDifferentFromExisting(this.getFullPath());
    }

    public boolean isEmpty() {
        this.maybeLoadDelayedData();
        return this.data == null || this.data.isEmpty();
    }

    private void maybeLoadDelayedData() {
        if (this.provider != null) {
            this.data = this.provider.getData();
            this.provider = null;
        }
    }

    public long getLastModified() {
        return this.data.getLastModified();
    }

    public void setTag(String tagName, String value) {
        this.tags.put(tagName, value);
    }

    public boolean hasTag(String tagName) {
        return this.tags.containsKey(tagName);
    }

    public String getTag(String tagName) {
        return this.tags.get(tagName);
    }

    public static interface DelayedDataProvider {
        public UniversalFile getData();
    }
}

