/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out;

import java.util.Collection;
import java.util.List;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.XmlvmProcessImpl;
import org.xmlvm.proc.XmlvmResource;
import org.xmlvm.proc.out.RecursiveResourceLoadingProcess;

public class RemoveDuplicateMethodsOutputProcess
extends XmlvmProcessImpl {
    private final String TAG = RemoveDuplicateMethodsOutputProcess.class.getName();

    public RemoveDuplicateMethodsOutputProcess(Arguments arguments) {
        super(arguments);
        this.addSupportedInput(RecursiveResourceLoadingProcess.class);
    }

    @Override
    public boolean processPhase1(BundlePhase1 bundle) {
        this.stripDuplicateMethods(bundle.getResources());
        return true;
    }

    @Override
    public boolean processPhase2(BundlePhase2 bundle) {
        this.stripDuplicateMethods(bundle.getResources());
        return true;
    }

    private void stripDuplicateMethods(Collection<XmlvmResource> xmlvmResources) {
        for (XmlvmResource xmlvmResource : xmlvmResources) {
            if (xmlvmResource == null) continue;
            this.stripDuplicateMethods(xmlvmResource);
        }
    }

    private void stripDuplicateMethods(XmlvmResource xmlvm) {
        List<XmlvmResource.XmlvmMethod> methods = xmlvm.getMethods();
        block0: for (XmlvmResource.XmlvmMethod search : methods) {
            if (!search.isSynthetic()) continue;
            for (XmlvmResource.XmlvmMethod each : methods) {
                if (!each.getName().equals(search.getName()) || !each.doesOverrideMethod(search) || each == search) continue;
                Log.debug(this.TAG, "Removing duplicate method " + search.getName() + " in " + xmlvm.getFullName());
                xmlvm.removeMethod(search);
                continue block0;
            }
        }
    }
}

