/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.out.OutputFile;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class DataResources {
    private static final String INTERNAL_DATAFILE_JAR_LOCATION = "/__PLATFORM__/data/";
    private static final String INTERNAL_DATAFILE_LOCATION = "var/__PLATFORM__/data/";
    private static final String DATAFILE_LOCATION = File.separator + "data" + File.separator;
    private Collection<UniversalFile> internalDataFiles = new ArrayList<UniversalFile>();

    public DataResources(String platform, String ... resources) {
        for (String resource : resources) {
            String dataPath;
            String dataInJarResource = INTERNAL_DATAFILE_JAR_LOCATION.replace("__PLATFORM__", platform) + resource;
            UniversalFile resourceFile = UniversalFileCreator.createFile(dataInJarResource, dataPath = INTERNAL_DATAFILE_LOCATION.replace("__PLATFORM__", platform) + resource);
            if (resourceFile == null || !resourceFile.exists()) continue;
            this.internalDataFiles.add(resourceFile);
        }
    }

    public DataResources(UniversalFile ... internal) {
        this.internalDataFiles.addAll(Arrays.asList(internal));
    }

    public Collection<OutputFile> composeResourceFiles(Arguments arguments) {
        ArrayList<OutputFile> outputFiles = new ArrayList<OutputFile>();
        ArrayList<UniversalFile> inputFiles = new ArrayList<UniversalFile>();
        inputFiles.addAll(this.internalDataFiles);
        for (String resourceName : arguments.option_resource()) {
            File resource = new File(resourceName);
            if (resource.exists()) {
                inputFiles.add(UniversalFileCreator.createFile(resource));
                continue;
            }
            Log.warn("Could not find specified resource " + resource + "; this will be omitted.");
        }
        for (UniversalFile inputFile : inputFiles) {
            OutputFile outputFile = new OutputFile(inputFile);
            outputFile.setLocation(arguments.option_out() + DATAFILE_LOCATION);
            outputFile.setFileName(inputFile.getName());
            outputFiles.add(outputFile);
        }
        return outputFiles;
    }
}

