/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out.build;

import java.util.StringTokenizer;

public class InfoPlist {
    private String text;

    public InfoPlist(String template) {
        this.text = template;
    }

    public void setIdentifier(String id) {
        this.text = this.text.replace("PROPERTY_BUNDLEIDENTIFIER", id);
    }

    public void setVersion(String version) {
        this.text = this.text.replace("PROPERTY_BUNDLEVERSION", version);
    }

    public void setDisplayName(String name) {
        this.text = this.text.replace("PROPERTY_BUNDLEDISPLAYNAME", name);
    }

    public void setStatusBarHidden(String statusbarhidden) {
        this.text = this.text.replace("PROPERTY_STATUSBARHIDDEN", InfoPlist.toBoolean(statusbarhidden));
    }

    public void setPrerenderIcon(String prerendericon) {
        this.text = this.text.replace("PROPERTY_PRERENDEREDICON", InfoPlist.toBoolean(prerendericon));
    }

    public void setFileSharingEnabled(String filesharingenabled) {
        this.text = this.text.replace("PROPERTY_FILESHARINGENABLED", InfoPlist.toBoolean(filesharingenabled));
    }

    public void setApplicationExits(String applicationexits) {
        this.text = this.text.replace("PROPERTY_APPLICATIONEXITS", InfoPlist.toBoolean(applicationexits));
    }

    public void setDefaultOrientation(String defaultorientation) {
        this.text = this.text.replace("PROPERTY_INTERFACE_ORIENTATION", defaultorientation);
    }

    public void setSupportedOrientations(String supportedorientations) {
        this.text = this.text.replace("PROPERTY_SUPPORTED_INTERFACE_ORIENTATIONS", InfoPlist.getPropertyAsArray("UISupportedInterfaceOrientations", "string", supportedorientations));
    }

    public void setFonts(String fonts) {
        this.text = this.text.replace("PROPERTY_FONTS", InfoPlist.getPropertyAsArray("UIAppFonts", "string", fonts));
    }

    public void setInjectedInfoPlist(String xml) {
        this.text = this.text.replace("PROPERTY_INJECTED_INFO_PLIST", xml == null ? "" : xml);
    }

    public void setApplication(String application) {
        this.text = this.text.replace("XMLVM_APP", application);
    }

    public void setMainNib(String mainNib) {
        this.text = this.text.replace("PROPERTY_MAINNIB", mainNib == null ? "" : mainNib);
    }

    public void setMainStoryboard(String mainStoryboard) {
        mainStoryboard = mainStoryboard != null && mainStoryboard.length() > 0 ? "<key>UIMainStoryboardFile</key>\n<string>" + mainStoryboard + "</string>" : "";
        this.text = this.text.replace("PROPERTY_MAINSTORYBOARD", mainStoryboard);
    }

    private static String getPropertyAsArray(String keyname, String type, String entries) {
        if (entries == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringTokenizer tk = new StringTokenizer(entries, ":");
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (token.length() == 0) continue;
            result.append("\t\t<").append(type).append(">");
            result.append(token).append("</").append(type).append(">\n");
        }
        String array = result.toString();
        return array.length() == 0 ? "" : "\t<key>" + keyname + "</key>\n\t<array>\n" + array + "\t</array>";
    }

    public String toString() {
        return this.text;
    }

    private static String toBoolean(String value) {
        return value.toLowerCase().equals("true") ? "true" : "false";
    }
}

