/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out.build;

import org.xmlvm.Log;

public enum XcodeSkeleton {
    IPHONE3("iphoneos3.1", "1"),
    IPHONE("iphoneos", "1"),
    IPAD("iphoneos", "2"),
    IOS("iphoneos", "1,2");

    public final String root;
    public final String target;
    public final String architecture;
    public final String deploymenttarget;

    private XcodeSkeleton(String root, String target) {
        this.root = root;
        this.target = target;
        this.architecture = target.equals("2") ? "ARCHS_UNIVERSAL_IPHONE_OS" : "ARCHS_STANDARD_32_BIT";
        this.deploymenttarget = root.endsWith("3.1") ? "3.1" : "4.0";
    }

    public static XcodeSkeleton getTarget(String skeleton) {
        skeleton = skeleton.toUpperCase();
        try {
            return XcodeSkeleton.valueOf(skeleton);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.warn("Unable to find xcode target " + skeleton + ". Using iphone instead.");
            return IPHONE;
        }
    }
}

