/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.refcount;

import java.util.List;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jdom.Namespace;
import org.xmlvm.refcount.InstructionUseInfo;
import org.xmlvm.refcount.RegisterSet;

public class InstructionProcessor {
    public static final String cmd_release = "reg-release";
    public static final String cmd_retain = "reg-retain";
    public static final String cmd_i_release = "i-release";
    public static final String cmd_s_release = "s-release";
    public static final String cmd_a_release = "a-release";
    public static final String cmd_tmp_equals_r = "tmp-equals-r";
    public static final String cmd_define_register = "define-register";
    public static final String cmd_define_register_attr_register = "register";
    public static final String cmd_define_register_attr_temp = "temp";
    public static final String cmd_define_register_attr_exception = "exception";
    public static final String cmd_set_null = "set-null";
    public static final String cmd_move_argument = "move-argument";
    public static final String cmd_comment = "comment";
    public static final Namespace dex = Namespace.getNamespace((String)"dex", (String)"http://xmlvm.org/dex");
    public static final Namespace vm = Namespace.getNamespace((String)"vm", (String)"http://xmlvm.org");
    static String nonObjTypesString = "(wide|boolean|byte|char|short|int|double|float|long)";
    static Pattern match3Op = Pattern.compile("^(add|sub|mul|div|rem|and|or|xor|shl|shr|ushr)-" + nonObjTypesString + ".*");
    static Pattern match2Op = Pattern.compile("^(add|sub|mul|div|rem|and|or|xor|shl|shr|ushr)-" + nonObjTypesString + "-2addr" + ".*");
    static Pattern matchOneOp = Pattern.compile("^(add|rsub|mul|div|rem|and|or|xor)-" + nonObjTypesString + "-lit(8|16)" + ".*");
    static Pattern matchIf1 = Pattern.compile("^(if)-(eq|ne|lt|ge|gt|le)z.*");
    static Pattern matchIf2 = Pattern.compile("^(if)-(eq|ne|lt|ge|gt|le).*");
    static Pattern iput = Pattern.compile("^(iput|sput)-" + nonObjTypesString + ".*");
    static Pattern iget = Pattern.compile("^(iget|sget)-" + nonObjTypesString + ".*");
    static Pattern invoke = Pattern.compile("^invoke-.*");
    static Pattern constDef = Pattern.compile("^const.*");
    static Pattern aputNonObj = Pattern.compile("^aput-" + nonObjTypesString + ".*");
    static Pattern agetNonObj = Pattern.compile("^aget-" + nonObjTypesString + ".*");
    static Pattern conversionNegNot = Pattern.compile("^(neg|not)-" + nonObjTypesString + ".*");
    static Pattern conversionfromTo = Pattern.compile("^" + nonObjTypesString + "-to-" + nonObjTypesString + ".*");
    static Pattern compInstr = Pattern.compile("^cmp.*");
    public static Pattern nonObjTypes = Pattern.compile("^" + nonObjTypesString);

    static RegisterSet getDestReg(Element x) throws DataConversionException {
        return InstructionProcessor.getDestReg(x, "vx");
    }

    static RegisterSet getDestReg(Element x, String name) throws DataConversionException {
        return RegisterSet.from(x.getAttribute(name).getIntValue());
    }

    static boolean processGeneric(Element element, InstructionUseInfo i) throws DataConversionException {
        String elemName = element.getName();
        if (matchOneOp.matcher(elemName).matches()) {
            i.isWrite = true;
        } else if (match2Op.matcher(elemName).matches()) {
            i.isWrite = true;
        } else if (match3Op.matcher(elemName).matches()) {
            i.isWrite = true;
        } else if (matchIf1.matcher(elemName).matches()) {
            i.isWrite = false;
        } else if (matchIf2.matcher(elemName).matches()) {
            i.isWrite = false;
        } else if (iput.matcher(elemName).matches()) {
            i.isWrite = false;
        } else if (iget.matcher(elemName).matches()) {
            i.isWrite = true;
        } else if (invoke.matcher(elemName).matches()) {
            InstructionProcessor.getUsedFromParams(element, i);
            InstructionProcessor.getMoveResult(element, i);
        } else if (constDef.matcher(elemName).matches()) {
            if (elemName.equals("const-class")) {
                // empty if block
            }
            i.isWrite = true;
        } else if (aputNonObj.matcher(elemName).matches()) {
            i.isWrite = false;
        } else if (agetNonObj.matcher(elemName).matches()) {
            i.isWrite = true;
        } else if (conversionNegNot.matcher(elemName).matches() || conversionfromTo.matcher(elemName).matches()) {
            i.isWrite = true;
        } else if (compInstr.matcher(elemName).matches()) {
            i.isWrite = true;
        } else {
            return false;
        }
        return true;
    }

    static void getUsedFromParams(Element funcCallElement, InstructionUseInfo i) throws DataConversionException {
        Element pHolder = funcCallElement.getChild("parameters", dex);
        List params = pHolder.getChildren("parameter", dex);
        for (Element parameter : params) {
            i.checkUsage(parameter.getAttribute(cmd_define_register_attr_register), parameter.getAttribute("type"));
        }
    }

    static void getMoveResult(Element funcCallElement, InstructionUseInfo i) throws DataConversionException {
        String returnType = funcCallElement.getChild("parameters", dex).getChild("return", dex).getAttribute("type").getValue();
        boolean returnsVoid = returnType.equals("void");
        Element pHolder = funcCallElement.getChild("move-result", dex);
        if (pHolder != null) {
            i.checkUsage(pHolder.getAttribute("vx"), pHolder.getAttribute("vx-type"));
            i.isWrite = true;
        } else {
            if (!returnsVoid && !nonObjTypes.matcher(returnType).matches()) {
                i.freeTmpAfter = true;
            }
            i.isWrite = false;
        }
    }

    public static void process_return(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_return_void(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_new_instance(Element element, InstructionUseInfo i) {
        i.isWrite = true;
    }

    public static void process_move_object_from16(Element element, InstructionUseInfo i) throws DataConversionException {
        i.isWrite = true;
        i.requiresRetain.orEq(i.writesObj());
    }

    public static void process_move_exception(Element element, InstructionUseInfo i) throws DataConversionException {
        i.isWrite = true;
    }

    public static void process_move_object(Element element, InstructionUseInfo i) throws DataConversionException {
        i.isWrite = true;
        i.requiresRetain.orEq(i.writesObj());
    }

    public static void process_move_wide(Element element, InstructionUseInfo i) {
        i.isWrite = true;
    }

    public static void process_move_wide_from16(Element element, InstructionUseInfo i) {
        i.isWrite = true;
    }

    public static void process_move_from16(Element element, InstructionUseInfo i) {
        i.isWrite = true;
    }

    public static void process_move(Element element, InstructionUseInfo i) {
        i.isWrite = true;
    }

    public static void process_return_object(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_var(Element element, InstructionUseInfo i) throws DataConversionException {
        i.isWrite = true;
        i.possibleWrites.clear();
        i.possibleWrites.add(cmd_define_register_attr_register);
        i.requiresRetain = i.writesObj();
    }

    public static void process_source_position(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_label(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_goto(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_goto_32(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_goto_16(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_aput(Element element, InstructionUseInfo i) throws DataConversionException {
        i.isWrite = false;
        i.requiresRetain.orEq(InstructionProcessor.getDestReg(element, "vx").and(i.usesAsObj()));
    }

    public static void process_aget(Element element, InstructionUseInfo i) throws DataConversionException {
        i.isWrite = true;
        i.requiresRetain.orEq(i.writesObj());
    }

    public static void process_aput_object(Element element, InstructionUseInfo i) throws DataConversionException {
        i.requiresRetain.orEq(InstructionProcessor.getDestReg(element, "vx").and(i.usesAsObj()));
        if (!i.requiresRetain.isEmpty()) {
            Element toAdd = new Element(cmd_a_release, vm);
            for (Attribute a : i.Instruction.getAttributes()) {
                toAdd.setAttribute(a.getName(), a.getValue(), a.getNamespace());
            }
            i.putRelease = toAdd;
        }
        i.isWrite = false;
    }

    public static void process_aget_object(Element element, InstructionUseInfo i) throws DataConversionException {
        i.isWrite = true;
        i.requiresRetain.orEq(i.writesObj());
    }

    public static void process_iput_object(Element element, InstructionUseInfo i) throws DataConversionException {
        i.requiresRetain.orEq(InstructionProcessor.getDestReg(element, "vx").and(i.usesAsObj()));
        if (!i.requiresRetain.isEmpty()) {
            Element toAdd = new Element(cmd_i_release, vm);
            for (Attribute a : i.Instruction.getAttributes()) {
                toAdd.setAttribute(a.getName(), a.getValue(), a.getNamespace());
            }
            i.putRelease = toAdd;
        }
        i.isWrite = false;
    }

    public static void process_iget_object(Element element, InstructionUseInfo i) throws DataConversionException {
        i.isWrite = true;
        i.requiresRetain.orEq(i.writesObj());
    }

    public static void process_sput_object(Element element, InstructionUseInfo i) throws DataConversionException {
        i.requiresRetain.orEq(InstructionProcessor.getDestReg(element, "vx").and(i.usesAsObj()));
        if (!i.requiresRetain.isEmpty()) {
            Element toAdd = new Element(cmd_s_release, vm);
            for (Attribute a : i.Instruction.getAttributes()) {
                toAdd.setAttribute(a.getName(), a.getValue(), a.getNamespace());
            }
            i.putRelease = toAdd;
        }
        i.isWrite = false;
    }

    public static void process_sget_object(Element element, InstructionUseInfo i) throws DataConversionException {
        i.isWrite = true;
        i.requiresRetain.orEq(i.writesObj());
    }

    public static void process_try_catch(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_catches(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_monitor_enter(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_monitor_exit(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_sget(Element element, InstructionUseInfo i) throws DataConversionException {
        i.isWrite = true;
        i.requiresRetain = i.writesObj();
    }

    public static void process_sput(Element element, InstructionUseInfo i) throws DataConversionException {
        i.requiresRetain.orEq(InstructionProcessor.getDestReg(element, "vx").and(i.usesAsObj()));
        if (!i.requiresRetain.isEmpty()) {
            Element toAdd = new Element(cmd_s_release, vm);
            for (Attribute a : i.Instruction.getAttributes()) {
                toAdd.setAttribute(a.getName(), a.getValue(), a.getNamespace());
            }
            i.putRelease = toAdd;
        }
        i.isWrite = false;
    }

    public static void process_iget(Element element, InstructionUseInfo i) throws DataConversionException {
        i.isWrite = true;
        i.requiresRetain = i.writesObj();
    }

    public static void process_iput(Element element, InstructionUseInfo i) throws DataConversionException {
        i.requiresRetain.orEq(InstructionProcessor.getDestReg(element, "vx").and(i.usesAsObj()));
        if (!i.requiresRetain.isEmpty()) {
            Element toAdd = new Element(cmd_i_release, vm);
            for (Attribute a : i.Instruction.getAttributes()) {
                toAdd.setAttribute(a.getName(), a.getValue(), a.getNamespace());
            }
            i.putRelease = toAdd;
        }
        i.isWrite = false;
    }

    public static void process_new_array(Element element, InstructionUseInfo i) {
        i.isWrite = true;
    }

    public static void process_sparse_switch(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_check_cast(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_packed_switch(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_array_length(Element element, InstructionUseInfo i) {
        i.isWrite = true;
    }

    public static void process_return_wide(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_throw(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_instance_of(Element element, InstructionUseInfo i) {
        i.isWrite = true;
    }

    public static void process_fill_array_data(Element element, InstructionUseInfo i) {
        i.isWrite = false;
    }

    public static void process_filled_new_array(Element element, InstructionUseInfo i) throws DataConversionException {
        Element moveResult = element.getChild("move-result", dex);
        for (Element valElement : element.getChildren("value", dex)) {
            i.checkUsage(valElement.getAttribute(cmd_define_register_attr_register), valElement.getAttribute("type"));
        }
        i.checkUsage(moveResult.getAttribute("vx"), moveResult.getAttribute("vx-type"));
        i.isWrite = true;
    }

    public static void process_filled_new_array_range(Element element, InstructionUseInfo i) throws DataConversionException {
        InstructionProcessor.process_filled_new_array(element, i);
    }
}

