/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.refcount;

import java.util.Iterator;
import javolution.util.FastBitSet;

public class RegisterSet
implements Iterable<Integer> {
    private FastBitSet map = new FastBitSet();

    public void orEq(RegisterSet other) {
        this.map.or(other.map);
    }

    public RegisterSet and(RegisterSet other) {
        RegisterSet toRet = RegisterSet.none();
        toRet.orEq(this);
        toRet.andEq(other);
        return toRet;
    }

    public void andEq(RegisterSet other) {
        this.map.and(other.map);
    }

    public RegisterSet or(RegisterSet other) {
        RegisterSet toRet = RegisterSet.none();
        toRet.orEq(this);
        toRet.orEq(other);
        return toRet;
    }

    public RegisterSet clone() {
        RegisterSet toRet = new RegisterSet();
        toRet.map.or(this.map);
        return toRet;
    }

    public void andEqNot(RegisterSet other) {
        RegisterSet tmp = other.clone();
        int lenForOp = Math.max(this.map.length(), other.map.length());
        tmp.map.flip(0, lenForOp);
        this.andEq(tmp);
    }

    public RegisterSet andNot(RegisterSet other) {
        RegisterSet toRet = this.clone();
        toRet.andEqNot(other);
        return toRet;
    }

    public void add(int i) {
        this.map.set(i);
    }

    public void clear(int i) {
        this.map.clear(i);
    }

    public void remove(int i) {
        this.map.clear(i);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public static RegisterSet from(int i) {
        RegisterSet toRet = RegisterSet.none();
        toRet.map.set(i);
        return toRet;
    }

    public String toString() {
        StringBuilder toRet = new StringBuilder();
        for (int x : this) {
            toRet.append("R" + x + " ");
        }
        return toRet.toString();
    }

    public static RegisterSet none() {
        return new RegisterSet();
    }

    public boolean equals(Object regs) {
        if (!(regs instanceof RegisterSet)) {
            return false;
        }
        return this.map.equals((Object)((RegisterSet)regs).map);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new FastBitSetIterator(this);
    }

    public boolean has(int oneReg) {
        return this.map.get(oneReg);
    }

    class FastBitSetIterator
    implements Iterator<Integer> {
        RegisterSet toIterate;
        int cur = 0;

        public FastBitSetIterator(RegisterSet toIterate) {
            this.toIterate = toIterate;
        }

        @Override
        public boolean hasNext() {
            int tmp = this.cur;
            tmp = this.toIterate.map.nextSetBit(this.cur);
            return tmp != -1;
        }

        @Override
        public Integer next() {
            int nextSetBit = this.toIterate.map.nextSetBit(this.cur);
            this.cur = nextSetBit + 1;
            return nextSetBit;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Impossible");
        }
    }
}

