/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.refcount.optimizations;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.xmlvm.refcount.CodePath;
import org.xmlvm.refcount.InstructionActions;
import org.xmlvm.refcount.InstructionUseInfo;
import org.xmlvm.refcount.OnePathInstructionRegisterContents;
import org.xmlvm.refcount.ReferenceCountingException;
import org.xmlvm.refcount.RegisterSet;
import org.xmlvm.refcount.optimizations.RefCountOptimization;

public class DeferredNullingOptimization
implements RefCountOptimization {
    @Override
    public RefCountOptimization.ReturnValue Process(List<CodePath> allCodePaths, Map<Element, InstructionActions> beenTo, Element codeElement) throws ReferenceCountingException, DataConversionException {
        RefCountOptimization.ReturnValue toRet = new RefCountOptimization.ReturnValue();
        RegisterSet allRegs = new RegisterSet();
        for (CodePath curPath : allCodePaths) {
            for (OnePathInstructionRegisterContents curInst : curPath.path) {
                InstructionUseInfo useInfo = beenTo.get((Object)curInst.instruction).useInfo;
                allRegs.orEq(useInfo.allWrites());
                allRegs.orEq(useInfo.usedReg());
            }
        }
        for (CodePath c : allCodePaths) {
            RegisterSet needsNull = RegisterSet.none();
            InstructionActions act = null;
            OnePathInstructionRegisterContents last = null;
            Iterator<OnePathInstructionRegisterContents> iterator = c.path.iterator();
            while (iterator.hasNext()) {
                OnePathInstructionRegisterContents curInst;
                last = curInst = iterator.next();
                act = beenTo.get(curInst.instruction);
                needsNull.orEq(act.useInfo.willNull);
                act.useInfo.willNull = RegisterSet.none();
                needsNull.andEqNot(act.useInfo.allWrites());
            }
            if (act == null) continue;
            if (last.instruction.getName().startsWith("return")) {
                act.useInfo.willNull = RegisterSet.none();
                continue;
            }
            act.useInfo.willNull.orEq(needsNull);
        }
        return toRet;
    }
}

