/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.refcount.optimizations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.xmlvm.refcount.CodePath;
import org.xmlvm.refcount.InstructionActions;
import org.xmlvm.refcount.InstructionUseInfo;
import org.xmlvm.refcount.OnePathInstructionRegisterContents;
import org.xmlvm.refcount.ReferenceCountingException;
import org.xmlvm.refcount.RegisterSet;
import org.xmlvm.refcount.optimizations.RefCountOptimization;

public class ExcessRetainsOptimization
implements RefCountOptimization {
    @Override
    public RefCountOptimization.ReturnValue Process(List<CodePath> allCodePaths, Map<Element, InstructionActions> beenTo, Element codeElement) throws ReferenceCountingException, DataConversionException {
        RefCountOptimization.ReturnValue toRet = new RefCountOptimization.ReturnValue();
        for (CodePath c : allCodePaths) {
            RegisterSet allRegs = new RegisterSet();
            for (OnePathInstructionRegisterContents curInst : c.path) {
                InstructionUseInfo useInfo = beenTo.get((Object)curInst.instruction).useInfo;
                allRegs.orEq(useInfo.allWrites());
                allRegs.orEq(useInfo.usedReg());
            }
            Iterator<Object> iterator = allRegs.iterator();
            while (iterator.hasNext()) {
                int reg = (Integer)iterator.next();
                ArrayList<PairUseInfoIndex> retains = new ArrayList<PairUseInfoIndex>();
                ArrayList<PairUseInfoIndex> releases = new ArrayList<PairUseInfoIndex>();
                int curIndex = 5;
                for (OnePathInstructionRegisterContents curInst : c.path) {
                    RegisterSet allWrites;
                    InstructionActions act = beenTo.get(curInst.instruction);
                    if (act.useInfo.willFree.has(reg)) {
                        releases.add(new PairUseInfoIndex(act.useInfo, curIndex));
                        ++curIndex;
                    }
                    if ((allWrites = act.useInfo.allWrites()).has(reg)) {
                        this.eliminateExcessRetains(reg, retains, releases);
                    }
                    if (!act.useInfo.requiresRetain.has(reg)) continue;
                    retains.add(new PairUseInfoIndex(act.useInfo, curIndex));
                    ++curIndex;
                }
                this.eliminateExcessRetains(reg, retains, releases);
            }
        }
        return toRet;
    }

    private void eliminateExcessRetains(int reg, List<PairUseInfoIndex> retains, List<PairUseInfoIndex> releases) {
        while (retains.size() != 0 && releases.size() != 0) {
            if (releases.get((int)0).index < retains.get((int)0).index) {
                retains.remove(0);
                continue;
            }
            int retainIdx = retains.size() - 1;
            retains.get((int)retainIdx).useInfo.requiresRetain.clear(reg);
            releases.get((int)0).useInfo.willFree.clear(reg);
            retains.remove(retainIdx);
            releases.remove(0);
        }
        retains.clear();
        releases.clear();
    }

    class PairUseInfoIndex {
        public InstructionUseInfo useInfo;
        public int index;

        public PairUseInfoIndex(InstructionUseInfo useInfo, int index) {
            this.useInfo = useInfo;
            this.index = index;
        }
    }
}

