/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.refcount.optimizations;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.xmlvm.refcount.CodePath;
import org.xmlvm.refcount.InstructionActions;
import org.xmlvm.refcount.InstructionProcessor;
import org.xmlvm.refcount.InstructionUseInfo;
import org.xmlvm.refcount.OnePathInstructionRegisterContents;
import org.xmlvm.refcount.ReferenceCountingException;
import org.xmlvm.refcount.RegisterSet;
import org.xmlvm.refcount.optimizations.RefCountOptimization;

public class RegisterSizeAndNullingOptimization
implements RefCountOptimization {
    @Override
    public RefCountOptimization.ReturnValue Process(List<CodePath> allCodePaths, Map<Element, InstructionActions> beenTo, Element codeElement) throws ReferenceCountingException, DataConversionException {
        RefCountOptimization.ReturnValue toRet = new RefCountOptimization.ReturnValue();
        RegisterSet allRegs = new RegisterSet();
        for (CodePath curPath : allCodePaths) {
            for (OnePathInstructionRegisterContents curInst : curPath.path) {
                InstructionUseInfo useInfo = beenTo.get((Object)curInst.instruction).useInfo;
                allRegs.orEq(useInfo.allWrites());
                allRegs.orEq(useInfo.usedReg());
            }
        }
        Iterator<Object> iterator = allRegs.iterator();
        while (iterator.hasNext()) {
            int regId = (Integer)iterator.next();
            Element initElem = new Element("define-register", InstructionProcessor.vm);
            initElem.setAttribute("vartype", "register");
            initElem.setAttribute("num", regId + "");
            toRet.functionInit.add(initElem);
        }
        int argIdx = 1;
        for (Element curElem : codeElement.getChildren()) {
            if (!curElem.getName().equals("var")) continue;
            Element moveArg = new Element("move-argument", InstructionProcessor.vm);
            moveArg.setAttribute("vx", curElem.getAttributeValue("register"));
            moveArg.setAttribute("vx-type", curElem.getAttributeValue("type"));
            String sourceName = curElem.getAttributeValue("name");
            if (sourceName == "this") {
                moveArg.setAttribute("sourceArg", "self");
            } else {
                moveArg.setAttribute("sourceArg", argIdx + "");
                ++argIdx;
            }
            toRet.functionInit.add(moveArg);
            allRegs.remove(curElem.getAttribute("register").getIntValue());
        }
        RegisterSet hasObj = RegisterSet.none();
        for (CodePath curPath : allCodePaths) {
            for (OnePathInstructionRegisterContents curInst : curPath.path) {
                InstructionUseInfo useInfo = beenTo.get((Object)curInst.instruction).useInfo;
                hasObj.orEq(useInfo.writesObj());
            }
        }
        allRegs.andEq(hasObj);
        Iterator<Object> iterator2 = allRegs.iterator();
        while (iterator2.hasNext()) {
            int regId = (Integer)iterator2.next();
            Element setNull = new Element("set-null", InstructionProcessor.vm);
            setNull.setAttribute("num", regId + "");
            toRet.functionInit.add(setNull);
        }
        return toRet;
    }
}

