/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.xmlvm.Log;
import org.xmlvm.util.universalfile.UniversalFile;

public class ClassListLoader {
    public static Set<String> loadGreenlist(UniversalFile file) {
        return ClassListLoader.loadList(file, "C");
    }

    public static Set<String> loadReflectionClassList(UniversalFile file) {
        return ClassListLoader.loadList(file, "R");
    }

    public static Set<String> loadRedlist(UniversalFile file) {
        return ClassListLoader.loadList(file, null);
    }

    private static Set<String> loadList(UniversalFile file, String prefix) {
        try {
            HashSet<String> result = new HashSet<String>();
            if (file != null) {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(file.getFileAsString()));
                while ((line = reader.readLine()) != null) {
                    if (line.contains(":")) {
                        if (prefix == null || !line.startsWith(prefix + ":")) continue;
                        result.add(line.replaceFirst(prefix + ":", "").trim());
                        continue;
                    }
                    result.add(line.trim());
                }
            }
            return result;
        }
        catch (IOException e) {
            Log.error(ClassListLoader.class.getSimpleName(), "Problem reading class list file: " + file.getAbsolutePath() + ": " + e.getMessage());
            return null;
        }
    }
}

