/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xmlvm.Log;
import org.xmlvm.proc.out.OutputFile;
import org.xmlvm.util.universalfile.UniversalFile;

public class FileMerger {
    private static final String TAG = FileMerger.class.getSimpleName();
    private static final String BEGIN_MARKER = "//XMLVM_BEGIN";
    private static final String END_MARKER = "//XMLVM_END";
    private final Collection<OutputFile> skeletons;
    private final String skeletonBasePath;
    private final Collection<UniversalFile> implementations;
    private final String implementationBasePath;

    public FileMerger(Collection<OutputFile> skeletons, String skeletonBasePath, Collection<UniversalFile> implementations, String implementationBasePath) {
        this.skeletons = skeletons;
        this.skeletonBasePath = skeletonBasePath;
        this.implementations = implementations;
        this.implementationBasePath = implementationBasePath;
    }

    public FileMerger(Collection<OutputFile> skeletons, Collection<UniversalFile> implementations) {
        this.skeletons = skeletons;
        this.skeletonBasePath = null;
        this.implementations = implementations;
        this.implementationBasePath = null;
    }

    public void process() {
        Map<String, Map<String, String>> existingSections = this.extractAllSections();
        this.injectAllSections(existingSections);
    }

    private Map<String, Map<String, String>> extractAllSections() {
        HashMap<String, Map<String, String>> output = new HashMap<String, Map<String, String>>();
        for (UniversalFile existingFile : this.implementations) {
            if (!existingFile.isFile() || existingFile.isEmpty()) continue;
            String key = this.implementationBasePath != null ? existingFile.getRelativePath(this.implementationBasePath) : existingFile.getName();
            Map<String, String> sections = this.extractSections(existingFile);
            output.put(key, sections);
        }
        return output;
    }

    private Map<String, String> extractSections(UniversalFile file) {
        HashMap<String, String> sections = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new StringReader(file.getFileAsString()));
        StringBuilder section = null;
        String currentKey = null;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.contains(BEGIN_MARKER)) {
                    section = new StringBuilder();
                    currentKey = line.trim();
                    continue;
                }
                if (line.contains(END_MARKER)) {
                    if (section == null) {
                        Log.error(TAG, "Found end marker without matching starting marker: " + line);
                        continue;
                    }
                    sections.put(currentKey, section.toString());
                    section = null;
                }
                if (section == null) continue;
                section.append(line);
                section.append('\n');
            }
        }
        catch (IOException e) {
            Log.error(TAG, "Could not read file: " + e.getMessage());
        }
        return sections;
    }

    private void injectAllSections(Map<String, Map<String, String>> sections) {
        for (OutputFile file : this.skeletons) {
            String key = this.skeletonBasePath != null ? file.getRelativePath(this.skeletonBasePath) : file.getFileName();
            if (!sections.containsKey(key)) continue;
            Log.debug(TAG, "Injecting contents into " + file.getFullPath());
            this.injectSections(sections.get(key), file);
        }
    }

    private void injectSections(Map<String, String> sections, OutputFile file) {
        BufferedReader reader = new BufferedReader(new StringReader(file.getDataAsString()));
        try {
            String line;
            StringBuilder fileContent = new StringBuilder();
            boolean doNotAdd = false;
            while ((line = reader.readLine()) != null) {
                String sectionKey;
                if (!doNotAdd) {
                    fileContent.append(line);
                    fileContent.append('\n');
                }
                if (line.contains(BEGIN_MARKER) && sections.containsKey(sectionKey = line.trim())) {
                    fileContent.append(sections.get(sectionKey));
                    doNotAdd = true;
                }
                if (!line.contains(END_MARKER)) continue;
                if (doNotAdd) {
                    fileContent.append(line);
                    fileContent.append('\n');
                }
                doNotAdd = false;
            }
            file.setData(fileContent.toString());
        }
        catch (IOException e) {
            Log.error(TAG, "Could not read file: " + e.getMessage());
        }
    }
}

