/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xmlvm.Log;
import org.xmlvm.util.universalfile.UniversalFile;

public class FileUtil {
    private static final String TAG = "FileUtil";

    public static boolean copyDirectory(UniversalFile source, String destination, boolean recursive) {
        if (!source.isDirectory()) {
            Log.error(TAG, "CopyDirectory: Source is not a directory: " + source);
            return false;
        }
        if (destination.endsWith(File.separator)) {
            destination = destination.substring(0, destination.length() - 1);
        }
        for (UniversalFile file : source.listFiles()) {
            if (file.isDirectory() && recursive) {
                String subPath = destination + file.getAbsolutePath().substring(source.getAbsolutePath().length());
                FileUtil.copyDirectory(file, subPath, recursive);
                continue;
            }
            if (!file.isFile()) continue;
            file.saveAs(destination + File.separator + file.getName());
        }
        return true;
    }

    public static boolean copyFile(File source, File destination) {
        try {
            if (source.equals(destination)) {
                Log.debug("Ignoring copying of file " + source.getPath() + ": destination is same as source.");
                return true;
            }
            Log.debug("Copying " + source.getPath() + " to " + destination.getPath());
            return FileUtil.copyStreams(new FileInputStream(source), new FileOutputStream(destination));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static boolean copyStreams(InputStream in, OutputStream out) {
        if (in == null || out == null) {
            return false;
        }
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            return true;
        }
        catch (IOException e) {
            try {
                in.close();
            }
            catch (IOException ex1) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyReaders(BufferedReader in, Writer out) {
        if (in == null || out == null) {
            return false;
        }
        try {
            String line;
            while ((line = in.readLine()) != null) {
                out.append(line).append('\n');
            }
            in.close();
            out.close();
            return true;
        }
        catch (IOException e) {
            try {
                in.close();
            }
            catch (IOException ex1) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            e.printStackTrace();
            return false;
        }
    }

    public static String getBinDirectory() {
        return new File("bin").getAbsolutePath();
    }

    public static byte[] readBytesFromStream(InputStream stream) {
        if (stream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        int READ_BUFFER = 4096;
        byte[] b = new byte[4096];
        int l = 0;
        try {
            while ((l = stream.read(b)) > 0) {
                byteArrayStream.write(b, 0, l);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return new byte[0];
        }
        return byteArrayStream.toByteArray();
    }

    public static String readStringFromStream(InputStream stream) {
        int READ_BUFFER = 4096;
        StringBuilder buffer = new StringBuilder();
        byte[] b = new byte[4096];
        int l = 0;
        try {
            if (stream == null) {
                return "";
            }
            while ((l = stream.read(b)) > 0) {
                buffer.append(new String(b, 0, l));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return "";
        }
        return buffer.toString();
    }

    public static boolean writeStringToFile(File file, String content) {
        try {
            OutputStreamWriter stageAssistantWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            stageAssistantWriter.write(content);
            stageAssistantWriter.close();
        }
        catch (IOException e) {
            Log.error("Could not write to " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtil.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }
}

