/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.XmlvmResource;
import org.xmlvm.proc.lib.LibraryLoader;
import org.xmlvm.util.comparators.ClassNameComparator;
import org.xmlvm.util.comparators.XmlvmMethodComparator;

public class ObjectHierarchyHelper {
    private static final String TAG = ObjectHierarchyHelper.class.getSimpleName();
    private static final int CHILD = 0;
    private static final int PARENT = 1;
    private GraphNode root = new GraphNode();
    private Map<String, GraphNode> treeIndex = new HashMap<String, GraphNode>();
    private Map<String, XmlvmResource> preloadedResources = new HashMap<String, XmlvmResource>();
    private Map<String, ColoredGraphNode> conflictGraph = new HashMap<String, ColoredGraphNode>();
    private Arguments arguments;

    public ObjectHierarchyHelper(Map<String, XmlvmResource> resourcePool, Arguments arguments) {
        this.arguments = arguments;
        this.preloadedResources = resourcePool;
        for (XmlvmResource resource : resourcePool.values()) {
            if (resource.getType() == XmlvmResource.Type.CONST_POOL) continue;
            this.insertResource(resource);
        }
        for (XmlvmResource resource : resourcePool.values()) {
            String classType;
            if (resource.getType() == XmlvmResource.Type.CONST_POOL) continue;
            for (XmlvmResource.XmlvmMethod method : resource.getMethods()) {
                for (XmlvmResource.XmlvmInvokeInstruction xmlvmInvokeInstruction : method.getVtableInvokeInstructions()) {
                    String className = xmlvmInvokeInstruction.getClassType();
                    if (className.indexOf("[]") != -1) {
                        className = "java.lang.Object";
                    }
                    this.getXmlvmResource(className);
                }
            }
            ArrayList<XmlvmResource.XmlvmInvokeInstruction> invokeInstructions = new ArrayList<XmlvmResource.XmlvmInvokeInstruction>();
            ArrayList<XmlvmResource.XmlvmMemberReadWrite> memberReadWriteInstructions = new ArrayList<XmlvmResource.XmlvmMemberReadWrite>();
            resource.collectInstructions(invokeInstructions, memberReadWriteInstructions);
            for (XmlvmResource.XmlvmInvokeInstruction xmlvmInvokeInstruction : invokeInstructions) {
                classType = xmlvmInvokeInstruction.getClassType();
                this.getXmlvmResource(classType);
            }
            for (XmlvmResource.XmlvmMemberReadWrite xmlvmMemberReadWrite : memberReadWriteInstructions) {
                classType = xmlvmMemberReadWrite.getClassType();
                this.getXmlvmResource(classType);
            }
        }
        Log.debug(TAG, "Done building object tree");
    }

    public boolean isOverridden(String fullName, XmlvmResource.XmlvmMethod method) {
        GraphNode node = this.getNode(fullName);
        return this.isOverridden(node, method, 0) || this.isOverridden(node, method, 1);
    }

    public boolean isOverridding(String fullName, XmlvmResource.XmlvmMethod method) {
        GraphNode node = this.getNode(fullName);
        Set<GraphNode> toCheck = node.getParents();
        for (GraphNode current : toCheck) {
            XmlvmResource childClass = current.getResource();
            if (childClass.isInterface()) continue;
            for (XmlvmResource.XmlvmMethod each : childClass.getMethods()) {
                if (!each.doesOverrideMethod(method)) continue;
                return true;
            }
            if (!this.isOverridding(childClass.getFullName(), method)) continue;
            return true;
        }
        return false;
    }

    private boolean isOverridden(GraphNode node, XmlvmResource.XmlvmMethod method, int parentOrChild) {
        Set<GraphNode> toCheck = parentOrChild == 0 ? node.getChildren() : node.getParents();
        for (GraphNode current : toCheck) {
            XmlvmResource childClass = current.getResource();
            for (XmlvmResource.XmlvmMethod each : childClass.getMethods()) {
                if (!each.doesOverrideMethod(method)) continue;
                return true;
            }
            if (!this.isOverridden(current, method, parentOrChild)) continue;
            return true;
        }
        return false;
    }

    public XmlvmResource getXmlvmResource(String fullName) {
        GraphNode graphNode = this.getNode(fullName);
        return graphNode == null ? null : graphNode.getResource();
    }

    private GraphNode getNode(String fullName) {
        if (!this.treeIndex.containsKey(fullName)) {
            XmlvmResource resource = this.loadResource(fullName);
            if (resource != null) {
                this.insertResource(resource);
            } else {
                Log.error("Couldn't create node for " + fullName);
            }
        }
        return this.treeIndex.get(fullName);
    }

    private GraphNode insertResource(XmlvmResource resource) {
        String fullName = resource.getFullName();
        if (!this.treeIndex.containsKey(fullName)) {
            Log.debug(TAG, "Inserting " + resource.getFullName() + " into object tree");
            GraphNode newNode = null;
            if (resource.isInterface()) {
                newNode = this.insertInterface(resource);
            } else {
                newNode = this.insertClass(resource);
                this.addInterfaces(newNode, resource);
            }
            this.treeIndex.put(resource.getFullName(), newNode);
            return newNode;
        }
        return this.treeIndex.get(fullName);
    }

    private GraphNode insertClass(XmlvmResource resource) {
        String superType = resource.getSuperTypeName();
        if (superType == null || superType.equals("")) {
            this.root.setResource(resource);
            return this.root;
        }
        GraphNode superNode = this.getNode(superType);
        GraphNode newNode = new GraphNode(resource);
        superNode.add(newNode);
        return newNode;
    }

    private GraphNode insertInterface(XmlvmResource resource) {
        GraphNode newNode = new GraphNode(resource);
        this.addInterfaces(newNode, resource);
        return newNode;
    }

    private void addInterfaces(GraphNode newNode, XmlvmResource resource) {
        String interfaces = resource.getInterfaces();
        if (interfaces != null && !interfaces.equals("")) {
            for (String interfaceName : interfaces.split("\\,")) {
                GraphNode interfaceNode = this.getNode(interfaceName);
                interfaceNode.add(newNode);
            }
        }
    }

    private XmlvmResource loadResource(String fullName) {
        if (this.preloadedResources.containsKey(fullName)) {
            return this.preloadedResources.get(fullName);
        }
        Log.debug(TAG, "Loading JDK class: " + fullName);
        LibraryLoader loader = new LibraryLoader(this.arguments);
        XmlvmResource resource = loader.load(fullName);
        return resource;
    }

    public Set<XmlvmResource> getChildrenRecursive(String fullName) {
        Set<GraphNode> children = this.getChildrenRecursive(this.getNode(fullName));
        HashSet<XmlvmResource> ret = new HashSet<XmlvmResource>();
        for (GraphNode node : children) {
            ret.add(node.getResource());
        }
        return ret;
    }

    private Set<GraphNode> getChildrenRecursive(GraphNode node) {
        HashSet<GraphNode> children = new HashSet<GraphNode>();
        for (GraphNode parent : node.getChildren()) {
            children.add(parent);
            children.addAll(this.getChildrenRecursive(parent));
        }
        return children;
    }

    public Set<XmlvmResource> getParentsRecursive(String fullName) {
        Set<GraphNode> parents = this.getParentsRecursive(this.getNode(fullName));
        HashSet<XmlvmResource> ret = new HashSet<XmlvmResource>();
        for (GraphNode node : parents) {
            ret.add(node.getResource());
        }
        return ret;
    }

    private Set<GraphNode> getParentsRecursive(GraphNode node) {
        HashSet<GraphNode> parents = new HashSet<GraphNode>();
        for (GraphNode parent : node.getParents()) {
            parents.add(parent);
            parents.addAll(this.getParentsRecursive(parent));
        }
        return parents;
    }

    public Set<XmlvmResource> getInterfacesRecursive(String fullName) {
        Set<GraphNode> interfaces = this.getParentsRecursive(this.getNode(fullName));
        HashSet<XmlvmResource> ret = new HashSet<XmlvmResource>();
        for (GraphNode node : interfaces) {
            if (!node.getResource().isInterface()) continue;
            ret.add(node.getResource());
        }
        return ret;
    }

    public void redeclareInterfaceMethodsInAbstractClasses() {
        for (GraphNode node : this.treeIndex.values()) {
            if (!node.getResource().isAbstract()) continue;
            Set<XmlvmResource> interfaces = this.getInterfacesRecursive(node.getResource().getFullName());
            HashSet<XmlvmResource.XmlvmMethod> interfaceMethods = new HashSet<XmlvmResource.XmlvmMethod>();
            for (XmlvmResource ifaceResource : interfaces) {
                interfaceMethods.addAll(ifaceResource.getMethods());
            }
            Set<GraphNode> parents = this.getParentsRecursive(node);
            HashSet<XmlvmResource.XmlvmMethod> classMethods = new HashSet<XmlvmResource.XmlvmMethod>();
            classMethods.addAll(node.getResource().getMethods());
            for (GraphNode parent : parents) {
                if (parent.getResource().isInterface()) continue;
                classMethods.addAll(parent.getResource().getMethods());
            }
            ArrayList methods = new ArrayList(interfaceMethods);
            Collections.sort(methods, new XmlvmMethodComparator());
            block3: for (XmlvmResource.XmlvmMethod ifaceMethod : methods) {
                for (XmlvmResource.XmlvmMethod classMethod : classMethods) {
                    if (!ifaceMethod.doesOverrideMethod(classMethod)) continue;
                    continue block3;
                }
                classMethods.add(ifaceMethod);
                node.getResource().addMethod(ifaceMethod).setSynthetic(true);
            }
        }
    }

    public void calculateInterfaceIndices() {
        this.buildConflictGraph();
        Log.debug(TAG, "Built interface conflict graph containing " + this.conflictGraph.size() + " interfaces");
        int lastStartingNumber = this.colorConflictGraph();
        Log.debug(TAG, "Colored graph with highest starting index " + lastStartingNumber);
        this.verifyConflictGraph();
        Log.debug(TAG, "Verified correctness of coloring for " + this.conflictGraph.size() + " interfaces");
        Log.debug(TAG, "Done calculating interface indices");
    }

    private void buildConflictGraph() {
        for (GraphNode node : this.treeIndex.values()) {
            String fullName = node.getResource().getFullName();
            if (!node.getResource().isInterface()) continue;
            ColoredGraphNode newNode = new ColoredGraphNode(node.getResource());
            this.conflictGraph.put(fullName, newNode);
            Log.debug(TAG, "Added " + fullName + " to conflict graph");
        }
        for (GraphNode node : this.treeIndex.values()) {
            this.processNodeForConflictGraph(node);
        }
    }

    private void processNodeForConflictGraph(GraphNode node) {
        ArrayList<ColoredGraphNode> conflictingInterfaces = new ArrayList<ColoredGraphNode>();
        for (XmlvmResource interfaceResource : this.getInterfacesRecursive(node.getResource().getFullName())) {
            String fullName = interfaceResource.getFullName();
            conflictingInterfaces.add(this.conflictGraph.get(fullName));
        }
        for (ColoredGraphNode connectFromNode : conflictingInterfaces) {
            for (ColoredGraphNode connectToNode : conflictingInterfaces) {
                if (connectFromNode.getResource().getFullName().equals(connectToNode.getResource().getFullName())) continue;
                connectToNode.add(connectFromNode);
            }
        }
    }

    private int colorConflictGraph() {
        int maxColor = 0;
        Collection<ColoredGraphNode> values = this.conflictGraph.values();
        ArrayList<ColoredGraphNode> orderedNodes = new ArrayList<ColoredGraphNode>();
        for (ColoredGraphNode node : values) {
            orderedNodes.add(node);
        }
        Collections.sort(orderedNodes, new ColoredGraphNodeComparator());
        for (ColoredGraphNode node : orderedNodes) {
            int nodeMaxColor = this.colorNode(node);
            maxColor = Math.max(nodeMaxColor, maxColor);
        }
        return maxColor;
    }

    private int colorNode(ColoredGraphNode node) {
        ArrayList<Integer> usedColors = new ArrayList<Integer>();
        for (ColoredGraphNode neighbor : node.getNeighbors()) {
            usedColors.addAll(neighbor.getColors());
        }
        int current = 0;
        List<XmlvmResource.XmlvmMethod> methods = node.getResource().getMethodsSorted();
        for (XmlvmResource.XmlvmMethod method : methods) {
            if (method.isStatic()) {
                node.getColors().add(-1);
                continue;
            }
            while (usedColors.contains(current)) {
                ++current;
            }
            node.getColors().add(current);
            ++current;
        }
        return current;
    }

    public void verifyConflictGraph() {
        for (ColoredGraphNode node : this.conflictGraph.values()) {
            if (node.getResource().getMethods().size() != node.getColors().size()) {
                throw new RuntimeException("Not every method in interface " + node.getResource().getFullName() + " is assigned a color!");
            }
            ArrayList<Integer> usedColors = new ArrayList<Integer>();
            for (ColoredGraphNode neighbor : node.getNeighbors()) {
                usedColors.addAll(neighbor.getColors());
            }
            Iterator<Object> iterator = node.getColors().iterator();
            while (iterator.hasNext()) {
                int currentColor = (Integer)iterator.next();
                if (!usedColors.contains(currentColor)) continue;
                throw new RuntimeException("Color conflict with neighbor in interface " + node.getResource().getFullName() + "!");
            }
        }
    }

    public void computeInterfaceTableInformation() {
        int itableSizeTotal = 0;
        int itableCount = 0;
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>(this.treeIndex.values());
        Collections.sort(nodes, new GraphNodeComparator());
        for (GraphNode node : nodes) {
            if (node.getResource().isInterface()) continue;
            Set<XmlvmResource> interfaces = this.getInterfacesRecursive(node.getResource().getFullName());
            int maxIndex = -1;
            for (XmlvmResource iface : interfaces) {
                List<XmlvmResource.XmlvmMethod> ifaceMethods = iface.getMethodsSorted();
                for (XmlvmResource.XmlvmMethod m : ifaceMethods) {
                    maxIndex = Math.max(maxIndex, this.getInterfaceIndex(iface, m, ifaceMethods));
                }
            }
            node.getResource().setInterfaceTableSize(++maxIndex);
            ++itableCount;
            itableSizeTotal += maxIndex;
        }
        Log.debug(TAG, "The average itable size is " + (double)itableSizeTotal / (double)itableCount);
        ArrayList<ColoredGraphNode> orderedNodes = new ArrayList<ColoredGraphNode>(this.conflictGraph.values());
        Collections.sort(orderedNodes, new ColoredGraphNodeComparator());
        for (ColoredGraphNode node : orderedNodes) {
            this.computeMethodItableIndex(node);
        }
    }

    private void computeMethodItableIndex(ColoredGraphNode node) {
        int index = 0;
        List<XmlvmResource.XmlvmMethod> methods = node.getResource().getMethodsSorted();
        for (XmlvmResource.XmlvmMethod method : methods) {
            if (method.isStatic()) continue;
            int color = node.getColors().get(index);
            method.setInterfaceTableIndex(color);
            ++index;
        }
    }

    public int getInterfaceIndex(XmlvmResource iface, XmlvmResource.XmlvmMethod m, List<XmlvmResource.XmlvmMethod> ifaceMethods) {
        ColoredGraphNode node = this.conflictGraph.get(iface.getFullName());
        int interfaceIndex = -1;
        for (int i = 0; i < ifaceMethods.size(); ++i) {
            if (!ifaceMethods.get(i).doesOverrideMethod(m)) continue;
            interfaceIndex = node.getColors().get(i);
            break;
        }
        String parameterList = "";
        for (String parameter : m.getParameterTypes()) {
            parameterList = parameterList + parameter + " ";
        }
        Log.debug(TAG, "Interface index for " + iface.getFullName() + " " + m.getName() + "(" + parameterList + ") = " + interfaceIndex);
        return interfaceIndex;
    }

    public static String escapeName(String resourceName) {
        return resourceName.replace('.', '_').replace('$', '_');
    }

    public static String getParameterString(List<String> parameterTypes) {
        StringBuilder parameterString = new StringBuilder(parameterTypes.size() * 16);
        if (parameterTypes.size() > 0) {
            for (String parameter : parameterTypes) {
                parameterString.append("_");
                int i = parameter.indexOf(91);
                int dim = i == -1 ? 0 : (parameter.length() - i) / 2;
                parameter = parameter.replaceAll("\\[\\]", "");
                parameter = ObjectHierarchyHelper.escapeName(parameter);
                parameterString.append(parameter);
                if (dim <= 0) continue;
                parameterString.append("_").append(dim).append("ARRAY");
            }
        }
        return parameterString.toString();
    }

    private class ColoredGraphNode {
        private XmlvmResource resource;
        private Set<ColoredGraphNode> neighbors = new HashSet<ColoredGraphNode>();
        private List<Integer> colors = new ArrayList<Integer>();

        public ColoredGraphNode(XmlvmResource resource) {
            this.resource = resource;
        }

        public List<Integer> getColors() {
            return this.colors;
        }

        public XmlvmResource getResource() {
            return this.resource;
        }

        public Set<ColoredGraphNode> getNeighbors() {
            return this.neighbors;
        }

        public void add(ColoredGraphNode newNode) {
            this.neighbors.add(newNode);
            newNode.neighbors.add(this);
        }
    }

    private class GraphNode {
        private XmlvmResource resource;
        private Set<GraphNode> children = new HashSet<GraphNode>();
        private Set<GraphNode> parents = new HashSet<GraphNode>();

        public GraphNode() {
        }

        public GraphNode(XmlvmResource resource) {
            this.resource = resource;
        }

        public XmlvmResource getResource() {
            return this.resource;
        }

        public void setResource(XmlvmResource resource) {
            this.resource = resource;
        }

        public Set<GraphNode> getChildren() {
            return this.children;
        }

        public Set<GraphNode> getParents() {
            return this.parents;
        }

        public void add(GraphNode newNode) {
            this.children.add(newNode);
            newNode.parents.add(this);
        }
    }

    private static class GraphNodeComparator
    implements Comparator<GraphNode> {
        private static Comparator<String> comparator = new ClassNameComparator();

        private GraphNodeComparator() {
        }

        @Override
        public int compare(GraphNode n1, GraphNode n2) {
            return comparator.compare(n1.getResource().getFullName(), n2.getResource().getFullName());
        }
    }

    private static class ColoredGraphNodeComparator
    implements Comparator<ColoredGraphNode> {
        private static Comparator<String> comparator = new ClassNameComparator();

        private ColoredGraphNodeComparator() {
        }

        @Override
        public int compare(ColoredGraphNode n1, ColoredGraphNode n2) {
            return comparator.compare(n1.getResource().getFullName(), n2.getResource().getFullName());
        }
    }
}

