/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class TutorialWebGenerator {
    private static final String OUTPUT_FILENAME = "index.html";

    public static void main(String[] args) {
        Params params = Params.parse(args);
        String template = TutorialWebGenerator.readFromFile(params.templatePath);
        String html = TutorialWebGenerator.generateHtml(TutorialWebGenerator.readOverviewXml(params.overviewPath), template, params.outputPath);
        TutorialWebGenerator.writeHtmlToDisk(html, params.outputPath);
        System.out.println("All done.");
    }

    private static String generateHtml(Document overview, String template, String outputPath) {
        List iosApplications = overview.getRootElement().getChild("ios-tutorials").getChild("tutorials").getChildren("application");
        List androidApplications = overview.getRootElement().getChild("android-tutorials").getChild("tutorials").getChildren("application");
        StringBuilder tutorialEntries = new StringBuilder();
        StringBuilder generatedCode = new StringBuilder();
        tutorialEntries.append("<div class=\"ios\">");
        tutorialEntries.append("<div class=\"platformTitle\">iOS</div>");
        int i = 0;
        for (Element iosApplication : iosApplications) {
            tutorialEntries.append(TutorialWebGenerator.generateTutorialEntry(++i, "ios", iosApplication));
            generatedCode.append(TutorialWebGenerator.generateCodeFiles("ios", iosApplication, outputPath));
        }
        tutorialEntries.append("</div>");
        tutorialEntries.append("<div class=\"android\">");
        tutorialEntries.append("<div class=\"platformTitle\">Android</div>");
        i = 0;
        for (Element androidApplication : androidApplications) {
            tutorialEntries.append(TutorialWebGenerator.generateTutorialEntry(++i, "android", androidApplication));
            generatedCode.append(TutorialWebGenerator.generateCodeFiles("android", androidApplication, outputPath));
        }
        tutorialEntries.append("</div>");
        template = template.replace("{{TUTORIAL_LIST}}", tutorialEntries);
        template = template.replace("{{GENERATED_CODE}}", generatedCode.toString());
        return template;
    }

    private static String generateTutorialEntry(int index, String platform, Element application) {
        String title = application.getAttributeValue("name");
        String id = TutorialWebGenerator.md5(platform + title);
        String slidesUrl = application.getAttributeValue("slides");
        String description = application.getChildText("text");
        StringBuilder html = new StringBuilder();
        html.append("<script>slidesUrl['" + id + "'] = '" + slidesUrl + "';</script>");
        html.append("<div id=\"" + id + "\" class=\"tutorialEntry\" onclick=\"javascript:switchToTutorial('" + id + "');\">");
        html.append("<div class=\"tutorialTitle\">");
        html.append(index + ". " + title);
        html.append("</div>");
        html.append("<div class=\"description\">");
        html.append(description);
        html.append("</div></div>");
        return html.toString();
    }

    private static String generateCodeFiles(String platform, Element application, String outputPath) {
        outputPath = outputPath + "/code";
        File output = new File(outputPath);
        System.out.println("Output Path: " + output.getAbsolutePath());
        if (!output.exists() && !output.mkdirs()) {
            System.err.println("Could not create output directory");
            return "";
        }
        String title = application.getAttributeValue("name");
        String id = TutorialWebGenerator.md5(platform + title);
        StringBuilder htmlJs = new StringBuilder();
        htmlJs.append("<script>\n");
        htmlJs.append("codeFiles['" + id + "'] = [");
        Element filesElement = application.getChild("files");
        File basePath = new File(filesElement.getAttributeValue("base"));
        List fileElements = filesElement.getChildren("file");
        for (Element fileElement : fileElements) {
            String name = fileElement.getAttributeValue("name");
            File file = new File(basePath + "/" + name);
            if (file.exists() && file.isFile()) {
                String fileName = id + "-" + name.replace('/', '-') + ".html";
                String pathName = output.getAbsolutePath() + "/" + fileName;
                System.out.println("FileName: " + pathName);
                String sourceCode = TutorialWebGenerator.readFromFile(file.getAbsolutePath());
                String brush = "java";
                String displayName = name;
                if (name.endsWith(".xml")) {
                    brush = "xml";
                }
                if (name.endsWith(".java")) {
                    displayName = name.substring(name.lastIndexOf(47) + 1);
                }
                String fileContent = TutorialWebGenerator.createCodeFile(sourceCode, brush);
                fileContent = fileContent.replace("/* Copyright", "/** Copyright");
                fileContent = fileContent.replace("/*\n", "/**\n");
                TutorialWebGenerator.writeToDisk(fileContent, pathName);
                htmlJs.append("{'loc':'code/" + fileName + "', 'label':'" + displayName + "'},");
                continue;
            }
            System.err.println("File does not exist or is not a file: " + file.getAbsolutePath());
        }
        htmlJs.append("{}];\n");
        htmlJs.append("</script>\n");
        return htmlJs.toString();
    }

    private static String createCodeFile(String sourceCode, String brush) {
        StringBuilder fileContent = new StringBuilder();
        fileContent.append("<div class=\"listing\"><script type=\"syntaxhighlighter\" class=\"brush: " + brush + "\"><![CDATA[\n");
        fileContent.append(sourceCode);
        fileContent.append("\n]]></script></div>");
        return fileContent.toString();
    }

    private static Document readOverviewXml(String path) {
        SAXBuilder builder = new SAXBuilder();
        File overviewFile = new File(path);
        if (!overviewFile.exists()) {
            System.err.println("Overview file doesn't exist: " + overviewFile.getAbsolutePath());
            return null;
        }
        try {
            return builder.build(overviewFile);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void writeHtmlToDisk(String html, String pathStr) {
        File path;
        if (pathStr == null || pathStr.equals("")) {
            pathStr = ".";
        }
        if ((path = new File(pathStr)).exists() && path.isFile()) {
            System.err.println("Output path is a file.");
            return;
        }
        if (!path.exists() && !path.mkdirs()) {
            System.err.println("Couldn't create output folder.");
            return;
        }
        File outputFile = new File(path.getAbsoluteFile() + File.separator + OUTPUT_FILENAME);
        try {
            System.out.println("Writing to: " + outputFile.getAbsolutePath());
            FileWriter writer = new FileWriter(outputFile);
            writer.write(html);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeToDisk(String content, String filePath) {
        File outputFile = new File(filePath);
        try {
            System.out.println("Writing to: " + outputFile.getAbsolutePath());
            FileWriter writer = new FileWriter(outputFile);
            writer.write(content);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String readFromFile(String path) {
        UniversalFile file = UniversalFileCreator.createFile(new File(path));
        if (!file.exists()) {
            System.err.println("File doesn't exist: " + path);
            return null;
        }
        return file.getFileAsString();
    }

    private static String md5(String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(text.getBytes("UTF-8"));
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < messageDigest.length; ++i) {
                hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static class Params {
        public final String overviewPath;
        public final String outputPath;
        public final String templatePath;
        private static final String PARAM_OVERVIEW_XML = "--overview=";
        private static final String PARAM_OUTPUT = "--output=";
        private static final String PARAM_TEMPLATE = "--template=";

        public Params(String overviewPath, String outputPath, String template) {
            this.overviewPath = overviewPath;
            this.outputPath = outputPath;
            this.templatePath = template;
        }

        public static Params parse(String[] args) {
            String overviewPath = "";
            String outputPath = "";
            String templatePath = "";
            for (String arg : args) {
                if (arg.startsWith(PARAM_OVERVIEW_XML)) {
                    overviewPath = arg.substring(PARAM_OVERVIEW_XML.length());
                }
                if (arg.startsWith(PARAM_OUTPUT)) {
                    outputPath = arg.substring(PARAM_OUTPUT.length());
                }
                if (!arg.startsWith(PARAM_TEMPLATE)) continue;
                templatePath = arg.substring(PARAM_TEMPLATE.length());
            }
            return new Params(overviewPath, outputPath, templatePath);
        }
    }
}

