/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.analytics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyAnalyzer {
    static final Map<String, Map<String, Set<String>>> sourceDataRaw = new HashMap<String, Map<String, Set<String>>>();
    static final Map<String, List<String>> sourceData = new HashMap<String, List<String>>();
    static final Map<String, Set<String>> result = new HashMap<String, Set<String>>();
    static final Map<String, Integer> outgoingIndex = new HashMap<String, Integer>();

    public static void main(String[] args) {
        DependencyAnalyzer.addTestData("A", "K1");
        DependencyAnalyzer.addTestData("K1", "Foo", "K2");
        DependencyAnalyzer.addTestData("K2", "K3");
        DependencyAnalyzer.addTestData("K3", "K4");
        DependencyAnalyzer.addTestData("K4", "E", "K1");
        DependencyAnalyzer.addTestData("E", "E1", "E2", "E3");
        DependencyAnalyzer.prepareSourceData();
        for (String className : sourceData.keySet()) {
            System.out.println(">> " + className);
            DependencyAnalyzer.calculate(className, new HashSet<String>());
        }
        DependencyAnalyzer.printResult();
    }

    public static void calculate(String className, Set<String> addDepsTo) {
        int nextIndex;
        HashSet<String> origAddDepsToSet = new HashSet<String>(addDepsTo);
        List<String> dependencies = sourceData.get(className);
        if (dependencies == null || dependencies.size() == 0) {
            return;
        }
        DependencyAnalyzer.addTo(className, dependencies);
        addDepsTo.add(className);
        while ((nextIndex = DependencyAnalyzer.getNextOutgoingIndexFor(className)) < dependencies.size()) {
            DependencyAnalyzer.calculate(dependencies.get(nextIndex), addDepsTo);
        }
        for (String addTo : origAddDepsToSet) {
            DependencyAnalyzer.addTo(addTo, (Collection<String>)result.get(className));
        }
    }

    public static int getNextOutgoingIndexFor(String className) {
        if (!outgoingIndex.containsKey(className)) {
            outgoingIndex.put(className, -1);
        }
        outgoingIndex.put(className, outgoingIndex.get(className) + 1);
        return outgoingIndex.get(className);
    }

    public static void addTo(String className, Collection<String> deps) {
        if (!result.containsKey(className)) {
            result.put(className, new HashSet());
        }
        result.get(className).addAll(deps);
    }

    private static void prepareSourceData() {
        for (String className : sourceDataRaw.keySet()) {
            HashSet deps = new HashSet();
            if (sourceDataRaw.containsKey(className)) {
                Map<String, Set<String>> methods = sourceDataRaw.get(className);
                for (String key : methods.keySet()) {
                    deps.addAll(methods.get(key));
                }
            }
            ArrayList depsList = new ArrayList(deps);
            sourceData.put(className, depsList);
        }
    }

    private static void printResult() {
        for (String className : result.keySet()) {
            System.out.println("Class: " + className);
            for (String dependency : result.get(className)) {
                System.out.println("  --> " + dependency);
            }
        }
    }

    private static void addTestData(String className, String ... deps) {
        HashMap methodMap = new HashMap();
        HashSet<String> depsSet = new HashSet<String>();
        depsSet.addAll(Arrays.asList(deps));
        methodMap.put("", depsSet);
        sourceDataRaw.put(className, methodMap);
    }
}

