/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.analytics;

import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.rop.type.TypeList;
import org.xmlvm.util.analytics.data.TypeHierarchy;
import org.xmlvm.util.analytics.data.Util;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;
import org.xmlvm.util.universalfile.UniversalFileFilter;

public class HierarchyAnalyzer {
    private final String libraryPath;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Invalid usage.\nExpected: HierarchyAnalyer <filename.jar|directory>");
            System.exit(-1);
        }
        HierarchyAnalyzer analyzer = new HierarchyAnalyzer(args[0]);
        TypeHierarchy hierarchy = analyzer.analyze();
        System.out.println("Type hierarchy:");
        System.out.println(hierarchy.toString());
    }

    public HierarchyAnalyzer(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    public TypeHierarchy analyze() {
        UniversalFile library = UniversalFileCreator.createDirectory(null, this.libraryPath);
        UniversalFile[] classes = library.listFilesRecursively(new UniversalFileFilter(){

            @Override
            public boolean accept(UniversalFile file) {
                return file.getName().toLowerCase().endsWith(".class");
            }
        });
        System.out.println("Getting type hierarchy for " + classes.length + " classes.");
        TypeHierarchy result = new TypeHierarchy();
        String basePath = library.getAbsolutePath();
        for (UniversalFile clazz : classes) {
            TypeList interfaces;
            String fileName = clazz.getRelativePath(basePath).replace('\\', '.');
            DirectClassFile classFile = new DirectClassFile(clazz.getFileAsBytes(), fileName, false);
            classFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
            try {
                classFile.getMagic();
            }
            catch (ParseException ex) {
                continue;
            }
            int DOT_CLASS_LENGTH = ".class".length();
            String className = fileName.substring(0, fileName.length() - DOT_CLASS_LENGTH).replace('/', '.');
            if (classFile.getSuperclass() != null) {
                String superClassName = Util.parseClassName(classFile.getSuperclass().getClassType().getClassName()).toString();
                result.addDirectSubType(className, superClassName);
            }
            if ((interfaces = classFile.getInterfaces()) == null) continue;
            for (int i = 0; i < interfaces.size(); ++i) {
                String interfaceName = Util.parseClassName(interfaces.getType(i).getClassName()).toString();
                result.addDirectSubType(className, interfaceName);
            }
        }
        return result;
    }
}

