/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.analytics.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Dependencies
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, ClassDeps> data = new HashMap<String, ClassDeps>();

    public ClassDeps getDepsForClass(String className) {
        if ((className = Dependencies.checkType(className)) == null) {
            return null;
        }
        if (this.data.containsKey(className)) {
            return this.data.get(className);
        }
        ClassDeps deps = new ClassDeps(className);
        this.data.put(className, deps);
        return deps;
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public int size() {
        return this.data.size();
    }

    public Set<String> getAllDepsForClass(String className) {
        return this.getDepsForClass(className).getAllDeps();
    }

    private static String checkType(String type) {
        if (type.contains(".")) {
            int arrayDefStart = type.indexOf(91);
            if (arrayDefStart != -1) {
                type = type.substring(0, arrayDefStart);
            }
            return type.replace('/', '.');
        }
        return null;
    }

    public static class MethodDeps
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, Set<String>> data = new HashMap<String, Set<String>>();

        public void addDependency(String className, String method) {
            Set<Object> methods;
            if ((className = Dependencies.checkType(className)) == null) {
                return;
            }
            if (!this.data.containsKey(className)) {
                methods = new HashSet();
                this.data.put(className, methods);
            } else {
                methods = this.data.get(className);
            }
            methods.add(method);
        }

        public Set<String> classSet() {
            return this.data.keySet();
        }

        public Set<String> getMethods(String className) {
            return this.data.get(className);
        }
    }

    public static class ClassDeps
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, MethodDeps> data = new HashMap<String, MethodDeps>();
        private String className;

        public ClassDeps(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public Set<String> methodSet() {
            return this.data.keySet();
        }

        public MethodDeps getMethodDeps(String method) {
            if (!this.data.containsKey(method)) {
                MethodDeps deps = new MethodDeps();
                this.data.put(method, deps);
                return deps;
            }
            return this.data.get(method);
        }

        public Set<String> getAllDeps() {
            HashSet<String> result = new HashSet<String>();
            for (MethodDeps methodDeps : this.data.values()) {
                result.addAll(methodDeps.classSet());
            }
            return result;
        }
    }
}

