/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.analytics.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeHierarchy {
    private Map<String, Set<String>> directSubTypes = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> directSuperTypes = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> subTypes = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> superTypes = new HashMap<String, Set<String>>();
    private boolean refreshNeeded = true;

    public void addDirectSubType(String subType, String superType) {
        this.refreshNeeded = true;
        if (!this.directSubTypes.containsKey(superType)) {
            this.directSubTypes.put(superType, new HashSet());
        }
        this.directSubTypes.get(superType).add(subType);
        if (!this.directSuperTypes.containsKey(subType)) {
            this.directSuperTypes.put(subType, new HashSet());
        }
        this.directSuperTypes.get(subType).add(superType);
    }

    public Set<String> getDirectSubTypes(String superType) {
        return this.directSubTypes.get(superType);
    }

    public boolean isSubTypeOf(String subType, String superType) {
        this.refreshIfNeeded();
        if (!this.subTypes.containsKey(superType)) {
            return false;
        }
        return this.subTypes.get(superType).contains(subType);
    }

    public boolean isSuperTypeOf(String superType, String subType) {
        this.refreshIfNeeded();
        if (!this.superTypes.containsKey(subType)) {
            return false;
        }
        return this.superTypes.get(subType).contains(superType);
    }

    private Set<String> getAllSuperTypes(String subType) {
        HashSet<String> result = new HashSet<String>();
        if (!this.directSuperTypes.containsKey(subType)) {
            return result;
        }
        for (String superType : this.directSuperTypes.get(subType)) {
            result.add(superType);
            result.addAll(this.getAllSuperTypes(superType));
        }
        return result;
    }

    private Set<String> getAllSubTypes(String superType) {
        HashSet<String> result = new HashSet<String>();
        if (!this.directSubTypes.containsKey(superType)) {
            return result;
        }
        for (String subType : this.directSubTypes.get(superType)) {
            result.add(subType);
            result.addAll(this.getAllSubTypes(subType));
        }
        return result;
    }

    private void calculateSubTypeMap() {
        this.subTypes.clear();
        for (String subType : this.directSuperTypes.keySet()) {
            for (String superType : this.directSuperTypes.get(subType)) {
                if (!this.subTypes.containsKey(superType)) {
                    this.subTypes.put(superType, new HashSet());
                }
                this.subTypes.get(superType).add(subType);
                for (String superSuperType : this.getAllSuperTypes(superType)) {
                    if (!this.subTypes.containsKey(superSuperType)) {
                        this.subTypes.put(superSuperType, new HashSet());
                    }
                    this.subTypes.get(superSuperType).add(subType);
                }
            }
        }
    }

    private void calculateSuperTypeMap() {
        this.superTypes.clear();
        for (String superType : this.directSubTypes.keySet()) {
            for (String subType : this.directSubTypes.get(superType)) {
                if (!this.superTypes.containsKey(subType)) {
                    this.superTypes.put(subType, new HashSet());
                }
                this.superTypes.get(subType).add(superType);
                for (String subSubType : this.getAllSubTypes(subType)) {
                    if (!this.superTypes.containsKey(subSubType)) {
                        this.superTypes.put(subSubType, new HashSet());
                    }
                    this.superTypes.get(subSubType).add(superType);
                }
            }
        }
    }

    private void refreshIfNeeded() {
        if (this.refreshNeeded) {
            this.calculateSubTypeMap();
            this.calculateSuperTypeMap();
        }
        this.refreshNeeded = false;
    }

    public String toString() {
        this.refreshIfNeeded();
        StringBuilder output = new StringBuilder();
        output.append("*****************************************\n");
        output.append("Super-Type -> direct & indirect sub-types\n");
        output.append("*****************************************\n");
        for (String superType : this.subTypes.keySet()) {
            output.append("--> " + superType + "\n");
            for (String subType : this.subTypes.get(superType)) {
                output.append("   |- " + subType + "\n");
            }
        }
        output.append("*****************************************\n");
        output.append("Sub-Type -> direct & indirect super-types\n");
        output.append("*****************************************\n");
        for (String subType : this.superTypes.keySet()) {
            output.append("--> " + subType + "\n");
            for (String superType : this.superTypes.get(subType)) {
                output.append("   |- " + superType + "\n");
            }
        }
        return output.toString();
    }
}

