/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.skeleton;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;

public class ClassSkeleton {
    private static final String COPYRIGHT = "/*\n * Copyright (c) 2002-2011 by XMLVM.org\n *\n * Project Info:  http://www.xmlvm.org\n *\n * This program is free software; you can redistribute it and/or modify it\n * under the terms of the GNU Lesser General Public License as published by\n * the Free Software Foundation; either version 2.1 of the License, or\n * (at your option) any later version.\n *\n * This library is distributed in the hope that it will be useful, but\n * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY\n * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public\n * License for more details.\n *\n * You should have received a copy of the GNU Lesser General Public\n * License along with this library; if not, write to the Free Software\n * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,\n * USA.\n */\n\n";
    private static final String LINE = "// ----------------------------------------------------------------------------\n";
    private static final String INIT = "__init_";
    private static final char DOT = '_';
    private static final String PARAM = "___";
    private StringBuilder hfile;
    private StringBuilder mfile;
    private StringBuilder test;
    private final Class c;

    public ClassSkeleton(Class c) {
        this.c = c;
        this.hfile = new StringBuilder();
        this.mfile = new StringBuilder();
        this.test = new StringBuilder();
        String jclass = c.getName();
        String classname = this.fixName(jclass);
        String shortname = this.getShort();
        this.hfile.append(COPYRIGHT);
        this.hfile.append("// ").append(shortname).append('\n');
        this.hfile.append(LINE);
        this.hfile.append("typedef ").append(shortname).append(' ').append(classname).append(";\n\n");
        this.hfile.append("@interface ").append(shortname).append(" (cat_").append(classname).append(");\n");
        this.mfile.append(COPYRIGHT);
        this.mfile.append("#import \"").append(classname).append(".h\"\n\n");
        this.mfile.append("// ").append(shortname).append('\n');
        this.mfile.append(LINE);
        this.mfile.append("@implementation ").append(shortname).append(" (cat_").append(classname).append(");\n\n");
        for (Constructor<?> constructor : c.getConstructors()) {
            this.buildMethod(INIT + classname, constructor.getParameterTypes(), null, c.getModifiers());
        }
        for (Executable executable : c.getMethods()) {
            if (!((Method)executable).getDeclaringClass().getName().equals(jclass)) continue;
            this.buildMethod(((Method)executable).getName(), ((Method)executable).getParameterTypes(), ((Method)executable).getReturnType(), ((Method)executable).getModifiers());
        }
        this.hfile.append("@end\n");
        this.mfile.append("@end\n");
        this.storeBuffer("out/" + classname + ".h", this.hfile);
        this.storeBuffer("out/" + classname + ".m", this.mfile);
    }

    private void buildMethod(String method, Class[] parameters, Class returntype, int type) {
        if ((type & 1) == 0) {
            return;
        }
        String decl = this.getMethodDecleration(method, parameters, returntype, type);
        this.hfile.append(decl).append(";\n");
        this.mfile.append(decl).append("\n{\n  // TODO: implement code\n}\n\n");
    }

    private String getMethodDecleration(String method, Class[] parameters, Class returntype, int type) {
        StringBuilder name = new StringBuilder();
        StringBuilder params = new StringBuilder();
        name.append((type & 8) == 0 ? "- (" : "+ (");
        name.append(this.getTypeRef(returntype)).append(") ");
        name.append(this.fixName(method));
        for (int i = 0; i < parameters.length; ++i) {
            Class cc = parameters[i];
            String pname = this.fixName(cc.getName());
            name.append(PARAM).append(pname);
            params.append(" :").append("(").append(this.getTypeRef(cc)).append(")").append("a").append(i + 1);
        }
        name.append((CharSequence)params);
        return name.toString();
    }

    private String getTypeRef(Class type) {
        if (type == null) {
            return "void";
        }
        if (type.isPrimitive()) {
            return type.toString();
        }
        return this.fixName(type.getName()) + "*";
    }

    private String fixName(String oldname) {
        return oldname.replace('.', '_');
    }

    private String getShort() {
        String classname = this.c.getName();
        int lastdot = classname.lastIndexOf(46);
        return classname.substring(lastdot + 1, classname.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeBuffer(String filename, StringBuilder buffer) {
        FileWriter out = null;
        try {
            out = new FileWriter(filename);
            out.append(buffer);
            out.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {}
        }
        return false;
    }
}

