/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.universalfile;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.xmlvm.util.universalfile.UniversalFile;

public class UniversalFileDirectory
extends UniversalFile {
    private String absoluteName;
    private List<UniversalFile> files = new ArrayList<UniversalFile>();
    private long lastModified;

    UniversalFileDirectory(String absoluteName, long lastModified) {
        this.absoluteName = absoluteName;
        this.lastModified = lastModified;
    }

    @Override
    public String getAbsolutePath() {
        return this.absoluteName;
    }

    @Override
    public byte[] getFileAsBytes() {
        return null;
    }

    @Override
    public String getFileAsString() {
        return null;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public UniversalFile[] listFiles() {
        return this.files.toArray(new UniversalFile[0]);
    }

    public void add(UniversalFile file) {
        this.files.add(file);
        this.lastModified = System.currentTimeMillis();
    }

    public UniversalFileDirectory getDirectory(String name) {
        for (UniversalFile file : this.files) {
            if (!file.isDirectory() || !file.getAbsolutePath().endsWith(File.separator + name)) continue;
            return (UniversalFileDirectory)file;
        }
        return null;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }
}

