/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.universalfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.xmlvm.Log;
import org.xmlvm.util.FileUtil;
import org.xmlvm.util.universalfile.UniversalFile;

public class UniversalFileFromFileSystemFile
extends UniversalFile {
    private File file;

    UniversalFileFromFileSystemFile(File file) {
        this.file = file;
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public byte[] getFileAsBytes() {
        return UniversalFileFromFileSystemFile.readFileAsBytes(this.file);
    }

    @Override
    public String getFileAsString() {
        return UniversalFileFromFileSystemFile.readFileAsString(this.file);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public UniversalFile[] listFiles() {
        return new UniversalFile[0];
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    public static byte[] readFileAsBytes(File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            byte[] fromStream = FileUtil.readBytesFromStream(stream);
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return fromStream;
        }
        catch (FileNotFoundException e) {
            Log.error("Could not read file: " + file.getAbsolutePath() + " ( " + e.getMessage() + " )");
            return new byte[0];
        }
    }

    public static String readFileAsString(File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            String fromStream = FileUtil.readStringFromStream(stream);
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return fromStream;
        }
        catch (FileNotFoundException e) {
            Log.error("Could not read file: " + file.getAbsolutePath() + " ( " + e.getMessage() + " )");
            return "";
        }
    }
}

