/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.LogisticsAddressReachablebatchGetResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogisticsAddressReachablebatchGetRequest
extends BaseTaobaoRequest<LogisticsAddressReachablebatchGetResponse> {
    private String addressList;

    public void setAddressList(String addressList) {
        this.addressList = addressList;
    }

    public void setAddressList(List<AddressReachable> addressList) {
        this.addressList = new JSONWriter(false, true).write(addressList);
    }

    public String getAddressList() {
        return this.addressList;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.logistics.address.reachablebatch.get";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("address_list", this.addressList);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<LogisticsAddressReachablebatchGetResponse> getResponseClass() {
        return LogisticsAddressReachablebatchGetResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkObjectMaxListSize(this.addressList, 20, "addressList");
    }

    public static class AddressReachable
    extends TaobaoObject {
        private static final long serialVersionUID = 7652778277319176666L;
        @ApiField(value="address")
        private String address;
        @ApiField(value="area_code")
        private String areaCode;
        @ApiField(value="partner_id")
        private String partnerId;
        @ApiField(value="service_type")
        private Long serviceType;
        @ApiField(value="source_area_code")
        private String sourceAreaCode;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getAreaCode() {
            return this.areaCode;
        }

        public void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        public String getPartnerId() {
            return this.partnerId;
        }

        public void setPartnerId(String partnerId) {
            this.partnerId = partnerId;
        }

        public Long getServiceType() {
            return this.serviceType;
        }

        public void setServiceType(Long serviceType) {
            this.serviceType = serviceType;
        }

        public String getSourceAreaCode() {
            return this.sourceAreaCode;
        }

        public void setSourceAreaCode(String sourceAreaCode) {
            this.sourceAreaCode = sourceAreaCode;
        }
    }
}

