/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.RegionPriceQueryResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionPriceQueryRequest
extends BaseTaobaoRequest<RegionPriceQueryResponse> {
    private Long itemId;
    private String regionalPriceDtos;
    private Long skuId;

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setRegionalPriceDtos(String regionalPriceDtos) {
        this.regionalPriceDtos = regionalPriceDtos;
    }

    public void setRegionalPriceDtos(List<RegionalPriceDto> regionalPriceDtos) {
        this.regionalPriceDtos = new JSONWriter(false, true).write(regionalPriceDtos);
    }

    public String getRegionalPriceDtos() {
        return this.regionalPriceDtos;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSkuId() {
        return this.skuId;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.region.price.query";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("item_id", (Object)this.itemId);
        txtParams.put("regional_price_dtos", this.regionalPriceDtos);
        txtParams.put("sku_id", (Object)this.skuId);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<RegionPriceQueryResponse> getResponseClass() {
        return RegionPriceQueryResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.itemId, "itemId");
        RequestCheckUtils.checkObjectMaxListSize(this.regionalPriceDtos, 20, "regionalPriceDtos");
    }

    public static class RegionalPriceDto
    extends TaobaoObject {
        private static final long serialVersionUID = 6231546619565167228L;
        @ApiField(value="city")
        private String city;
        @ApiField(value="district")
        private String district;
        @ApiField(value="province")
        private String province;
        @ApiField(value="street")
        private String street;

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getDistrict() {
            return this.district;
        }

        public void setDistrict(String district) {
            this.district = district;
        }

        public String getProvince() {
            return this.province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getStreet() {
            return this.street;
        }

        public void setStreet(String street) {
            this.street = street;
        }
    }
}

