/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallItemDapeiTemplateUpdateResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TmallItemDapeiTemplateUpdateRequest
extends BaseTaobaoRequest<TmallItemDapeiTemplateUpdateResponse> {
    private String desc;
    private Long id;
    private String items;
    private String title;
    private String url;

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public void setItems(List<DapeiItem> items) {
        this.items = new JSONWriter(false, true).write(items);
    }

    public String getItems() {
        return this.items;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public String getApiMethodName() {
        return "tmall.item.dapei.template.update";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("desc", this.desc);
        txtParams.put("id", (Object)this.id);
        txtParams.put("items", this.items);
        txtParams.put("title", this.title);
        txtParams.put("url", this.url);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<TmallItemDapeiTemplateUpdateResponse> getResponseClass() {
        return TmallItemDapeiTemplateUpdateResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.desc, "desc");
        RequestCheckUtils.checkNotEmpty(this.id, "id");
        RequestCheckUtils.checkObjectMaxListSize(this.items, 20, "items");
        RequestCheckUtils.checkNotEmpty(this.title, "title");
        RequestCheckUtils.checkNotEmpty(this.url, "url");
    }

    public static class DapeiItem
    extends TaobaoObject {
        private static final long serialVersionUID = 2158198973496149237L;
        @ApiField(value="img")
        private String img;
        @ApiField(value="item_id")
        private Long itemId;

        public String getImg() {
            return this.img;
        }

        public void setImg(String img) {
            this.img = img;
        }

        public Long getItemId() {
            return this.itemId;
        }

        public void setItemId(Long itemId) {
            this.itemId = itemId;
        }
    }
}

