/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.WlbWmsItemCombinationCreateResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WlbWmsItemCombinationCreateRequest
extends BaseTaobaoRequest<WlbWmsItemCombinationCreateResponse> {
    private Long itemId;
    private String subItemList;

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setSubItemList(String subItemList) {
        this.subItemList = subItemList;
    }

    public void setSubItemList(List<SubItemList> subItemList) {
        this.subItemList = new JSONWriter(false, true).write(subItemList);
    }

    public String getSubItemList() {
        return this.subItemList;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.wlb.wms.item.combination.create";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("item_id", (Object)this.itemId);
        txtParams.put("sub_item_list", this.subItemList);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<WlbWmsItemCombinationCreateResponse> getResponseClass() {
        return WlbWmsItemCombinationCreateResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.itemId, "itemId");
        RequestCheckUtils.checkObjectMaxListSize(this.subItemList, 20, "subItemList");
    }

    public static class SubItemList
    extends TaobaoObject {
        private static final long serialVersionUID = 3768237358637363244L;
        @ApiField(value="sub_item")
        private SubItem subItem;

        public SubItem getSubItem() {
            return this.subItem;
        }

        public void setSubItem(SubItem subItem) {
            this.subItem = subItem;
        }
    }

    public static class SubItem
    extends TaobaoObject {
        private static final long serialVersionUID = 6365315813365649215L;
        @ApiField(value="count")
        private Long count;
        @ApiField(value="sub_item_id")
        private Long subItemId;

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public Long getSubItemId() {
            return this.subItemId;
        }

        public void setSubItemId(Long subItemId) {
            this.subItemId = subItemId;
        }
    }
}

