/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.internal.asm.ASMUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class ConstructorFunction<T>
implements Function<Map<Long, Object>, T> {
    final Constructor constructor;
    final Parameter[] parameters;
    final String[] paramNames;
    final long[] hashCodes;
    final List<Constructor> alternateConstructors;
    Map<Set<Long>, Constructor> alternateConstructorMap;
    Map<Set<Long>, String[]> alternateConstructorNames;
    Map<Set<Long>, long[]> alternateConstructorNameHashCodes;
    Map<Set<Long>, Type[]> alternateConstructorArgTypes;

    ConstructorFunction(Constructor constructor, String ... paramNames) {
        this(null, constructor, paramNames);
    }

    ConstructorFunction(List<Constructor> alternateConstructors, Constructor constructor, String ... paramNames) {
        this.constructor = constructor;
        this.parameters = constructor.getParameters();
        this.paramNames = paramNames;
        this.hashCodes = new long[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            String name = i < paramNames.length ? paramNames[i] : this.parameters[i].getName();
            this.hashCodes[i] = Fnv.hashCode64(name);
        }
        this.alternateConstructors = alternateConstructors;
        if (alternateConstructors != null) {
            this.alternateConstructorMap = new HashMap<Set<Long>, Constructor>(alternateConstructors.size());
            this.alternateConstructorNames = new HashMap<Set<Long>, String[]>(alternateConstructors.size());
            this.alternateConstructorArgTypes = new HashMap<Set<Long>, Type[]>(alternateConstructors.size());
            this.alternateConstructorNameHashCodes = new HashMap<Set<Long>, long[]>(alternateConstructors.size());
            for (Constructor alternateConstructor : alternateConstructors) {
                alternateConstructor.setAccessible(true);
                String[] parameterNames = ASMUtils.lookupParameterNames(alternateConstructor);
                long[] parameterNameHashCodes = new long[parameterNames.length];
                Type[] parameterTypes = alternateConstructor.getGenericParameterTypes();
                HashSet<Long> paramHashCodes = new HashSet<Long>(parameterNames.length);
                for (int i = 0; i < parameterNames.length; ++i) {
                    long hashCode64;
                    parameterNameHashCodes[i] = hashCode64 = Fnv.hashCode64(parameterNames[i]);
                    paramHashCodes.add(hashCode64);
                }
                this.alternateConstructorMap.put(paramHashCodes, alternateConstructor);
                this.alternateConstructorNames.put(paramHashCodes, parameterNames);
                this.alternateConstructorNameHashCodes.put(paramHashCodes, parameterNameHashCodes);
                this.alternateConstructorArgTypes.put(paramHashCodes, parameterTypes);
            }
        }
    }

    @Override
    public T apply(Map<Long, Object> values2) {
        Set<Long> key;
        Constructor constructor;
        boolean containsAll = true;
        for (long hashCode : this.hashCodes) {
            if (values2.containsKey(hashCode)) continue;
            containsAll = false;
            break;
        }
        if (!containsAll && this.alternateConstructorMap != null && (constructor = this.alternateConstructorMap.get(key = values2.keySet())) != null) {
            long[] hashCodes = this.alternateConstructorNameHashCodes.get(key);
            Type[] paramTypes = this.alternateConstructorArgTypes.get(key);
            Object[] args2 = new Object[hashCodes.length];
            for (int i = 0; i < hashCodes.length; ++i) {
                Object arg = values2.get(hashCodes[i]);
                Type paramType = paramTypes[i];
                if (arg == null) {
                    arg = TypeUtils.getDefaultValue(paramType);
                }
                args2[i] = arg;
            }
            try {
                return constructor.newInstance(args2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new JSONException("invoke constructor error, " + constructor, e);
            }
        }
        Object[] args3 = new Object[this.parameters.length];
        for (int i = 0; i < args3.length; ++i) {
            Class<?> paramType = this.parameters[i].getType();
            Object arg = values2.get(this.hashCodes[i]);
            if (arg == null) {
                arg = TypeUtils.getDefaultValue(paramType);
            }
            args3[i] = arg;
        }
        try {
            return this.constructor.newInstance(args3);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new JSONException("invoke constructor error, " + this.constructor, e);
        }
    }
}

