/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.function.Function;

class FactoryFunction<T>
implements Function<Map<Long, Object>, T> {
    final Method factoryMethod;
    final String[] paramNames;
    final long[] hashCodes;

    FactoryFunction(Method factoryMethod, String ... paramNames) {
        this.factoryMethod = factoryMethod;
        Parameter[] parameters = factoryMethod.getParameters();
        this.paramNames = new String[parameters.length];
        this.hashCodes = new long[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String name = i < paramNames.length ? paramNames[i] : parameters[i].getName();
            paramNames[i] = name;
            this.hashCodes[i] = Fnv.hashCode64(name);
        }
    }

    @Override
    public T apply(Map<Long, Object> values2) {
        Object[] args2 = new Object[this.hashCodes.length];
        for (int i = 0; i < args2.length; ++i) {
            args2[i] = values2.get(this.hashCodes[i]);
        }
        try {
            return (T)this.factoryMethod.invoke(null, args2);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke factoryMethod error", e);
        }
    }
}

