/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectMethod;
import com.alibaba.fastjson2.reader.FieldReaderReadOnly;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

class FieldReaderCollectionMethodReadOnly<T>
extends FieldReaderObjectMethod<T>
implements FieldReaderReadOnly<T> {
    private final Type itemType;
    private ObjectReader itemReader;

    FieldReaderCollectionMethodReadOnly(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, JSONSchema schema, Method setter) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, null, null, schema, setter);
        Type[] actualTypeArguments;
        Type itemType = null;
        if (fieldType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)fieldType).getActualTypeArguments()).length > 0) {
            itemType = actualTypeArguments[0];
        }
        this.itemType = itemType;
    }

    @Override
    public Type getItemType() {
        return this.itemType;
    }

    @Override
    public void accept(T object, Object value) {
        Collection collection;
        if (value == null) {
            return;
        }
        try {
            collection = (Collection)this.method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
        if (collection == Collections.EMPTY_LIST || collection == Collections.EMPTY_SET) {
            if (this.schema != null) {
                this.schema.assertValidate(collection);
            }
            return;
        }
        String name = collection.getClass().getName();
        if ("java.util.Collections$UnmodifiableRandomAccessList".equals(name) || "java.util.Collections$UnmodifiableRandomAccessList".equals(name)) {
            return;
        }
        if (value == collection) {
            return;
        }
        Type itemType = this.getItemType();
        Collection values2 = (Collection)value;
        for (Object item : values2) {
            if (item == null) {
                collection.add(item);
                continue;
            }
            if (item instanceof Map && itemType instanceof Class && !((Class)itemType).isAssignableFrom(item.getClass())) {
                if (this.itemReader == null) {
                    this.itemReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(itemType);
                }
                item = this.itemReader.createInstance((Map)item, 0L);
            }
            collection.add(item);
        }
        if (this.schema != null) {
            this.schema.assertValidate(collection);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        Object value = jsonReader.isJSONB() ? this.fieldObjectReader.readJSONBObject(jsonReader, 0L) : this.fieldObjectReader.readObject(jsonReader, 0L);
        this.accept(object, value);
    }
}

