/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public interface FieldReaderList<T, V>
extends FieldReader<T> {
    @Override
    default public Type getFieldType() {
        return List.class;
    }

    @Override
    default public Class getFieldClass() {
        return List.class;
    }

    @Override
    public Type getItemType();

    default public List<V> createList() {
        return new ArrayList();
    }

    @Override
    default public ObjectReader<V> getItemObjectReader(JSONReader.Context ctx) {
        return ctx.getObjectReader(this.getItemType());
    }

    @Override
    default public void readFieldValue(JSONReader jsonReader, T object) {
        if (jsonReader.isJSONB()) {
            int entryCnt = jsonReader.startArray();
            Object[] array = new Object[entryCnt];
            ObjectReader<V> itemObjectReader = this.getItemObjectReader(jsonReader.getContext());
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = itemObjectReader.readObject(jsonReader, 0L);
            }
            List<Object> list = Arrays.asList(array);
            this.accept(object, list);
            return;
        }
        if (jsonReader.current() == '[') {
            JSONReader.Context ctx = jsonReader.getContext();
            ObjectReader<V> itemObjectReader = this.getItemObjectReader(ctx);
            List<V> list = this.createList();
            jsonReader.next();
            while (!jsonReader.nextIfMatch(']')) {
                list.add(itemObjectReader.readObject(jsonReader, 0L));
                if (!jsonReader.nextIfMatch(',')) continue;
            }
            this.accept(object, list);
            jsonReader.nextIfMatch(',');
            return;
        }
        ObjectReader objectReader = this.getObjectReader(jsonReader);
        long features = this.getFeatures();
        Object value = jsonReader.isJSONB() ? objectReader.readJSONBObject(jsonReader, features) : objectReader.readObject(jsonReader, features);
        this.accept(object, value);
    }

    @Override
    default public Object readFieldValue(JSONReader jsonReader) {
        if (jsonReader.isJSONB()) {
            int entryCnt = jsonReader.startArray();
            Object[] array = new Object[entryCnt];
            ObjectReader<V> itemObjectReader = this.getItemObjectReader(jsonReader.getContext());
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = itemObjectReader.readObject(jsonReader, 0L);
            }
            return Arrays.asList(array);
        }
        if (jsonReader.current() == '[') {
            JSONReader.Context ctx = jsonReader.getContext();
            ObjectReader<V> itemObjectReader = this.getItemObjectReader(ctx);
            List<V> list = this.createList();
            jsonReader.next();
            while (!jsonReader.nextIfMatch(']')) {
                list.add(itemObjectReader.readObject(jsonReader, 0L));
                if (!jsonReader.nextIfMatch(',')) continue;
            }
            jsonReader.nextIfMatch(',');
            return list;
        }
        if (jsonReader.isString()) {
            Function typeConvert;
            String str = jsonReader.readString();
            Type itemType = this.getItemType();
            if (itemType instanceof Class && Number.class.isAssignableFrom((Class)itemType) && (typeConvert = jsonReader.getContext().getProvider().getTypeConvert((Type)((Object)String.class), itemType)) != null) {
                List<V> list = this.createList();
                if (str.indexOf(44) != -1) {
                    String[] items;
                    for (String item : items = str.split(",")) {
                        Object converted = typeConvert.apply(item);
                        list.add(converted);
                    }
                }
                return list;
            }
        }
        throw new JSONException("TODO : " + this.getClass());
    }
}

