/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterDate;
import java.lang.reflect.Field;

final class FieldWriterMillisField<T>
extends FieldWriterDate<T> {
    final Field field;

    FieldWriterMillisField(String fieldName, int ordinal, long features, String dateTimeFormat, Field method) {
        super(fieldName, ordinal, features, dateTimeFormat, Long.TYPE, Long.TYPE);
        this.field = method;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Object getFieldValue(T object) {
        return this.getFieldLong(object);
    }

    public long getFieldLong(T object) {
        try {
            return this.field.getLong(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        long millis = this.getFieldLong(object);
        this.writeDate(jsonWriter, millis);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        long millis = this.getFieldLong(object);
        this.writeDate(jsonWriter, false, millis);
    }
}

