/*
 * Decompiled with CFR 0.152.
 */
package com.xiaohongshu.fls.opensdk.client;

import com.alibaba.fastjson.JSON;
import com.xiaohongshu.fls.opensdk.client.BaseClient;
import com.xiaohongshu.fls.opensdk.entity.BaseResponse;
import com.xiaohongshu.fls.opensdk.entity.invoice.request.ConfirmInvoiceRequest;
import com.xiaohongshu.fls.opensdk.entity.invoice.request.GetInvoiceListRequest;
import com.xiaohongshu.fls.opensdk.entity.invoice.request.ReverseInvoiceRequest;
import com.xiaohongshu.fls.opensdk.entity.invoice.response.GetInvoiceListResponse;
import com.xiaohongshu.fls.opensdk.util.Utils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.MapUtils;

public class InvoiceClient
extends BaseClient {
    public InvoiceClient(String url, String appId, String version, String appSecret) {
        super(url, appId, version, appSecret);
    }

    public BaseResponse<GetInvoiceListResponse> execute(GetInvoiceListRequest request, String accessToken) throws IOException {
        BaseResponse<GetInvoiceListResponse> response = new BaseResponse<GetInvoiceListResponse>();
        request.setMethod("invoice.getInvoiceList");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString(request);
        RequestBody body = RequestBody.create(JSONTYPE, bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean(bodyMap, "success").booleanValue()) {
            GetInvoiceListResponse getInvoiceListResponse = JSON.parseObject(JSON.toJSONString(bodyMap.get("data")), GetInvoiceListResponse.class);
            response.setSuccessResponse(getInvoiceListResponse);
        } else {
            response.setFailResponse(Objects.toString(bodyMap.getOrDefault("error_msg", bodyMap.get("msg")), ""), Objects.toString(bodyMap.getOrDefault("error_code", bodyMap.get("code")), ""));
        }
        return response;
    }

    public BaseResponse<String> execute(ConfirmInvoiceRequest request, String accessToken) throws IOException {
        BaseResponse<String> response = new BaseResponse<String>();
        request.setMethod("invoice.confirmInvoice");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString(request);
        RequestBody body = RequestBody.create(JSONTYPE, bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean(bodyMap, "success").booleanValue()) {
            response.setSuccessResponse("\u4e0a\u4f20\u6210\u529f");
        } else {
            response.setFailResponse(Objects.toString(bodyMap.getOrDefault("error_msg", bodyMap.get("msg")), ""), Objects.toString(bodyMap.getOrDefault("error_code", bodyMap.get("code")), ""));
        }
        return response;
    }

    public BaseResponse<String> reverseInvoice(ReverseInvoiceRequest request, String accessToken) throws IOException {
        BaseResponse<String> response = new BaseResponse<String>();
        request.setMethod("invoice.reverseInvoice");
        request.addParameter(this, accessToken);
        String bodyString = JSON.toJSONString(request);
        RequestBody body = RequestBody.create(JSONTYPE, bodyString);
        Request httpRequest = new Request.Builder().url(this.url).post(body).build();
        Response openapiResponse = Utils.okHttpClient.newCall(httpRequest).execute();
        String responseBody = openapiResponse.body().string();
        Map bodyMap = Utils.objectFromJSONStr(responseBody, Map.class);
        if (MapUtils.getBoolean(bodyMap, "success").booleanValue()) {
            response.setSuccessResponse("\u51b2\u7ea2\u6210\u529f");
        } else {
            response.setFailResponse(Objects.toString(bodyMap.getOrDefault("error_msg", bodyMap.get("msg")), ""), Objects.toString(bodyMap.getOrDefault("error_code", bodyMap.get("code")), ""));
        }
        return response;
    }
}

