/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.property.provider;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.mangofactory.swagger.models.property.ModelProperty;
import com.mangofactory.swagger.models.property.bean.BeanModelPropertyProvider;
import com.mangofactory.swagger.models.property.constructor.ConstructorModelPropertyProvider;
import com.mangofactory.swagger.models.property.field.FieldModelPropertyProvider;
import com.mangofactory.swagger.models.property.provider.ModelPropertiesProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="default")
public class DefaultModelPropertiesProvider
implements ModelPropertiesProvider {
    private final FieldModelPropertyProvider fieldModelPropertyProvider;
    private final BeanModelPropertyProvider beanModelPropertyProvider;
    private final ConstructorModelPropertyProvider constructorModelPropertyProvider;

    @Autowired
    public DefaultModelPropertiesProvider(BeanModelPropertyProvider beanModelPropertyProvider, FieldModelPropertyProvider fieldModelPropertyProvider, ConstructorModelPropertyProvider constructorModelPropertyProvider) {
        this.beanModelPropertyProvider = beanModelPropertyProvider;
        this.fieldModelPropertyProvider = fieldModelPropertyProvider;
        this.constructorModelPropertyProvider = constructorModelPropertyProvider;
    }

    @Override
    public Iterable<? extends ModelProperty> propertiesForSerialization(ResolvedType type) {
        return Iterables.concat(this.fieldModelPropertyProvider.propertiesForSerialization(type), this.beanModelPropertyProvider.propertiesForSerialization(type), this.constructorModelPropertyProvider.propertiesForSerialization(type));
    }

    @Override
    public Iterable<? extends ModelProperty> propertiesForDeserialization(ResolvedType type) {
        return Iterables.concat(this.fieldModelPropertyProvider.propertiesForDeserialization(type), this.beanModelPropertyProvider.propertiesForDeserialization(type), this.constructorModelPropertyProvider.propertiesForDeserialization(type));
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.fieldModelPropertyProvider.setObjectMapper(objectMapper);
        this.beanModelPropertyProvider.setObjectMapper(objectMapper);
        this.constructorModelPropertyProvider.setObjectMapper(objectMapper);
    }
}

