/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client;

import com.sshtools.forker.client.EffectiveUser;
import com.sshtools.forker.client.Forker;
import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.client.OSCommand;
import com.sshtools.forker.client.impl.ForkerDaemonProcess;
import com.sshtools.forker.client.ui.AskPass;
import com.sshtools.forker.client.ui.AskPassConsole;
import com.sshtools.forker.client.ui.WinRunAs;
import com.sshtools.forker.common.CSystem;
import com.sshtools.forker.common.Command;
import com.sshtools.forker.common.IO;
import com.sshtools.forker.common.OS;
import com.sshtools.forker.common.Util;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;

public abstract class EffectiveUserFactory {
    private static EffectiveUserFactory instance;
    private static final Object lock;

    protected EffectiveUserFactory(boolean registerAsDefault) {
        if (registerAsDefault) {
            if (instance == null) {
                instance = this;
            } else {
                throw new IllegalStateException("Default already registered.");
            }
        }
    }

    public abstract EffectiveUser administrator();

    public abstract String getAppName();

    public abstract EffectiveUser getUserForUsername(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final EffectiveUserFactory getDefault() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                new DefaultEffectiveUserFactory();
            }
        }
        return instance;
    }

    static {
        lock = new Object();
    }

    static abstract class AbstractPOSIXEffectiveUser<T>
    extends AbstractProcessBuilderEffectiveUser {
        private boolean setRemote;
        private T value;
        private int was = Integer.MIN_VALUE;

        AbstractPOSIXEffectiveUser(T value) {
            this.value = value;
        }

        @Override
        public synchronized void descend(ForkerBuilder builder, Process process, Command command) {
            if (this.setRemote) {
                this.setRemote = false;
            } else {
                if (this.was == Integer.MIN_VALUE) {
                    throw new IllegalStateException();
                }
                this.seteuid(this.was);
                this.was = Integer.MIN_VALUE;
            }
        }

        @Override
        public void elevate(ForkerBuilder builder, Process process, Command command) {
            if (process instanceof ForkerDaemonProcess) {
                command.setRunAs(String.valueOf(this.value));
                this.setRemote = true;
            } else {
                if (this.was != Integer.MIN_VALUE) {
                    throw new IllegalStateException();
                }
                this.was = CSystem.INSTANCE.geteuid();
                this.doSet(this.value);
            }
        }

        public T getValue() {
            return this.value;
        }

        protected void seteuid(int euid) {
            if (CSystem.INSTANCE.seteuid(euid) == -1) {
                throw new RuntimeException("Failed to set EUID.");
            }
        }

        abstract void doSet(T var1);
    }

    public static class SUUser
    extends AbstractProcessBuilderEffectiveUser
    implements EffectiveUser {
        private List<String> original;
        private String username;

        public SUUser(String username) {
            this.username = username;
        }

        @Override
        public void descend(ForkerBuilder builder, Process process, Command command) {
            builder.command().clear();
            builder.command().addAll(this.original);
        }

        @Override
        public void elevate(ForkerBuilder builder, Process process, Command command) {
            this.original = new ArrayList<String>(builder.command());
            if (OSCommand.hasCommand("sudo")) {
                builder.command().add(0, "sudo");
                builder.command().add(1, "-u");
                builder.command().add(2, this.username);
            } else {
                if (System.console() == null) {
                    throw new IllegalStateException("This program wants to switch users, but sudo is not available, and the fallback 'su' is not capable of running without a controlling terminal.");
                }
                List<String> cmd = builder.command();
                StringBuilder bui = Util.getQuotedCommandString(cmd);
                cmd.clear();
                cmd.add("su");
                cmd.add("-c");
                cmd.add(bui.toString());
                cmd.add(this.username);
            }
        }
    }

    public static class SudoGksudoUser
    extends AbstractProcessBuilderEffectiveUser
    implements EffectiveUser {
        private String username;

        public SudoGksudoUser() {
        }

        public SudoGksudoUser(String username) {
            this.username = username;
        }

        @Override
        public void descend(ForkerBuilder builder, Process process, Command command) {
            builder.command().remove(0);
            builder.command().remove(0);
            builder.command().remove(0);
            if (this.username != null) {
                builder.command().remove(0);
                builder.command().remove(0);
            }
            builder.environment().remove("SUDO_ASKPASS");
        }

        @Override
        public void elevate(ForkerBuilder builder, Process process, Command command) {
            this.createTempScript(String.format("gksudo --description=\"%s\" --print-pass", EffectiveUserFactory.getDefault().getAppName()));
            builder.command().add(0, "sudo");
            builder.command().add(1, "-A");
            builder.command().add(2, "-E");
            if (this.username != null) {
                builder.command().add(3, "-u");
                builder.command().add(4, this.username);
            }
            builder.environment().put("SUDO_ASKPASS", this.tempScript.getAbsolutePath());
        }
    }

    public static class SudoFixedPasswordUser
    extends AbstractProcessBuilderEffectiveUser
    implements EffectiveUser {
        private char[] password;
        private String username;

        public SudoFixedPasswordUser(char[] password) {
            this(null, password);
        }

        public SudoFixedPasswordUser(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void descend(ForkerBuilder builder, Process process, Command command) {
            builder.command().remove(0);
            builder.command().remove(0);
            if (this.username != null) {
                builder.command().remove(0);
                builder.command().remove(0);
            }
            builder.environment().remove("SUDO_ASKPASS");
        }

        @Override
        public void elevate(ForkerBuilder builder, Process process, Command command) {
            this.createTempScript("echo '" + new String(this.password).replace("'", "\\'") + "'");
            builder.command().add(0, "sudo");
            builder.command().add(1, "-A");
            if (this.username != null) {
                builder.command().add(2, "-u");
                builder.command().add(3, this.username);
            }
            builder.environment().put("SUDO_ASKPASS", this.tempScript.getAbsolutePath());
        }
    }

    public static class SudoAskPassUser
    extends AbstractProcessBuilderEffectiveUser
    implements EffectiveUser {
        private String username;

        public SudoAskPassUser() {
        }

        public SudoAskPassUser(String username) {
            this();
            this.username = username;
        }

        @Override
        public void descend(ForkerBuilder builder, Process process, Command command) {
            builder.command().remove(0);
            builder.command().remove(0);
            builder.command().remove(0);
            if (this.username != null) {
                builder.command().remove(0);
                builder.command().remove(0);
            }
            builder.environment().remove("SUDO_ASKPASS");
        }

        @Override
        public void elevate(ForkerBuilder builder, Process process, Command command) {
            this.createTempScript(this.javaAskPassScript(AskPassConsole.class));
            builder.command().add(0, "sudo");
            builder.command().add(1, "-A");
            builder.command().add(2, "-E");
            if (this.username != null) {
                builder.command().add(3, "-u");
                builder.command().add(4, this.username);
            }
            builder.environment().put("SUDO_ASKPASS", this.tempScript.getAbsolutePath());
        }
    }

    public static class SudoAskPassGuiUser
    extends AbstractProcessBuilderEffectiveUser
    implements EffectiveUser {
        private String username;

        public SudoAskPassGuiUser() {
        }

        public SudoAskPassGuiUser(String username) {
            this();
            this.username = username;
        }

        @Override
        public void descend(ForkerBuilder builder, Process process, Command command) {
            builder.command().remove(0);
            builder.command().remove(0);
            builder.command().remove(0);
            if (this.username != null) {
                builder.command().remove(0);
                builder.command().remove(0);
            }
            builder.environment().remove("SUDO_ASKPASS");
        }

        @Override
        public void elevate(ForkerBuilder builder, Process process, Command command) {
            this.createTempScript(this.javaAskPassScript(AskPass.class));
            builder.command().add(0, "sudo");
            builder.command().add(1, "-A");
            builder.command().add(2, "-E");
            if (this.username != null) {
                builder.command().add(3, "-u");
                builder.command().add(4, this.username);
            }
            builder.environment().put("SUDO_ASKPASS", this.tempScript.getAbsolutePath());
        }
    }

    public static class SUAdministrator
    extends AbstractProcessBuilderEffectiveUser
    implements EffectiveUser {
        private ArrayList<String> original;

        @Override
        public void descend(ForkerBuilder builder, Process process, Command command) {
            builder.command().clear();
            builder.command().addAll(this.original);
        }

        @Override
        public void elevate(ForkerBuilder builder, Process process, Command command) {
            this.original = new ArrayList<String>(builder.command());
            if (OSCommand.hasCommand("sudo")) {
                builder.command().add(0, "sudo");
            } else {
                if (System.console() == null) {
                    throw new IllegalStateException("This program requires elevated privileges, but sudo is not available, and the fallback 'su' is not capable of running without a controlling terminal.");
                }
                List<String> cmd = builder.command();
                StringBuilder bui = Util.getQuotedCommandString(cmd);
                cmd.clear();
                cmd.add("su");
                cmd.add("-c");
                cmd.add(bui.toString());
            }
        }
    }

    public static class RunAsUser
    extends AbstractProcessBuilderEffectiveUser
    implements EffectiveUser {
        private ArrayList<String> original;
        private char[] password;
        private boolean setRemote;
        private String username;
        private String was;

        public RunAsUser() {
            this(null);
        }

        public RunAsUser(String username) {
            this(username, null);
        }

        public RunAsUser(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void descend(ForkerBuilder builder, Process process, Command command) {
            if (this.setRemote) {
                this.setRemote = false;
                command.setRunAs(this.was);
            } else {
                builder.command().clear();
                builder.command().addAll(this.original);
            }
        }

        @Override
        public void elevate(ForkerBuilder builder, Process process, Command command) {
            if (process instanceof ForkerDaemonProcess) {
                if (this.setRemote) {
                    this.descend(builder, process, command);
                }
                this.was = command.getRunAs();
                command.setRunAs(this.username);
                this.setRemote = true;
            } else {
                List<String> cmd = builder.command();
                this.original = new ArrayList<String>(cmd);
                cmd.clear();
                cmd.add(OS.getJavaPath());
                cmd.add("-classpath");
                cmd.add(Forker.getForkerClasspath());
                cmd.add(WinRunAs.class.getName());
                if (this.username.equals(OS.getAdministratorUsername()) && command.getIO() == IO.SINK) {
                    cmd.add("--uac");
                } else {
                    cmd.add("--username");
                    cmd.add(this.username);
                    if (this.password != null) {
                        command.getEnvironment().put("W32RUNAS_PASSWORD", new String(this.password));
                    }
                }
                cmd.add("--");
                cmd.addAll(this.original);
                System.out.println(cmd);
            }
        }
    }

    public static class POSIXUsernameEffectiveUser
    extends AbstractPOSIXEffectiveUser<String> {
        public POSIXUsernameEffectiveUser(String username) {
            super(username);
        }

        @Override
        void doSet(String value) {
            try {
                this.seteuid(Integer.parseInt(Util.getIDForUsername((String)value)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class POSIXUIDEffectiveUser
    extends AbstractPOSIXEffectiveUser<Integer> {
        public POSIXUIDEffectiveUser(int uid) {
            super(uid);
        }

        @Override
        void doSet(Integer value) {
            this.seteuid(value);
        }
    }

    public class NullEffectiveUser
    implements EffectiveUser {
        @Override
        public void descend(ForkerBuilder builder, Process process, Command command) {
        }

        @Override
        public void elevate(ForkerBuilder builder, Process process, Command command) {
        }
    }

    public static class GKSuUser
    extends AbstractProcessBuilderEffectiveUser
    implements EffectiveUser {
        private ArrayList<String> original;
        private String username;

        public GKSuUser() {
        }

        public GKSuUser(String username) {
            this.username = username;
        }

        @Override
        public void descend(ForkerBuilder builder, Process process, Command command) {
            builder.command().clear();
            builder.command().addAll(this.original);
        }

        @Override
        public void elevate(ForkerBuilder builder, Process process, Command command) {
            this.original = new ArrayList<String>(builder.command());
            if (command.getIO() == IO.IO || command.getIO() == IO.INPUT) {
                throw new RuntimeException(String.format("%s does not support stdin, so may not be used.", this.getClass()));
            }
            List<String> cmd = builder.command();
            StringBuilder bui = new StringBuilder();
            for (int i = 0; i < cmd.size(); ++i) {
                if (bui.length() > 0) {
                    bui.append(' ');
                }
                if (i > 0) {
                    bui.append("'");
                }
                bui.append(Util.escapeSingleQuotes((String)cmd.get(i)));
                if (i <= 0) continue;
                bui.append("'");
            }
            cmd.clear();
            if (OSCommand.hasCommand("gksudo")) {
                cmd.add("gksudo");
                if (this.username != null) {
                    cmd.add("-u");
                    cmd.add(this.username);
                }
                cmd.add("--sudo-mode");
                cmd.add("--preserve-env");
                cmd.add("--description");
                cmd.add(EffectiveUserFactory.getDefault().getAppName());
            } else if (OSCommand.hasCommand("gksu")) {
                cmd.add("gksu");
                if (this.username != null) {
                    cmd.add("-u");
                    cmd.add(this.username);
                }
                cmd.add("--su-mode");
                cmd.add("--preserve-env");
                cmd.add("--description");
                cmd.add(EffectiveUserFactory.getDefault().getAppName());
            }
            cmd.add(bui.toString());
        }
    }

    public static class DefaultEffectiveUserFactory
    extends EffectiveUserFactory {
        private String appName = System.getProperty("forker.app.name", null);

        public DefaultEffectiveUserFactory() {
            super(true);
            if (this.appName == null) {
                String thisAppName = null;
                String threadAppName = null;
                for (Map.Entry<Thread, StackTraceElement[]> en : Thread.getAllStackTraces().entrySet()) {
                    if (en.getValue().length <= 0 || !en.getValue()[en.getValue().length - 1].getMethodName().equals("main")) continue;
                    if (Thread.currentThread() == en.getKey()) {
                        thisAppName = en.getValue()[en.getValue().length - 1].getClassName();
                        continue;
                    }
                    threadAppName = en.getValue()[en.getValue().length - 1].getClassName();
                }
                if (thisAppName == null) {
                    thisAppName = threadAppName;
                }
                this.appName = thisAppName;
            }
            if (this.appName == null) {
                this.appName = "Java Application";
            }
        }

        @Override
        public EffectiveUser administrator() {
            final EffectiveUser user = this.createAdministrator();
            return new EffectiveUser(){

                @Override
                public void descend(ForkerBuilder builder, Process process, Command command) {
                    if (Forker.isDaemonRunning() && !Forker.isDaemonRunningAsAdministrator() && process instanceof ForkerDaemonProcess || !OS.isAdministrator() && !(process instanceof ForkerDaemonProcess)) {
                        user.descend(builder, process, command);
                    }
                }

                @Override
                public void elevate(ForkerBuilder builder, Process process, Command command) {
                    if (Forker.isDaemonRunning() && !Forker.isDaemonRunningAsAdministrator() && process instanceof ForkerDaemonProcess || !OS.isAdministrator() && !(process instanceof ForkerDaemonProcess)) {
                        user.elevate(builder, process, command);
                    }
                }
            };
        }

        @Override
        public String getAppName() {
            return this.appName;
        }

        @Override
        public EffectiveUser getUserForUsername(String username) {
            if (SystemUtils.IS_OS_LINUX) {
                if (OS.isAdministrator()) {
                    return new SUUser(username);
                }
                OS.Desktop dt = OS.getDesktopEnvironment();
                if (Arrays.asList(OS.Desktop.CINNAMON, OS.Desktop.GNOME, OS.Desktop.GNOME3).contains(dt)) {
                    if (OSCommand.hasCommand("sudo") && (OSCommand.hasCommand("gksudo") || OSCommand.hasCommand("gksu"))) {
                        return new SudoGksudoUser(username);
                    }
                    if (OSCommand.hasCommand("sudo")) {
                        return new SudoAskPassGuiUser();
                    }
                    if (OSCommand.hasCommand("gksudo") || OSCommand.hasCommand("gksu")) {
                        return new GKSuUser(username);
                    }
                } else if (dt == OS.Desktop.CONSOLE) {
                    Console console = System.console();
                    if (OSCommand.hasCommand("sudo") && console == null) {
                        return new SudoAskPassUser(username);
                    }
                    if (OSCommand.hasCommand("sudo") || OSCommand.hasCommand("su")) {
                        return new SUUser(username);
                    }
                }
            } else {
                if (SystemUtils.IS_OS_MAC_OSX) {
                    return new SUUser(username);
                }
                if (SystemUtils.IS_OS_WINDOWS) {
                    return new RunAsUser(username);
                }
            }
            throw new UnsupportedOperationException(System.getProperty("os.name") + " is currently unsupported. Will not be able to get UID for username.");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected EffectiveUser createAdministrator() {
            String fixedPassword = this.getFixedPassword();
            if (SystemUtils.IS_OS_LINUX) {
                if (fixedPassword != null) {
                    return new SudoFixedPasswordUser(fixedPassword.toCharArray());
                }
                OS.Desktop dt = OS.getDesktopEnvironment();
                if (Arrays.asList(OS.Desktop.CINNAMON, OS.Desktop.GNOME, OS.Desktop.GNOME3).contains(dt)) {
                    if (OSCommand.hasCommand("sudo") && (OSCommand.hasCommand("gksudo") || OSCommand.hasCommand("gksu"))) {
                        return new SudoGksudoUser();
                    }
                    if (OSCommand.hasCommand("sudo")) {
                        return new SudoAskPassGuiUser();
                    }
                    if (!OSCommand.hasCommand("gksudo") && !OSCommand.hasCommand("gksu")) return new EffectiveUser(){

                        @Override
                        public void descend(ForkerBuilder builder, Process process, Command command) {
                        }

                        @Override
                        public void elevate(ForkerBuilder builder, Process process, Command command) {
                            throw new UnsupportedOperationException(System.getProperty("os.name") + " is currently unsupported. Will not be able to get administrative user. " + "To hard code an adminstrator password, set the system property forker.administrator.password. " + "This is unsafe, as the password will exist in a file for the life of the process. Do NOT use " + "this in a production environment.");
                        }
                    };
                    return new GKSuUser();
                }
                if (dt != OS.Desktop.CONSOLE) return new SudoAskPassGuiUser();
                Console console = System.console();
                if (OSCommand.hasCommand("sudo") && console == null) {
                    return new SudoAskPassUser();
                }
                if (!OSCommand.hasCommand("sudo") && !OSCommand.hasCommand("su")) return new /* invalid duplicate definition of identical inner class */;
                return new SUAdministrator();
            }
            if (SystemUtils.IS_OS_MAC_OSX) {
                if (fixedPassword != null) {
                    return new SudoFixedPasswordUser(fixedPassword.toCharArray());
                }
                if (!OSCommand.hasCommand("sudo")) return new /* invalid duplicate definition of identical inner class */;
                return new SudoAskPassGuiUser();
            }
            if (!SystemUtils.IS_OS_WINDOWS) return new /* invalid duplicate definition of identical inner class */;
            if (fixedPassword == null) return new RunAsUser(OS.getAdministratorUsername());
            return new RunAsUser(OS.getAdministratorUsername(), fixedPassword.toCharArray());
        }

        private String getFixedPassword() {
            String p = System.getProperty("forker.administrator.password");
            return p == null ? System.getProperty("vm.sudo") : p;
        }
    }

    public static abstract class AbstractProcessBuilderEffectiveUser
    implements EffectiveUser {
        File tempScript;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void createTempScript(String script) {
            try {
                this.tempScript = File.createTempFile("sapa", ".sh");
                this.tempScript.deleteOnExit();
                FileOutputStream out = new FileOutputStream(this.tempScript);
                PrintWriter pw = new PrintWriter(out);
                try {
                    pw.println("#!/bin/bash");
                    pw.println(script);
                    pw.println("ret=$?");
                    pw.println("rm -f '" + this.tempScript.getAbsolutePath() + "'");
                    pw.println("exit ${ret}");
                    pw.flush();
                }
                finally {
                    ((OutputStream)out).close();
                }
                this.tempScript.setExecutable(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected String javaAskPassScript(Class<?> clazz) {
            String javaExe = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            if (SystemUtils.IS_OS_WINDOWS) {
                javaExe = javaExe + ".exe";
            }
            String cp = null;
            String fullCp = System.getProperty("java.class.path", "");
            for (String p : fullCp.split(File.pathSeparator)) {
                if (!p.contains("forker-client")) continue;
                cp = p;
            }
            if (cp == null) {
                cp = fullCp;
            }
            return "\"" + javaExe + "\" -classpath \"" + cp + "\" " + clazz.getName();
        }
    }
}

