/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client;

import com.sshtools.forker.client.EffectiveUser;
import com.sshtools.forker.client.EffectiveUserFactory;
import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.common.Cookie;
import com.sshtools.forker.common.IO;
import com.sshtools.forker.common.OS;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;

public class Forker {
    static final String[] FORKER_DIRS = new String[]{".*[/\\\\]forker-client[/\\\\].*", ".*[/\\\\]forker-wrapper[/\\\\].*", ".*[/\\\\]forker-pty[/\\\\].*", ".*[/\\\\]forker-common[/\\\\].*", ".*[/\\\\]forker-daemon[/\\\\].*", ".*[/\\\\]pty4j[/\\\\].*"};
    static final String[] FORKER_JARS = new String[]{"^jna-.*", "^commons-lang-.*", "^commons-io.*", "^jna-platform-.*", "^purejavacomm-.*", "^guava-.*", "^log4j-.*", "^forker-common-.*", "^forker-client-.*", "^forker-daemon-.*", "^pty4j-.*", "^forker-wrapper-.*", "^forker-pty-.*"};
    private static boolean daemonAdministrator;
    private static String daemonClasspath;
    private static boolean daemonLoaded;
    private static Socket daemonMaintenanceSocket;
    private static boolean daemonRunning;
    private static final Forker INSTANCE;
    private static boolean wrapped;

    public Process exec(IO io, String command) throws IOException {
        return this.exec(io, command, (String[])null, (File)null);
    }

    public Process exec(IO io, String ... cmdarray) throws IOException {
        return this.exec(io, cmdarray, (String[])null, (File)null);
    }

    public Process exec(IO io, String command, String[] envp) throws IOException {
        return this.exec(io, command, envp, (File)null);
    }

    public Process exec(IO io, String command, String[] envp, File dir) throws IOException {
        if (command.length() == 0) {
            throw new IllegalArgumentException("Empty command");
        }
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        return this.exec(io, cmdarray, envp, dir);
    }

    public Process exec(IO io, String[] cmdarray, String[] envp) throws IOException {
        return this.exec(io, cmdarray, envp, (File)null);
    }

    public Process exec(IO io, String[] cmdarray, String[] envp, File dir) throws IOException {
        return new ForkerBuilder(cmdarray).io(io).environment(envp).directory(dir).start();
    }

    public static void connectDaemon(Cookie.Instance cookie) {
        Forker.loadDaemon(cookie, null, true);
    }

    public static void connectUnauthenticatedDaemon(int port) {
        Forker.connectDaemon(new Cookie.Instance("NOAUTH", port));
    }

    public static Forker get() {
        return INSTANCE;
    }

    public static String getDaemonClasspath() {
        return daemonClasspath == null ? System.getProperty("java.class.path") : daemonClasspath;
    }

    public static String getForkerClasspath() {
        return Forker.getForkerClasspath(Forker.getDaemonClasspath());
    }

    public static String getForkerClasspath(String forkerClasspath) {
        StringBuilder cp = new StringBuilder();
        block0: for (String p : forkerClasspath.split(File.pathSeparator)) {
            File f = new File(p);
            if (f.isDirectory()) {
                for (String regex : FORKER_DIRS) {
                    if (!f.getPath().matches(regex)) continue;
                    if (cp.length() > 0) {
                        cp.append(File.pathSeparator);
                    }
                    cp.append(p);
                }
                continue;
            }
            for (String regex : FORKER_JARS) {
                if (!f.getName().matches(regex)) continue;
                if (cp.length() > 0) {
                    cp.append(File.pathSeparator);
                }
                cp.append(p);
                continue block0;
            }
        }
        String classpath = cp.toString();
        return classpath;
    }

    public static boolean isDaemonLoaded() {
        return daemonLoaded;
    }

    public static boolean isDaemonRunning() {
        return daemonRunning;
    }

    public static boolean isDaemonRunningAsAdministrator() {
        return daemonRunning && daemonAdministrator;
    }

    public static boolean isWrapped() {
        return wrapped;
    }

    public static void loadDaemon() {
        Forker.loadDaemon(false);
    }

    public static void loadDaemon(boolean asAdministrator) {
        if (!daemonLoaded) {
            Forker.loadDaemon(asAdministrator ? EffectiveUserFactory.getDefault().administrator() : null);
            daemonAdministrator = asAdministrator;
        }
    }

    public static void loadDaemon(EffectiveUser effectiveUser) {
        Forker.loadDaemon(null, effectiveUser, effectiveUser != null);
    }

    public static void loadIsolatedDaemon() {
        Forker.loadDaemon(null, null, true);
    }

    public static void main(String[] args) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String cookieText = reader.readLine();
        final Cookie.Instance cookie = new Cookie.Instance(cookieText);
        Cookie.get().set(cookie);
        daemonLoaded = true;
        wrapped = true;
        daemonRunning = true;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        daemonAdministrator = "true".equals(argList.remove(0));
        String classname = (String)argList.remove(0);
        Class<?> clazz = Class.forName(classname);
        final Socket daemonSocket = new Socket();
        long started = System.currentTimeMillis();
        while (true) {
            try {
                daemonSocket.connect(new InetSocketAddress("127.0.0.1", cookie.getPort()), 5000);
            }
            catch (Exception e) {
                if (System.currentTimeMillis() - started <= 30000L) continue;
                return;
            }
            break;
        }
        new Thread(){
            {
                this.setDaemon(true);
                this.setPriority(1);
                this.setName("ForkerWrapperLink");
            }

            @Override
            public void run() {
                try {
                    try {
                        DataOutputStream dos = new DataOutputStream(daemonSocket.getOutputStream());
                        dos.writeUTF(cookie.getCookie());
                        dos.writeByte(2);
                        dos.flush();
                        DataInputStream din = new DataInputStream(daemonSocket.getInputStream());
                        while (true) {
                            if (din.readInt() != 0) {
                                throw new Exception("Unexpected response.");
                            }
                            dos.writeByte(0);
                            dos.flush();
                        }
                    }
                    catch (Exception e) {
                        if (daemonSocket != null) {
                            try {
                                daemonSocket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        System.err.println("Process terminated due to wrapper process terminating");
                        System.exit(1);
                    }
                }
                catch (Throwable throwable) {
                    System.err.println("Process terminated due to wrapper process terminating");
                    System.exit(1);
                    throw throwable;
                }
            }
        }.start();
        clazz.getMethod("main", String[].class).invoke(null, new Object[]{argList.toArray(new String[0])});
    }

    public static InputStream readFile(File file) throws IOException {
        Cookie cookie = Cookie.get();
        Cookie.Instance instance = cookie.load();
        final Socket daemonSocket = new Socket("127.0.0.1", instance.getPort());
        try {
            DataOutputStream dos = new DataOutputStream(daemonSocket.getOutputStream());
            dos.writeUTF(instance.getCookie());
            dos.writeByte(3);
            dos.writeUTF(file.getAbsolutePath());
            dos.flush();
            DataInputStream din = new DataInputStream(daemonSocket.getInputStream());
            if (din.readInt() != 0) {
                throw new IOException(din.readUTF());
            }
            din.readLong();
            return new FilterInputStream(daemonSocket.getInputStream()){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        daemonSocket.close();
                    }
                }
            };
        }
        catch (IOException e) {
            daemonSocket.close();
            throw e;
        }
    }

    public static void setDaemonClasspath(String cp) {
        if (Forker.isDaemonRunning()) {
            throw new IllegalStateException("Daemon is already running.");
        }
        daemonClasspath = cp;
    }

    public static OutputStream writeFile(File file, boolean append) throws IOException {
        Cookie cookie = Cookie.get();
        Cookie.Instance instance = cookie.load();
        final Socket daemonSocket = new Socket("127.0.0.1", instance.getPort());
        try {
            final DataOutputStream dos = new DataOutputStream(daemonSocket.getOutputStream());
            dos.writeUTF(instance.getCookie());
            dos.writeByte(4);
            dos.writeUTF(file.getAbsolutePath());
            dos.writeBoolean(append);
            dos.flush();
            final DataInputStream din = new DataInputStream(daemonSocket.getInputStream());
            if (din.readInt() != 0) {
                throw new IOException(din.readUTF());
            }
            return new OutputStream(){

                @Override
                public void close() throws IOException {
                    try {
                        dos.writeInt(0);
                        din.readInt();
                    }
                    catch (IOException ioe) {
                        daemonSocket.close();
                        throw ioe;
                    }
                }

                @Override
                public void flush() throws IOException {
                    try {
                        dos.flush();
                    }
                    catch (IOException ioe) {
                        daemonSocket.close();
                        throw ioe;
                    }
                }

                @Override
                public void write(byte[] b) throws IOException {
                    try {
                        if (b.length > 0) {
                            dos.writeInt(b.length);
                            dos.write(b);
                        }
                    }
                    catch (IOException ioe) {
                        daemonSocket.close();
                        throw ioe;
                    }
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    try {
                        if (len > 0) {
                            dos.writeInt(len);
                            dos.write(b, off, len);
                        }
                    }
                    catch (IOException ioe) {
                        daemonSocket.close();
                        throw ioe;
                    }
                }

                @Override
                public void write(int b) throws IOException {
                    try {
                        dos.writeInt(1);
                        dos.writeByte(b);
                    }
                    catch (IOException ioe) {
                        daemonSocket.close();
                        throw ioe;
                    }
                }
            };
        }
        catch (IOException e) {
            daemonSocket.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadDaemon(Cookie.Instance fixedCookie, EffectiveUser effectiveUser, boolean isolated) {
        long expire;
        long now;
        ForkerDaemonThread fdt;
        Cookie.Instance cookie2;
        if (daemonLoaded) return;
        try {
            Class.forName("com.sshtools.forker.daemon.Forker");
            try {
                boolean isRunning;
                cookie2 = fixedCookie == null ? (isolated ? null : Cookie.get().load()) : fixedCookie;
                boolean bl = isRunning = cookie2 != null && cookie2.isRunning();
                if (!isRunning) {
                    if (fixedCookie != null) {
                        System.err.println("[WARNING] A fixed cookie of " + fixedCookie + " was provided, but a daemon for this is not running.");
                        return;
                    }
                } else {
                    daemonRunning = true;
                    if (fixedCookie == null) return;
                    Cookie.get().set(fixedCookie);
                    return;
                }
                fdt = new ForkerDaemonThread(effectiveUser, isolated);
                fdt.start();
                now = System.currentTimeMillis();
                expire = now + (long)(Integer.parseInt(System.getProperty("forker.daemon.launchTimeout", "180")) * 1000);
            }
            catch (InterruptedException cookie2) {
                return;
            }
            catch (IOException ioe) {
                System.err.println("[WARNING] Could not load cookie, and so could not start a daemon.");
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        finally {
            daemonLoaded = true;
        }
        while (now < expire && !fdt.errored) {
            try {
                cookie2 = Cookie.get().load();
                if (cookie2 != null && cookie2.isRunning()) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            now = System.currentTimeMillis();
            Thread.sleep(500L);
        }
        if (cookie2 == null) throw new RuntimeException("Failed to start forker daemon.");
        if (!cookie2.isRunning()) {
            throw new RuntimeException("Failed to start forker daemon.");
        }
        daemonRunning = true;
        if (!isolated) return;
        daemonMaintenanceSocket = null;
        try {
            daemonMaintenanceSocket = new Socket("127.0.0.1", cookie2.getPort());
            DataOutputStream dos = new DataOutputStream(daemonMaintenanceSocket.getOutputStream());
            dos.writeUTF(cookie2.getCookie());
            dos.writeByte(1);
            dos.flush();
            DataInputStream din = new DataInputStream(daemonMaintenanceSocket.getInputStream());
            if (din.readInt() == 0) return;
            throw new Exception("Unexpected response.");
        }
        catch (Exception e) {
            if (daemonMaintenanceSocket == null) return;
            daemonMaintenanceSocket.close();
            return;
        }
    }

    static {
        INSTANCE = new Forker();
    }

    private static final class ForkerDaemonThread
    extends Thread {
        private final EffectiveUser effectiveUser;
        private boolean errored;
        private boolean isolated;
        private Process process;

        private ForkerDaemonThread(EffectiveUser effectiveUser, boolean isolated) {
            super("ForkerDaemon");
            this.effectiveUser = effectiveUser;
            this.isolated = isolated;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String javaExe = OS.getJavaPath();
            String forkerClasspath = daemonClasspath == null ? System.getProperty("java.class.path", "") : daemonClasspath;
            String classpath = Forker.getForkerClasspath(forkerClasspath);
            ForkerBuilder fb = new ForkerBuilder(javaExe, "-Xmx" + System.getProperty("forker.daemon.maxMemory", "8m"), "-Djava.library.path=" + System.getProperty("java.library.path", ""), "-classpath", classpath, "com.sshtools.forker.daemon.Forker");
            if (this.effectiveUser != null) {
                fb.effectiveUser(this.effectiveUser);
            }
            if (this.isolated) {
                fb.command().add("--isolated");
            }
            fb.io(IO.DEFAULT);
            fb.redirectErrorStream(true);
            try {
                this.process = fb.start();
                try {
                    InputStream inputStream = this.process.getInputStream();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                int r;
                                OutputStream outputStream = ForkerDaemonThread.this.process.getOutputStream();
                                while ((r = System.in.read()) != -1) {
                                    outputStream.write(r);
                                    outputStream.flush();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }.start();
                    if (this.isolated) {
                        int r;
                        StringBuffer line = new StringBuffer();
                        String matchStr = "FORKER-COOKIE: ";
                        int matched = 0;
                        while ((r = inputStream.read()) != -1) {
                            char chr = (char)r;
                            if (r == 13 || r == 10) {
                                matched = 0;
                                String l = line.toString();
                                if (l.startsWith("FORKER-COOKIE: ")) {
                                    Cookie.get().set(new Cookie.Instance(l.substring(15)));
                                    break;
                                }
                                line.setLength(0);
                                System.out.print(chr);
                                continue;
                            }
                            line.append(chr);
                            if (chr == matchStr.charAt(matched)) {
                                if (++matched != matchStr.length()) continue;
                                Cookie.get().set(new Cookie.Instance(new BufferedReader(new InputStreamReader(inputStream)).readLine()));
                                break;
                            }
                            if (matched > 0) {
                                matched = 0;
                                System.out.print(line.toString());
                            }
                            System.out.print(chr);
                        }
                    }
                    IOUtils.copy((InputStream)inputStream, (OutputStream)System.err);
                }
                finally {
                    this.process.waitFor();
                }
                if (this.process.exitValue() != 0) {
                    throw new IOException("Attempt to start forker daemon returned exit code " + this.process.exitValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errored = true;
            }
        }
    }
}

