/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client;

import com.sshtools.forker.client.EffectiveUser;
import com.sshtools.forker.client.Forker;
import com.sshtools.forker.client.ForkerConfiguration;
import com.sshtools.forker.client.ForkerProcess;
import com.sshtools.forker.client.ForkerProcessFactory;
import com.sshtools.forker.client.ForkerProcessListener;
import com.sshtools.forker.common.Command;
import com.sshtools.forker.common.IO;
import com.sshtools.forker.common.OS;
import com.sshtools.forker.common.Priority;
import com.sshtools.forker.common.Util;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ForkerBuilder {
    private boolean background;
    private Command command = new Command();
    private ForkerConfiguration configuration;
    private EffectiveUser effectiveUser;

    public ForkerBuilder(ForkerConfiguration configuration, List<String> command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.configuration = configuration;
        this.command.getArguments().addAll(command);
        this.initBuilder();
    }

    public ForkerBuilder(ForkerConfiguration configuration, String ... command) {
        this.configuration = configuration;
        this.command.getArguments().addAll(Arrays.asList(command));
        this.initBuilder();
    }

    public ForkerBuilder(List<String> command) {
        this(ForkerConfiguration.getDefault(), command);
    }

    public ForkerBuilder(String ... command) {
        this(ForkerConfiguration.getDefault(), command);
    }

    public List<Integer> affinity() {
        return this.command.getAffinity();
    }

    public boolean background() {
        return this.background;
    }

    public ForkerBuilder background(boolean background) {
        this.background = background;
        return this;
    }

    public List<String> command() {
        return this.command.getArguments();
    }

    public ForkerBuilder command(List<String> command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.command.getArguments().clear();
        this.command.getArguments().addAll(command);
        return this;
    }

    public ForkerBuilder command(String ... command) {
        this.command.getArguments().clear();
        this.command.getArguments().addAll(Arrays.asList(command));
        return this;
    }

    public ForkerConfiguration configuration() {
        return this.configuration;
    }

    public File directory() {
        return this.command.getDirectory();
    }

    public ForkerBuilder directory(File directory) {
        this.command.setDirectory(directory);
        return this;
    }

    public EffectiveUser effectiveUser() {
        return this.effectiveUser;
    }

    public ForkerBuilder effectiveUser(EffectiveUser effectiveUser) {
        this.effectiveUser = effectiveUser;
        return this;
    }

    public Map<String, String> environment() {
        return this.command.getEnvironment();
    }

    public ForkerBuilder environment(String[] envp) {
        if (envp != null) {
            this.command.getEnvironment().clear();
            for (String envstring : envp) {
                int eqlsign;
                if (envstring.indexOf(0) != -1) {
                    envstring = envstring.replaceFirst("\u0000.*", "");
                }
                if ((eqlsign = envstring.indexOf(61, 0)) == -1) continue;
                this.command.getEnvironment().put(envstring.substring(0, eqlsign), envstring.substring(eqlsign + 1));
            }
        }
        return this;
    }

    public List<String> getAllArguments() {
        return this.command.getAllArguments();
    }

    public Command getCommand() {
        return this.command;
    }

    public List<ForkerProcessFactory> getProcessFactories() {
        return this.configuration.getProcessFactories();
    }

    public IO io() {
        return this.command.getIO();
    }

    public ForkerBuilder io(IO io) {
        if ((io == IO.SINK || io == IO.OUTPUT) && this.redirectErrorStream()) {
            throw new IllegalStateException("Cannot set IO mode '" + io + "' because redirectErrorStream() is true.");
        }
        this.command.setIO(io);
        return this;
    }

    public ForkerBuilder java() {
        return this.java(System.getProperty("java.class.path"));
    }

    public ForkerBuilder java(String classpath) {
        this.command.getArguments().clear();
        this.command.getArguments().add(OS.getJavaPath());
        this.command.getArguments().add("-classpath");
        this.command.getArguments().add(classpath);
        return this;
    }

    public ForkerBuilder parse(String command) {
        this.command.getArguments().clear();
        this.command.getArguments().addAll(Util.parseQuotedString((String)command));
        return this;
    }

    public Priority priority() {
        return this.command.getPriority();
    }

    public ForkerBuilder priority(Priority priority) {
        this.command.setPriority(priority);
        return this;
    }

    public <T extends ForkerProcessFactory> T processFactory(Class<T> clazz) {
        return this.configuration.processFactory(clazz);
    }

    public boolean redirectErrorStream() {
        return this.command.isRedirectError();
    }

    public ForkerBuilder redirectErrorStream(boolean redirectErrorStream) {
        if (redirectErrorStream && !this.command.getIO().isAllowStdErrRedirect()) {
            throw new IllegalStateException("Cannot redirect error stream if using IO mode '" + this.command.getIO() + "'");
        }
        this.command.setRedirectError(redirectErrorStream);
        return this;
    }

    public ForkerProcess start() throws IOException {
        return this.start(null);
    }

    public ForkerProcess start(ForkerProcessListener listener) throws IOException {
        String[] cmdarray = this.command.getArguments().toArray(new String[this.command.getArguments().size()]);
        for (String arg : cmdarray = (String[])cmdarray.clone()) {
            if (arg != null) continue;
            throw new NullPointerException();
        }
        String prog = cmdarray[0];
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkExec(prog);
        }
        String dir = this.command.getDirectory() == null ? null : this.command.getDirectory().toString();
        for (int i = 1; i < cmdarray.length; ++i) {
            if (cmdarray[i].indexOf(0) < 0) continue;
            throw new IOException("invalid null character in command");
        }
        ForkerProcess process = null;
        for (ForkerProcessFactory processFactory : this.configuration.getProcessFactories()) {
            try {
                process = processFactory.createProcess(this, listener);
                if (process == null) continue;
                return process;
            }
            catch (IOException e) {
                throw this.handleIOException(prog, security, dir, e);
            }
            catch (IllegalArgumentException e) {
                throw this.handleIllegalArgumentException(prog, dir, e);
            }
        }
        throw new UnsupportedOperationException("No factory was willing to handle this type of process.");
    }

    public String toString() {
        return "ForkerBuilder [command=" + this.command + ", background=" + this.background + ", effectiveUser=" + this.effectiveUser + "]";
    }

    protected IOException handleIllegalArgumentException(String prog, String dir, IllegalArgumentException e) {
        String exceptionInfo = ": " + e.getMessage();
        return new IOException("Cannot run program \"" + prog + "\"" + (dir == null ? "" : " (in directory \"" + dir + "\")") + exceptionInfo, e);
    }

    protected IOException handleIOException(String prog, SecurityManager security, String dir, IOException e) throws IOException {
        String exceptionInfo = ": " + e.getMessage();
        Exception cause = e;
        if (security != null) {
            try {
                security.checkRead(prog);
            }
            catch (AccessControlException ace) {
                exceptionInfo = "";
                cause = ace;
            }
        }
        return new IOException("Cannot run program \"" + prog + "\"" + (dir == null ? "" : " (in directory \"" + dir + "\")") + exceptionInfo, cause);
    }

    protected void initBuilder() {
        if (Forker.isDaemonRunning()) {
            this.command.setIO(IO.DAEMON);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Process startLocalProcess() throws IOException {
        if (this.effectiveUser != null) {
            this.effectiveUser.elevate(this, null, this.command);
        }
        try {
            List allArguments = this.command.getAllArguments();
            ProcessBuilder pb = new ProcessBuilder(allArguments);
            if (this.command.isRedirectError()) {
                pb.redirectErrorStream(true);
            }
            if (this.command.getDirectory() != null) {
                pb.directory(this.command.getDirectory());
            }
            if (this.command.getEnvironment() != null) {
                pb.environment().putAll(this.command.getEnvironment());
            }
            Process process = pb.start();
            return process;
        }
        finally {
            if (this.effectiveUser != null) {
                this.effectiveUser.descend(this, null, this.command);
            }
        }
    }
}

