/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client;

import com.sshtools.forker.client.ForkerProcessFactory;
import com.sshtools.forker.client.impl.DefaultProcessFactory;
import com.sshtools.forker.client.impl.ForkerDaemonProcessFactory;
import com.sshtools.forker.client.impl.LocalProcessFactory;
import com.sshtools.forker.client.impl.POpenProcessFactory;
import com.sshtools.forker.client.impl.SystemProcessFactory;
import com.sshtools.forker.client.impl.nonblocking.NonBlockingProcessFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public abstract class ForkerConfiguration {
    private static ForkerConfiguration instance;
    private static Object lock;
    private List<ForkerProcessFactory> processFactories = new ArrayList<ForkerProcessFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ForkerConfiguration() {
        Iterator<ForkerProcessFactory> iterator = lock;
        synchronized (iterator) {
            if (instance == null) {
                instance = this;
            }
        }
        for (ForkerProcessFactory io : ServiceLoader.load(ForkerProcessFactory.class)) {
            this.processFactories.add(io);
        }
        this.processFactories.add(new NonBlockingProcessFactory());
        this.processFactories.add(new POpenProcessFactory());
        this.processFactories.add(new SystemProcessFactory());
        this.processFactories.add(new DefaultProcessFactory());
        this.processFactories.add(new ForkerDaemonProcessFactory());
        this.processFactories.add(new LocalProcessFactory());
    }

    public List<ForkerProcessFactory> getProcessFactories() {
        return this.processFactories;
    }

    public <T extends ForkerProcessFactory> T processFactory(Class<T> clazz) {
        for (ForkerProcessFactory pf : this.processFactories) {
            if (!pf.getClass().equals(clazz)) continue;
            return (T)pf;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ForkerConfiguration getDefault() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                new ForkerConfiguration(){};
            }
            return instance;
        }
    }

    static {
        lock = new Object();
    }
}

