/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class ForkerProcess
extends Process {
    public void closeStdin(boolean force) throws IOException {
        this.getOutputStream().close();
    }

    public boolean hasPendingWrites() {
        return false;
    }

    public void wantWrite() {
        throw new UnsupportedOperationException();
    }

    public void writeStdin(ByteBuffer buffer) throws IOException {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        this.getOutputStream().write(bytes);
        this.getOutputStream().flush();
    }

    public static void readToStdin(InputStream in, ForkerProcess process) throws IOException {
        ForkerProcess.readToStdin(in, process, 65536);
    }

    public static void readToStdin(InputStream in, ForkerProcess process, int bufferSize) throws IOException {
        int r;
        byte[] buf = new byte[bufferSize];
        OutputStream outputStream = process.getOutputStream();
        while ((r = in.read(buf)) != -1) {
            outputStream.write(buf, 0, r);
            outputStream.flush();
        }
    }

    public static void writeToOutputStream(OutputStream out, ByteBuffer buffer) throws IOException {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        out.write(bytes);
        out.flush();
    }
}

