/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client;

import com.sshtools.forker.client.EffectiveUserFactory;
import com.sshtools.forker.client.Forker;
import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.client.ForkerProcess;
import com.sshtools.forker.common.IO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class OSCommand {
    static final Logger LOG = Logger.getLogger(OSCommand.class.getSimpleName());
    private static ThreadLocal<Boolean> elevated = new ThreadLocal();
    private static ThreadLocal<Map<String, String>> environment = new ThreadLocal();
    private static ThreadLocal<IO> io = new ThreadLocal();
    private static char[] sudoPassword = null;

    public static void admin(File cwd, List<String> args) throws IOException {
        OSCommand.admin(cwd, null, args);
    }

    public static void admin(File cwd, OutputStream out, List<String> args) throws IOException {
        Process process = OSCommand.doAdminCommand(cwd, args, out);
        if (process.exitValue() != 0) {
            throw new IOException("Update process exited with status " + process.exitValue() + ". See log for more details.");
        }
    }

    public static void admin(File cwd, OutputStream out, String ... args) throws IOException {
        int ret = OSCommand.adminCommand(cwd, out, args);
        if (ret != 0) {
            throw new IOException("Command returned non-zero status '" + ret + "'.");
        }
    }

    public static void admin(File cwd, String ... args) throws IOException {
        int ret = OSCommand.adminCommand(cwd, args);
        if (ret != 0) {
            throw new IOException("Command returned non-zero status '" + ret + "'.");
        }
    }

    public static void admin(List<String> args) throws IOException {
        OSCommand.admin((File)null, args);
    }

    public static void admin(OutputStream out, List<String> args) throws IOException {
        OSCommand.admin((File)null, out, args);
    }

    public static void admin(String ... args) throws IOException {
        OSCommand.admin(null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int adminCommand(File cwd, OutputStream out, String ... args) throws IOException {
        OSCommand.elevate();
        try {
            int n = OSCommand.runCommand(cwd, out, args);
            return n;
        }
        finally {
            OSCommand.restrict();
        }
    }

    public static int adminCommand(File cwd, String ... args) throws IOException {
        return OSCommand.adminCommand(cwd, System.out, args);
    }

    public static int adminCommand(List<String> args) throws IOException {
        return OSCommand.runCommand(args.toArray(new String[0]));
    }

    public static int adminCommand(OutputStream out, List<String> args) throws IOException {
        return OSCommand.runCommand((File)null, out, args.toArray(new String[0]));
    }

    public static int adminCommand(String ... args) throws IOException {
        return OSCommand.adminCommand(null, args);
    }

    public static Collection<String> adminCommandAndCaptureOutput(File cwd, String ... args) throws IOException {
        OSCommand.elevate();
        try {
            Collection<String> collection = OSCommand.adminCommandAndCaptureOutput(cwd, args);
            return collection;
        }
        finally {
            OSCommand.restrict();
        }
    }

    public static Iterable<String> adminCommandAndIterateOutput(File cwd, String ... args) throws IOException {
        OSCommand.elevate();
        try {
            Iterable<String> iterable = OSCommand.adminCommandAndIterateOutput(cwd, args);
            return iterable;
        }
        finally {
            OSCommand.restrict();
        }
    }

    public static Collection<String> adminCommandAndCaptureOutput(String ... args) throws IOException {
        return OSCommand.adminCommandAndCaptureOutput(null, args);
    }

    public static Iterable<String> adminCommandAndIterateOutput(String ... args) throws IOException {
        return OSCommand.adminCommandAndIterateOutput(null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int adminCommandAndOutputToFile(File cwd, File file, String ... args) throws IOException {
        OSCommand.elevate();
        try {
            int n = OSCommand.runCommandAndOutputToFile(cwd, file, args);
            return n;
        }
        finally {
            OSCommand.restrict();
        }
    }

    public static int adminCommandAndOutputToFile(File file, String ... args) throws IOException {
        return OSCommand.adminCommandAndOutputToFile(null, file, args);
    }

    public static Process doAdminCommand(File cwd, List<String> args) throws IOException {
        return OSCommand.doAdminCommand(cwd, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Process doAdminCommand(File cwd, List<String> args, OutputStream out) throws IOException {
        OSCommand.elevate();
        try {
            Process process = OSCommand.doCommand(cwd, args, out);
            return process;
        }
        finally {
            OSCommand.restrict();
        }
    }

    public static Process doAdminCommand(List<String> args) throws IOException {
        return OSCommand.doAdminCommand((File)null, args);
    }

    public static Process doAdminCommand(List<String> args, OutputStream out) throws IOException {
        return OSCommand.doAdminCommand(null, args, out);
    }

    public static Process doCommand(File cwd, List<String> args) throws IOException {
        return OSCommand.doCommand(cwd, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Process doCommand(File cwd, List<String> args, OutputStream out) throws IOException {
        args = new ArrayList<String>(args);
        LOG.fine("Running command: " + StringUtils.join(args, (String)" "));
        ForkerBuilder builder = new ForkerBuilder(args);
        if (builder.io() == null) {
            builder.io(io.get() == null ? IO.INPUT : io.get());
        }
        OSCommand.checkElevationAndEnvironment(builder);
        if (cwd != null) {
            builder.directory(cwd);
        }
        builder.redirectErrorStream(true);
        ForkerProcess process = builder.start();
        InputStream inputStream = process.getInputStream();
        try {
            if (out == null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                OSCommand.readInput(reader);
            } else {
                out = new FilterOutputStream(out){

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        super.write(b, off, len);
                        System.out.print(new String(b, off, len));
                    }

                    @Override
                    public void write(int b) throws IOException {
                        super.write(b);
                        System.out.print((char)b);
                    }
                };
                IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            }
        }
        finally {
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            inputStream.close();
        }
        return process;
    }

    public static Process doCommand(List<String> args) throws IOException {
        return OSCommand.doCommand((File)null, args);
    }

    public static Process doCommand(List<String> args, OutputStream out) throws IOException {
        return OSCommand.doCommand(null, args, out);
    }

    public static boolean elevate() {
        boolean res = !Boolean.TRUE.equals(elevated.get());
        elevated.set(Boolean.TRUE);
        return res;
    }

    public static AutoCloseable elevated() {
        return new AutoCloseable(){
            {
                if (OSCommand.elevate()) {
                    throw new IllegalStateException("Already elevated.");
                }
            }

            @Override
            public void close() throws Exception {
                OSCommand.restrict();
            }
        };
    }

    public static Map<String, String> environment() {
        Map<String, String> env = environment.get();
        if (env == null) {
            env = new HashMap<String, String>();
            environment.set(env);
        }
        return env;
    }

    public static void environment(Map<String, String> env) {
        environment.set(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasCommand(String command) {
        if (SystemUtils.IS_OS_LINUX) {
            boolean el = OSCommand.restrict();
            try {
                Collection<String> out = OSCommand.runCommandAndCaptureOutput("which", command);
                boolean bl = !out.isEmpty();
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (el) {
                    OSCommand.elevate();
                }
            }
        }
        String path = System.getenv("PATH");
        if (path != "") {
            boolean found = false;
            for (String p : path.split(File.pathSeparator)) {
                File e;
                File f = new File(p);
                if (!f.isDirectory()) continue;
                String cmd = command;
                if (SystemUtils.IS_OS_WINDOWS) {
                    cmd = cmd + ".exe";
                }
                if (!(e = new File(f, cmd)).exists()) continue;
                found = true;
                break;
            }
            return found;
        }
        throw new UnsupportedOperationException(System.getProperty("os.name") + " is not supported. Cannot determine if command " + command + " exists");
    }

    public static IO io() {
        return io.get();
    }

    public static IO io(IO io) {
        IO oio = OSCommand.io();
        OSCommand.io.set(io);
        return oio;
    }

    public static void reset() {
        elevated.remove();
        io.remove();
        environment.remove();
    }

    public static boolean restrict() {
        boolean el = Boolean.TRUE.equals(elevated.get());
        elevated.set(Boolean.FALSE);
        return el;
    }

    public static void run(File cwd, List<String> args) throws IOException {
        OSCommand.run(cwd, null, args);
    }

    public static void run(File cwd, OutputStream out, List<String> args) throws IOException {
        Process process = OSCommand.doCommand(cwd, args, out);
        if (process.exitValue() != 0) {
            throw new IOException("Update process exited with status " + process.exitValue() + ". See log for more details.");
        }
    }

    public static void run(File cwd, OutputStream out, String ... args) throws IOException {
        int ret = OSCommand.runCommand(cwd, out, args);
        if (ret != 0) {
            throw new IOException("Command returned non-zero status '" + ret + "'.");
        }
    }

    public static void run(File cwd, String ... args) throws IOException {
        int ret = OSCommand.runCommand(cwd, args);
        if (ret != 0) {
            throw new IOException("Command returned non-zero status '" + ret + "'.");
        }
    }

    public static void run(List<String> args) throws IOException {
        OSCommand.run((File)null, args);
    }

    public static void run(OutputStream out, List<String> args) throws IOException {
        OSCommand.run((File)null, out, args);
    }

    public static void run(String ... args) throws IOException {
        OSCommand.run(null, args);
    }

    public static int runCommand(File cwd, OutputStream out, String ... args) throws IOException {
        LOG.fine("Running command: " + StringUtils.join((Object[])args, (String)" "));
        ArrayList<String> largs = new ArrayList<String>(Arrays.asList(args));
        ForkerBuilder pb = new ForkerBuilder(largs);
        if (pb.io() == null) {
            pb.io(io.get() == null ? IO.INPUT : io.get());
        }
        OSCommand.checkElevationAndEnvironment(pb);
        if (cwd != null) {
            pb.directory(cwd);
        }
        pb.redirectErrorStream(true);
        ForkerProcess p = pb.start();
        IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)(out == null ? new NullOutputStream() : out));
        try {
            return p.waitFor();
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, "Command interrupted.", e);
            return -999;
        }
    }

    public static int runCommand(File cwd, String ... args) throws IOException {
        return OSCommand.runCommand(cwd, System.out, args);
    }

    public static int runCommand(List<String> args) throws IOException {
        return OSCommand.runCommand(args.toArray(new String[0]));
    }

    public static int runCommand(OutputStream out, List<String> args) throws IOException {
        return OSCommand.runCommand((File)null, out, args.toArray(new String[0]));
    }

    public static int runCommand(String ... args) throws IOException {
        return OSCommand.runCommand(null, args);
    }

    public static Iterable<String> runCommandAndIterateOutput(File cwd, String ... args) throws IOException {
        final ArrayList<String> largs = new ArrayList<String>(Arrays.asList(args));
        LOG.fine("Running command: " + StringUtils.join(largs, (String)" "));
        ForkerBuilder pb = new ForkerBuilder(largs);
        if (pb.io() == null) {
            pb.io(io.get() == null ? IO.INPUT : io.get());
        }
        OSCommand.checkElevationAndEnvironment(pb);
        if (cwd != null) {
            pb.directory(cwd);
        }
        pb.redirectErrorStream(true);
        final ForkerProcess p = pb.start();
        final BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        return new Iterable<String>(){
            Iterator<String> iterator = null;

            @Override
            public Iterator<String> iterator() {
                if (this.iterator == null) {
                    this.iterator = new Iterator<String>(){
                        String next;

                        void checkNext() {
                            if (this.next == null) {
                                try {
                                    int ret;
                                    this.next = reader.readLine();
                                    if (this.next == null && (ret = p.waitFor()) != 0) {
                                        throw new IOException("Command '" + StringUtils.join((Collection)largs, (String)" ") + "' returned non-zero status. Returned " + ret + ". ");
                                    }
                                }
                                catch (IOException ioe) {
                                    throw new IllegalStateException("I/O iterator while iterating.");
                                }
                                catch (InterruptedException e) {
                                    LOG.log(Level.SEVERE, "Command interrupted.", e);
                                    throw new IllegalStateException(e.getMessage(), e);
                                }
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            this.checkNext();
                            return this.next != null;
                        }

                        @Override
                        public String next() {
                            this.checkNext();
                            return this.next;
                        }
                    };
                    return this.iterator;
                }
                throw new IllegalStateException("Can only create 1 iterator.");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> runCommandAndCaptureOutput(File cwd, String ... args) throws IOException {
        File askPass = null;
        try {
            ArrayList<String> largs = new ArrayList<String>(Arrays.asList(args));
            LOG.fine("Running command: " + StringUtils.join(largs, (String)" "));
            ForkerBuilder pb = new ForkerBuilder(largs);
            if (pb.io() == null) {
                pb.io(io.get() == null ? IO.INPUT : io.get());
            }
            OSCommand.checkElevationAndEnvironment(pb);
            if (cwd != null) {
                pb.directory(cwd);
            }
            pb.redirectErrorStream(true);
            ForkerProcess p = pb.start();
            List lines = IOUtils.readLines((InputStream)p.getInputStream());
            try {
                int ret = p.waitFor();
                if (ret != 0) {
                    throw new IOException("Command '" + StringUtils.join(largs, (String)" ") + "' returned non-zero status. Returned " + ret + ". " + StringUtils.join((Collection)lines, (String)"\n"));
                }
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "Command interrupted.", e);
                throw new IOException(e.getMessage(), e);
            }
            List list = lines;
            return list;
        }
        finally {
            if (askPass != null) {
                askPass.delete();
            }
        }
    }

    public static Iterable<String> runCommandAndIterateOutput(String ... args) throws IOException {
        return OSCommand.runCommandAndIterateOutput(null, args);
    }

    public static Collection<String> runCommandAndCaptureOutput(String ... args) throws IOException {
        return OSCommand.runCommandAndCaptureOutput(null, args);
    }

    public static int runCommandAndOutputToFile(File cwd, File file, String ... args) throws IOException {
        LOG.fine("Running command: " + StringUtils.join((Object[])args, (String)" ") + " > " + file);
        try (FileOutputStream fos = new FileOutputStream(file);){
            ForkerBuilder pb = new ForkerBuilder(args);
            pb.io(io.get() == null ? IO.INPUT : io.get());
            if (cwd != null) {
                pb.directory(cwd);
            }
            pb.redirectErrorStream(true);
            OSCommand.checkElevationAndEnvironment(pb);
            ForkerProcess p = pb.start();
            IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)fos);
            try {
                int n = p.waitFor();
                return n;
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "Command interrupted.", e);
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    public static int runCommandAndOutputToFile(File file, String ... args) throws IOException {
        return OSCommand.runCommandAndOutputToFile(null, file, args);
    }

    public static void sudo(char[] password) {
        sudoPassword = password;
    }

    private static void checkElevationAndEnvironment(ForkerBuilder pb) {
        Map<String, String> env = environment.get();
        if (env != null && !env.isEmpty()) {
            pb.environment().putAll(env);
        }
        if (Boolean.TRUE.equals(elevated.get())) {
            if (Forker.isDaemonRunning()) {
                pb.effectiveUser(new EffectiveUserFactory.POSIXUIDEffectiveUser(0));
            } else {
                pb.effectiveUser(sudoPassword == null ? EffectiveUserFactory.getDefault().administrator() : new EffectiveUserFactory.SudoFixedPasswordUser(sudoPassword));
            }
        } else if (Forker.isDaemonRunningAsAdministrator()) {
            pb.effectiveUser(new EffectiveUserFactory.POSIXUsernameEffectiveUser(System.getProperty("user.name")));
        }
    }

    private static void readInput(BufferedReader reader) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
    }
}

