/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client;

import com.sshtools.forker.client.ForkerBuilder;
import com.sshtools.forker.client.ForkerConfiguration;
import com.sshtools.forker.client.ForkerProcess;
import com.sshtools.forker.client.OSCommand;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.SystemUtils;

public class ShellBuilder
extends ForkerBuilder {
    private boolean loginShell;
    private File rcfile;

    public ShellBuilder(ForkerConfiguration configuration, List<String> command) {
        super(configuration, command);
    }

    public ShellBuilder(ForkerConfiguration configuration, String ... command) {
        super(configuration, command);
    }

    public ShellBuilder(List<String> command) {
        super(command);
    }

    public ShellBuilder(String ... command) {
        super(command);
    }

    public boolean loginShell() {
        return this.loginShell;
    }

    public ShellBuilder loginShell(boolean loginShell) {
        this.loginShell = loginShell;
        return this;
    }

    public File rcfile() {
        return this.rcfile;
    }

    public ShellBuilder rcfile(File rcfile) {
        this.rcfile = rcfile;
        return this;
    }

    @Override
    public ForkerProcess start() throws IOException {
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_UNIX || SystemUtils.IS_OS_MAC_OSX) {
            String shLocation = this.findCommand("bash", "/usr/bin/bash", "/bin/bash");
            if (shLocation == null) {
                shLocation = this.findCommand("sh", "/usr/bin/sh", "/bin/sh");
                if (shLocation == null) {
                    if (this.command().isEmpty()) {
                        throw new IOException("Nothing to execute.");
                    }
                } else {
                    if (this.loginShell) {
                        this.command().add(0, "--login");
                    }
                    this.command().add(0, shLocation);
                    if (this.rcfile != null) {
                        this.environment().put("ENV", this.rcfile.getAbsolutePath());
                    }
                }
            } else {
                if (this.rcfile != null) {
                    this.command().add(0, this.rcfile.getAbsolutePath());
                    this.command().add(0, "--rcfile");
                }
                if (this.loginShell) {
                    this.command().add(0, "--login");
                }
                this.command().add(0, shLocation);
            }
        } else if (SystemUtils.IS_OS_WINDOWS) {
            this.command().add(0, "CMD.exe");
            this.command().add(0, "/c");
            this.command().add(0, "start");
        }
        return super.start();
    }

    private String findCommand(String command, String ... places) throws IOException {
        Collection<String> stdbuf = OSCommand.runCommandAndCaptureOutput("which", command);
        if (stdbuf.isEmpty()) {
            for (String place : places) {
                File f = new File(place);
                if (!f.exists()) continue;
                return f.getAbsolutePath();
            }
        }
        return stdbuf.iterator().next();
    }
}

