/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.forker.client.impl;

import com.sshtools.forker.client.ForkerProcess;
import com.sshtools.forker.client.ForkerProcessListener;
import com.sshtools.forker.common.Command;
import com.sshtools.forker.common.Cookie;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class ForkerDaemonProcess
extends ForkerProcess {
    private DataOutputStream dout;
    private DataInputStream din;
    private OutputStream out;
    private PipedOutputStream inOut;
    private PipedOutputStream errOut;
    private PipedInputStream in;
    private PipedInputStream err;
    private Thread thread;
    private int exitValue = Integer.MIN_VALUE;
    private int ptyWidth;
    private int ptyHeight;
    private List<Listener> listeners = new ArrayList<Listener>();
    private Command command;
    private OutputFlushMode outputFlushMode = OutputFlushMode.AUTO;

    public ForkerDaemonProcess(Command command) {
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        Cookie.Instance cookie = Cookie.get().load();
        if (cookie == null) {
            throw new ConnectException("The forker daemon is not running.");
        }
        final Socket s = new Socket("127.0.0.1", cookie.getPort());
        boolean ok = false;
        try {
            this.dout = new DataOutputStream(s.getOutputStream());
            this.din = new DataInputStream(s.getInputStream());
            this.dout.writeUTF(cookie.getCookie());
            this.dout.write(0);
            this.dout.flush();
            int result = this.din.readInt();
            if (result == 1) {
                throw new IOException("Cookie rejected.");
            }
            this.command.write(this.dout);
            this.dout.flush();
            result = this.din.readInt();
            if (result == 1) {
                String mesg = this.din.readUTF();
                System.out.println("FORK: Command failed " + mesg);
                try {
                    this.dout.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.din.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new IOException(mesg);
            }
            if (result == 11) {
                this.ptyWidth = this.din.readInt();
                this.ptyHeight = this.din.readInt();
            }
            this.inOut = new PipedOutputStream();
            this.errOut = new PipedOutputStream();
            this.in = new PipedInputStream(this.inOut){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    super.close();
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.notifyAll();
                    }
                }
            };
            this.err = new PipedInputStream(this.errOut);
            ok = true;
        }
        finally {
            if (!ok) {
                s.close();
            }
        }
        this.thread = new Thread("ForkerIn" + this.command.getArguments()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean run = true;
                    while (run) {
                        int cmd = ForkerDaemonProcess.this.din.readInt();
                        switch (cmd) {
                            case 11: {
                                ForkerDaemonProcess.this.ptyWidth = ForkerDaemonProcess.this.din.readInt();
                                ForkerDaemonProcess.this.ptyHeight = ForkerDaemonProcess.this.din.readInt();
                                ForkerDaemonProcess.this.windowSizeChange(ForkerDaemonProcess.this.ptyWidth, ForkerDaemonProcess.this.ptyHeight);
                                break;
                            }
                            case 4: {
                                run = false;
                                ForkerDaemonProcess.this.exitValue = ForkerDaemonProcess.this.din.readInt();
                                DataOutputStream dataOutputStream = ForkerDaemonProcess.this.dout;
                                synchronized (dataOutputStream) {
                                    try {
                                        ForkerDaemonProcess.this.dout.writeInt(4);
                                        ForkerDaemonProcess.this.dout.flush();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    ForkerDaemonProcess.this.inOut.close();
                                    ForkerDaemonProcess.this.errOut.close();
                                    break;
                                }
                            }
                            case 2: {
                                int len = ForkerDaemonProcess.this.din.readInt();
                                byte[] b = new byte[len];
                                ForkerDaemonProcess.this.din.readFully(b);
                                ForkerDaemonProcess.this.inOut.write(b);
                                ForkerDaemonProcess.this.inOut.flush();
                                break;
                            }
                            case 3: {
                                int len = ForkerDaemonProcess.this.din.readInt();
                                byte[] b = new byte[len];
                                ForkerDaemonProcess.this.din.readFully(b);
                                ForkerDaemonProcess.this.errOut.write(b);
                                ForkerDaemonProcess.this.errOut.flush();
                                break;
                            }
                            case 1: {
                                String mesg = ForkerDaemonProcess.this.din.readUTF();
                                throw new IOException("Remote error." + mesg);
                            }
                            default: {
                                throw new IllegalStateException("Unknown forker command '" + cmd + "'");
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                finally {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        this.thread.start();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new OutputStream(){
                private boolean closed;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(int b) throws IOException {
                    if (this.closed) {
                        throw new IOException("Closed.");
                    }
                    DataOutputStream dataOutputStream = ForkerDaemonProcess.this.dout;
                    synchronized (dataOutputStream) {
                        ForkerDaemonProcess.this.dout.writeInt(5);
                        ForkerDaemonProcess.this.dout.writeInt(1);
                        ForkerDaemonProcess.this.dout.write((byte)b);
                        this.maybeFlush();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(byte[] b) throws IOException {
                    if (this.closed) {
                        throw new IOException("Closed.");
                    }
                    DataOutputStream dataOutputStream = ForkerDaemonProcess.this.dout;
                    synchronized (dataOutputStream) {
                        ForkerDaemonProcess.this.dout.writeInt(5);
                        ForkerDaemonProcess.this.dout.writeInt(b.length);
                        ForkerDaemonProcess.this.dout.write(b);
                        this.maybeFlush();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    if (this.closed) {
                        throw new IOException("Closed.");
                    }
                    DataOutputStream dataOutputStream = ForkerDaemonProcess.this.dout;
                    synchronized (dataOutputStream) {
                        ForkerDaemonProcess.this.dout.writeInt(5);
                        ForkerDaemonProcess.this.dout.writeInt(len);
                        ForkerDaemonProcess.this.dout.write(b, off, len);
                        this.maybeFlush();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void flush() throws IOException {
                    if (this.closed) {
                        throw new IOException("Closed.");
                    }
                    DataOutputStream dataOutputStream = ForkerDaemonProcess.this.dout;
                    synchronized (dataOutputStream) {
                        ForkerDaemonProcess.this.dout.writeInt(10);
                        ForkerDaemonProcess.this.dout.flush();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        throw new IOException("Already closed.");
                    }
                    this.closed = true;
                    try {
                        DataOutputStream dataOutputStream = ForkerDaemonProcess.this.dout;
                        synchronized (dataOutputStream) {
                            ForkerDaemonProcess.this.dout.writeInt(7);
                            this.flush();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }

                private void maybeFlush() throws IOException {
                    switch (ForkerDaemonProcess.this.outputFlushMode) {
                        case AUTO: {
                            if (!ForkerDaemonProcess.this.command.getIO().isAutoFlushStdIn()) break;
                            this.flush();
                            break;
                        }
                        case LOCAL: {
                            ForkerDaemonProcess.this.dout.flush();
                            break;
                        }
                        case BOTH: {
                            this.flush();
                            break;
                        }
                    }
                }
            };
        }
        return this.out;
    }

    public int getPtyWidth() {
        return this.ptyWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPtyWidth(int ptyWidth) {
        this.ptyWidth = ptyWidth;
        DataOutputStream dataOutputStream = this.dout;
        synchronized (dataOutputStream) {
            try {
                this.dout.writeInt(11);
                this.dout.writeInt(ptyWidth);
                this.dout.writeInt(this.ptyHeight);
                this.dout.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getPtyHeight() {
        return this.ptyHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPtyHeight(int ptyHeight) {
        this.ptyHeight = ptyHeight;
        DataOutputStream dataOutputStream = this.dout;
        synchronized (dataOutputStream) {
            try {
                this.dout.writeInt(11);
                this.dout.writeInt(this.ptyWidth);
                this.dout.writeInt(ptyHeight);
                this.dout.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPtySize(int ptyWidth, int ptyHeight) {
        this.ptyWidth = ptyWidth;
        this.ptyHeight = ptyHeight;
        DataOutputStream dataOutputStream = this.dout;
        synchronized (dataOutputStream) {
            try {
                this.dout.writeInt(11);
                this.dout.writeInt(ptyWidth);
                this.dout.writeInt(ptyHeight);
                this.dout.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public InputStream getErrorStream() {
        return this.err;
    }

    @Override
    public int waitFor() throws InterruptedException {
        this.thread.join();
        return this.exitValue();
    }

    @Override
    public int exitValue() {
        return this.exitValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        DataOutputStream dataOutputStream = this.dout;
        synchronized (dataOutputStream) {
            try {
                this.dout.writeInt(6);
                this.dout.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void windowSizeChange(int ptyWidth, int ptyHeight) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).windowSizeChanged(ptyWidth, ptyHeight);
        }
    }

    public static interface Listener
    extends ForkerProcessListener {
        public void windowSizeChanged(int var1, int var2);
    }

    public static enum OutputFlushMode {
        MANUAL,
        AUTO,
        LOCAL,
        BOTH;

    }
}

